/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableLicenseField {
    ACCOUNT_ID("AccountId"),

    RESOURCE_ARN("ResourceArn"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    FINDING("Finding"),

    FINDING_REASON_CODES("FindingReasonCodes"),

    CURRENT_LICENSE_CONFIGURATION_NUMBER_OF_CORES("CurrentLicenseConfigurationNumberOfCores"),

    CURRENT_LICENSE_CONFIGURATION_INSTANCE_TYPE("CurrentLicenseConfigurationInstanceType"),

    CURRENT_LICENSE_CONFIGURATION_OPERATING_SYSTEM("CurrentLicenseConfigurationOperatingSystem"),

    CURRENT_LICENSE_CONFIGURATION_LICENSE_NAME("CurrentLicenseConfigurationLicenseName"),

    CURRENT_LICENSE_CONFIGURATION_LICENSE_EDITION("CurrentLicenseConfigurationLicenseEdition"),

    CURRENT_LICENSE_CONFIGURATION_LICENSE_MODEL("CurrentLicenseConfigurationLicenseModel"),

    CURRENT_LICENSE_CONFIGURATION_LICENSE_VERSION("CurrentLicenseConfigurationLicenseVersion"),

    CURRENT_LICENSE_CONFIGURATION_METRICS_SOURCE("CurrentLicenseConfigurationMetricsSource"),

    RECOMMENDATION_OPTIONS_OPERATING_SYSTEM("RecommendationOptionsOperatingSystem"),

    RECOMMENDATION_OPTIONS_LICENSE_EDITION("RecommendationOptionsLicenseEdition"),

    RECOMMENDATION_OPTIONS_LICENSE_MODEL("RecommendationOptionsLicenseModel"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    TAGS("Tags"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableLicenseField> VALUE_MAP = EnumUtils.uniqueIndex(ExportableLicenseField.class,
            ExportableLicenseField::toString);

    private final String value;

    private ExportableLicenseField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableLicenseField corresponding to the value
     */
    public static ExportableLicenseField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableLicenseField}s
     */
    public static Set<ExportableLicenseField> knownValues() {
        Set<ExportableLicenseField> knownValues = EnumSet.allOf(ExportableLicenseField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
