/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recommendation options for an Amazon ECS service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ECSServiceRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<ECSServiceRecommendationOption.Builder, ECSServiceRecommendationOption> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(ECSServiceRecommendationOption::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("cpu")
            .getter(getter(ECSServiceRecommendationOption::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(ECSServiceRecommendationOption::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<ECSSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField
            .<ECSSavingsOpportunityAfterDiscounts> builder(MarshallingType.SDK_POJO)
            .memberName("savingsOpportunityAfterDiscounts")
            .getter(getter(ECSServiceRecommendationOption::savingsOpportunityAfterDiscounts))
            .setter(setter(Builder::savingsOpportunityAfterDiscounts))
            .constructor(ECSSavingsOpportunityAfterDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts")
                    .build()).build();

    private static final SdkField<List<ECSServiceProjectedUtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField
            .<List<ECSServiceProjectedUtilizationMetric>> builder(MarshallingType.LIST)
            .memberName("projectedUtilizationMetrics")
            .getter(getter(ECSServiceRecommendationOption::projectedUtilizationMetrics))
            .setter(setter(Builder::projectedUtilizationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSServiceProjectedUtilizationMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSServiceProjectedUtilizationMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContainerRecommendation>> CONTAINER_RECOMMENDATIONS_FIELD = SdkField
            .<List<ContainerRecommendation>> builder(MarshallingType.LIST)
            .memberName("containerRecommendations")
            .getter(getter(ECSServiceRecommendationOption::containerRecommendations))
            .setter(setter(Builder::containerRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPU_FIELD,
            SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD,
            CONTAINER_RECOMMENDATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer memory;

    private final Integer cpu;

    private final SavingsOpportunity savingsOpportunity;

    private final ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private final List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics;

    private final List<ContainerRecommendation> containerRecommendations;

    private ECSServiceRecommendationOption(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpu = builder.cpu;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.containerRecommendations = builder.containerRecommendations;
    }

    /**
     * <p>
     * The memory size of the Amazon ECS service recommendation option.
     * </p>
     * 
     * @return The memory size of the Amazon ECS service recommendation option.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The CPU size of the Amazon ECS service recommendation option.
     * </p>
     * 
     * @return The CPU size of the Amazon ECS service recommendation option.
     */
    public final Integer cpu() {
        return cpu;
    }

    /**
     * Returns the value of the SavingsOpportunity property for this object.
     * 
     * @return The value of the SavingsOpportunity property for this object.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation option.
     * </p>
     * <p>
     * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
     * achieve this by implementing a given Compute Optimizer recommendation.
     * </p>
     * 
     * @return Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation
     *         option. </p>
     *         <p>
     *         Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You
     *         can achieve this by implementing a given Compute Optimizer recommendation.
     */
    public final ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return savingsOpportunityAfterDiscounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectedUtilizationMetrics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProjectedUtilizationMetrics() {
        return projectedUtilizationMetrics != null && !(projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation
     * option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectedUtilizationMetrics} method.
     * </p>
     * 
     * @return An array of objects that describe the projected utilization metrics of the Amazon ECS service
     *         recommendation option.
     */
    public final List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics() {
        return projectedUtilizationMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerRecommendations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerRecommendations() {
        return containerRecommendations != null && !(containerRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerRecommendations} method.
     * </p>
     * 
     * @return The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
     */
    public final List<ContainerRecommendation> containerRecommendations() {
        return containerRecommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityAfterDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerRecommendations() ? containerRecommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendationOption)) {
            return false;
        }
        ECSServiceRecommendationOption other = (ECSServiceRecommendationOption) obj;
        return Objects.equals(memory(), other.memory()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts())
                && hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics()
                && Objects.equals(projectedUtilizationMetrics(), other.projectedUtilizationMetrics())
                && hasContainerRecommendations() == other.hasContainerRecommendations()
                && Objects.equals(containerRecommendations(), other.containerRecommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ECSServiceRecommendationOption").add("Memory", memory()).add("Cpu", cpu())
                .add("SavingsOpportunity", savingsOpportunity())
                .add("SavingsOpportunityAfterDiscounts", savingsOpportunityAfterDiscounts())
                .add("ProjectedUtilizationMetrics", hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null)
                .add("ContainerRecommendations", hasContainerRecommendations() ? containerRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "savingsOpportunityAfterDiscounts":
            return Optional.ofNullable(clazz.cast(savingsOpportunityAfterDiscounts()));
        case "projectedUtilizationMetrics":
            return Optional.ofNullable(clazz.cast(projectedUtilizationMetrics()));
        case "containerRecommendations":
            return Optional.ofNullable(clazz.cast(containerRecommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceRecommendationOption, T> g) {
        return obj -> g.apply((ECSServiceRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ECSServiceRecommendationOption> {
        /**
         * <p>
         * The memory size of the Amazon ECS service recommendation option.
         * </p>
         * 
         * @param memory
         *        The memory size of the Amazon ECS service recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The CPU size of the Amazon ECS service recommendation option.
         * </p>
         * 
         * @param cpu
         *        The CPU size of the Amazon ECS service recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * @param savingsOpportunity
         *        The new value for the SavingsOpportunity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * 
         * @param savingsOpportunityAfterDiscounts
         *        Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation
         *        option. </p>
         *        <p>
         *        Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts.
         *        You can achieve this by implementing a given Compute Optimizer recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts);

        /**
         * <p>
         * Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ECSSavingsOpportunityAfterDiscounts.Builder} avoiding the need to create one manually via
         * {@link ECSSavingsOpportunityAfterDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ECSSavingsOpportunityAfterDiscounts.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts)}.
         * 
         * @param savingsOpportunityAfterDiscounts
         *        a consumer that will call methods on {@link ECSSavingsOpportunityAfterDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts)
         */
        default Builder savingsOpportunityAfterDiscounts(
                Consumer<ECSSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts.builder()
                    .applyMutation(savingsOpportunityAfterDiscounts).build());
        }

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation
         * option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the Amazon ECS service
         *        recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(Collection<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation
         * option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the Amazon ECS service
         *        recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(ECSServiceProjectedUtilizationMetric... projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation
         * option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #projectedUtilizationMetrics(List<ECSServiceProjectedUtilizationMetric>)}.
         * 
         * @param projectedUtilizationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectedUtilizationMetrics(java.util.Collection<ECSServiceProjectedUtilizationMetric>)
         */
        Builder projectedUtilizationMetrics(Consumer<ECSServiceProjectedUtilizationMetric.Builder>... projectedUtilizationMetrics);

        /**
         * <p>
         * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         * </p>
         * 
         * @param containerRecommendations
         *        The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecommendations(Collection<ContainerRecommendation> containerRecommendations);

        /**
         * <p>
         * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         * </p>
         * 
         * @param containerRecommendations
         *        The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecommendations(ContainerRecommendation... containerRecommendations);

        /**
         * <p>
         * The CPU and memory size recommendations for the containers within the task of your Amazon ECS service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #containerRecommendations(List<ContainerRecommendation>)}.
         * 
         * @param containerRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerRecommendations(java.util.Collection<ContainerRecommendation>)
         */
        Builder containerRecommendations(Consumer<ContainerRecommendation.Builder>... containerRecommendations);
    }

    static final class BuilderImpl implements Builder {
        private Integer memory;

        private Integer cpu;

        private SavingsOpportunity savingsOpportunity;

        private ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList
                .getInstance();

        private List<ContainerRecommendation> containerRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceRecommendationOption model) {
            memory(model.memory);
            cpu(model.cpu);
            savingsOpportunity(model.savingsOpportunity);
            savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
            projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            containerRecommendations(model.containerRecommendations);
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getCpu() {
            return cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final ECSSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(
                ECSSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts
                    .build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public final List<ECSServiceProjectedUtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<ECSServiceProjectedUtilizationMetric.Builder> result = ECSServiceProjectedUtilizationMetricsCopier
                    .copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(
                Collection<ECSServiceProjectedUtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ECSServiceProjectedUtilizationMetricsCopier
                    .copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(
                Collection<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ECSServiceProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(ECSServiceProjectedUtilizationMetric... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(
                Consumer<ECSServiceProjectedUtilizationMetric.Builder>... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics)
                    .map(c -> ECSServiceProjectedUtilizationMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerRecommendation.Builder> getContainerRecommendations() {
            List<ContainerRecommendation.Builder> result = ContainerRecommendationsCopier
                    .copyToBuilder(this.containerRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerRecommendations(Collection<ContainerRecommendation.BuilderImpl> containerRecommendations) {
            this.containerRecommendations = ContainerRecommendationsCopier.copyFromBuilder(containerRecommendations);
        }

        @Override
        public final Builder containerRecommendations(Collection<ContainerRecommendation> containerRecommendations) {
            this.containerRecommendations = ContainerRecommendationsCopier.copy(containerRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecommendations(ContainerRecommendation... containerRecommendations) {
            containerRecommendations(Arrays.asList(containerRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecommendations(Consumer<ContainerRecommendation.Builder>... containerRecommendations) {
            containerRecommendations(Stream.of(containerRecommendations)
                    .map(c -> ContainerRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ECSServiceRecommendationOption build() {
            return new ECSServiceRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
