/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CPU and memory recommendations for a container within the tasks of your Amazon ECS service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerRecommendation.Builder, ContainerRecommendation> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(ContainerRecommendation::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<MemorySizeConfiguration> MEMORY_SIZE_CONFIGURATION_FIELD = SdkField
            .<MemorySizeConfiguration> builder(MarshallingType.SDK_POJO).memberName("memorySizeConfiguration")
            .getter(getter(ContainerRecommendation::memorySizeConfiguration)).setter(setter(Builder::memorySizeConfiguration))
            .constructor(MemorySizeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeConfiguration").build())
            .build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("cpu")
            .getter(getter(ContainerRecommendation::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            MEMORY_SIZE_CONFIGURATION_FIELD, CPU_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final MemorySizeConfiguration memorySizeConfiguration;

    private final Integer cpu;

    private ContainerRecommendation(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.memorySizeConfiguration = builder.memorySizeConfiguration;
        this.cpu = builder.cpu;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The recommended memory size configurations for the container.
     * </p>
     * 
     * @return The recommended memory size configurations for the container.
     */
    public final MemorySizeConfiguration memorySizeConfiguration() {
        return memorySizeConfiguration;
    }

    /**
     * <p>
     * The recommended number of CPU units reserved for the container.
     * </p>
     * 
     * @return The recommended number of CPU units reserved for the container.
     */
    public final Integer cpu() {
        return cpu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRecommendation)) {
            return false;
        }
        ContainerRecommendation other = (ContainerRecommendation) obj;
        return Objects.equals(containerName(), other.containerName())
                && Objects.equals(memorySizeConfiguration(), other.memorySizeConfiguration())
                && Objects.equals(cpu(), other.cpu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerRecommendation").add("ContainerName", containerName())
                .add("MemorySizeConfiguration", memorySizeConfiguration()).add("Cpu", cpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "memorySizeConfiguration":
            return Optional.ofNullable(clazz.cast(memorySizeConfiguration()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerRecommendation, T> g) {
        return obj -> g.apply((ContainerRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerRecommendation> {
        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param containerName
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The recommended memory size configurations for the container.
         * </p>
         * 
         * @param memorySizeConfiguration
         *        The recommended memory size configurations for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeConfiguration(MemorySizeConfiguration memorySizeConfiguration);

        /**
         * <p>
         * The recommended memory size configurations for the container.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemorySizeConfiguration.Builder} avoiding
         * the need to create one manually via {@link MemorySizeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemorySizeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #memorySizeConfiguration(MemorySizeConfiguration)}.
         * 
         * @param memorySizeConfiguration
         *        a consumer that will call methods on {@link MemorySizeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memorySizeConfiguration(MemorySizeConfiguration)
         */
        default Builder memorySizeConfiguration(Consumer<MemorySizeConfiguration.Builder> memorySizeConfiguration) {
            return memorySizeConfiguration(MemorySizeConfiguration.builder().applyMutation(memorySizeConfiguration).build());
        }

        /**
         * <p>
         * The recommended number of CPU units reserved for the container.
         * </p>
         * 
         * @param cpu
         *        The recommended number of CPU units reserved for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private MemorySizeConfiguration memorySizeConfiguration;

        private Integer cpu;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRecommendation model) {
            containerName(model.containerName);
            memorySizeConfiguration(model.memorySizeConfiguration);
            cpu(model.cpu);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final MemorySizeConfiguration.Builder getMemorySizeConfiguration() {
            return memorySizeConfiguration != null ? memorySizeConfiguration.toBuilder() : null;
        }

        public final void setMemorySizeConfiguration(MemorySizeConfiguration.BuilderImpl memorySizeConfiguration) {
            this.memorySizeConfiguration = memorySizeConfiguration != null ? memorySizeConfiguration.build() : null;
        }

        @Override
        public final Builder memorySizeConfiguration(MemorySizeConfiguration memorySizeConfiguration) {
            this.memorySizeConfiguration = memorySizeConfiguration;
            return this;
        }

        public final Integer getCpu() {
            return cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        @Override
        public ContainerRecommendation build() {
            return new ContainerRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
