/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSyncConfigurationResponse extends CodeStarConnectionsResponse implements
        ToCopyableBuilder<CreateSyncConfigurationResponse.Builder, CreateSyncConfigurationResponse> {
    private static final SdkField<SyncConfiguration> SYNC_CONFIGURATION_FIELD = SdkField
            .<SyncConfiguration> builder(MarshallingType.SDK_POJO).memberName("SyncConfiguration")
            .getter(getter(CreateSyncConfigurationResponse::syncConfiguration)).setter(setter(Builder::syncConfiguration))
            .constructor(SyncConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_CONFIGURATION_FIELD));

    private final SyncConfiguration syncConfiguration;

    private CreateSyncConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.syncConfiguration = builder.syncConfiguration;
    }

    /**
     * <p>
     * The created sync configuration for the connection. A sync configuration allows Amazon Web Services to sync
     * content from a Git repository to update a specified Amazon Web Services resource.
     * </p>
     * 
     * @return The created sync configuration for the connection. A sync configuration allows Amazon Web Services to
     *         sync content from a Git repository to update a specified Amazon Web Services resource.
     */
    public final SyncConfiguration syncConfiguration() {
        return syncConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syncConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSyncConfigurationResponse)) {
            return false;
        }
        CreateSyncConfigurationResponse other = (CreateSyncConfigurationResponse) obj;
        return Objects.equals(syncConfiguration(), other.syncConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSyncConfigurationResponse").add("SyncConfiguration", syncConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncConfiguration":
            return Optional.ofNullable(clazz.cast(syncConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSyncConfigurationResponse, T> g) {
        return obj -> g.apply((CreateSyncConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarConnectionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSyncConfigurationResponse> {
        /**
         * <p>
         * The created sync configuration for the connection. A sync configuration allows Amazon Web Services to sync
         * content from a Git repository to update a specified Amazon Web Services resource.
         * </p>
         * 
         * @param syncConfiguration
         *        The created sync configuration for the connection. A sync configuration allows Amazon Web Services to
         *        sync content from a Git repository to update a specified Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfiguration(SyncConfiguration syncConfiguration);

        /**
         * <p>
         * The created sync configuration for the connection. A sync configuration allows Amazon Web Services to sync
         * content from a Git repository to update a specified Amazon Web Services resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncConfiguration.Builder} avoiding the
         * need to create one manually via {@link SyncConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #syncConfiguration(SyncConfiguration)}.
         * 
         * @param syncConfiguration
         *        a consumer that will call methods on {@link SyncConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfiguration(SyncConfiguration)
         */
        default Builder syncConfiguration(Consumer<SyncConfiguration.Builder> syncConfiguration) {
            return syncConfiguration(SyncConfiguration.builder().applyMutation(syncConfiguration).build());
        }
    }

    static final class BuilderImpl extends CodeStarConnectionsResponse.BuilderImpl implements Builder {
        private SyncConfiguration syncConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSyncConfigurationResponse model) {
            super(model);
            syncConfiguration(model.syncConfiguration);
        }

        public final SyncConfiguration.Builder getSyncConfiguration() {
            return syncConfiguration != null ? syncConfiguration.toBuilder() : null;
        }

        public final void setSyncConfiguration(SyncConfiguration.BuilderImpl syncConfiguration) {
            this.syncConfiguration = syncConfiguration != null ? syncConfiguration.build() : null;
        }

        @Override
        public final Builder syncConfiguration(SyncConfiguration syncConfiguration) {
            this.syncConfiguration = syncConfiguration;
            return this;
        }

        @Override
        public CreateSyncConfigurationResponse build() {
            return new CreateSyncConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
