/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the state of the stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageState implements SdkPojo, Serializable, ToCopyableBuilder<StageState.Builder, StageState> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(StageState::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<StageExecution> INBOUND_EXECUTION_FIELD = SdkField
            .<StageExecution> builder(MarshallingType.SDK_POJO).memberName("inboundExecution")
            .getter(getter(StageState::inboundExecution)).setter(setter(Builder::inboundExecution))
            .constructor(StageExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecution").build()).build();

    private static final SdkField<List<StageExecution>> INBOUND_EXECUTIONS_FIELD = SdkField
            .<List<StageExecution>> builder(MarshallingType.LIST)
            .memberName("inboundExecutions")
            .getter(getter(StageState::inboundExecutions))
            .setter(setter(Builder::inboundExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TransitionState> INBOUND_TRANSITION_STATE_FIELD = SdkField
            .<TransitionState> builder(MarshallingType.SDK_POJO).memberName("inboundTransitionState")
            .getter(getter(StageState::inboundTransitionState)).setter(setter(Builder::inboundTransitionState))
            .constructor(TransitionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundTransitionState").build())
            .build();

    private static final SdkField<List<ActionState>> ACTION_STATES_FIELD = SdkField
            .<List<ActionState>> builder(MarshallingType.LIST)
            .memberName("actionStates")
            .getter(getter(StageState::actionStates))
            .setter(setter(Builder::actionStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StageExecution> LATEST_EXECUTION_FIELD = SdkField
            .<StageExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(StageState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(StageExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD,
            INBOUND_EXECUTION_FIELD, INBOUND_EXECUTIONS_FIELD, INBOUND_TRANSITION_STATE_FIELD, ACTION_STATES_FIELD,
            LATEST_EXECUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stageName;

    private final StageExecution inboundExecution;

    private final List<StageExecution> inboundExecutions;

    private final TransitionState inboundTransitionState;

    private final List<ActionState> actionStates;

    private final StageExecution latestExecution;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundExecution = builder.inboundExecution;
        this.inboundExecutions = builder.inboundExecutions;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * Returns the value of the InboundExecution property for this object.
     * 
     * @return The value of the InboundExecution property for this object.
     */
    public final StageExecution inboundExecution() {
        return inboundExecution;
    }

    /**
     * For responses, this returns true if the service returned a value for the InboundExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInboundExecutions() {
        return inboundExecutions != null && !(inboundExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound executions for a stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInboundExecutions} method.
     * </p>
     * 
     * @return The inbound executions for a stage.
     */
    public final List<StageExecution> inboundExecutions() {
        return inboundExecutions;
    }

    /**
     * <p>
     * The state of the inbound transition, which is either enabled or disabled.
     * </p>
     * 
     * @return The state of the inbound transition, which is either enabled or disabled.
     */
    public final TransitionState inboundTransitionState() {
        return inboundTransitionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionStates() {
        return actionStates != null && !(actionStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionStates} method.
     * </p>
     * 
     * @return The state of the stage.
     */
    public final List<ActionState> actionStates() {
        return actionStates;
    }

    /**
     * <p>
     * Information about the latest execution in the stage, including its ID and status.
     * </p>
     * 
     * @return Information about the latest execution in the stage, including its ID and status.
     */
    public final StageExecution latestExecution() {
        return latestExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(inboundExecution());
        hashCode = 31 * hashCode + Objects.hashCode(hasInboundExecutions() ? inboundExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inboundTransitionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionStates() ? actionStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState) obj;
        return Objects.equals(stageName(), other.stageName()) && Objects.equals(inboundExecution(), other.inboundExecution())
                && hasInboundExecutions() == other.hasInboundExecutions()
                && Objects.equals(inboundExecutions(), other.inboundExecutions())
                && Objects.equals(inboundTransitionState(), other.inboundTransitionState())
                && hasActionStates() == other.hasActionStates() && Objects.equals(actionStates(), other.actionStates())
                && Objects.equals(latestExecution(), other.latestExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageState").add("StageName", stageName()).add("InboundExecution", inboundExecution())
                .add("InboundExecutions", hasInboundExecutions() ? inboundExecutions() : null)
                .add("InboundTransitionState", inboundTransitionState())
                .add("ActionStates", hasActionStates() ? actionStates() : null).add("LatestExecution", latestExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "inboundExecution":
            return Optional.ofNullable(clazz.cast(inboundExecution()));
        case "inboundExecutions":
            return Optional.ofNullable(clazz.cast(inboundExecutions()));
        case "inboundTransitionState":
            return Optional.ofNullable(clazz.cast(inboundTransitionState()));
        case "actionStates":
            return Optional.ofNullable(clazz.cast(actionStates()));
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageState, T> g) {
        return obj -> g.apply((StageState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageState> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * Sets the value of the InboundExecution property for this object.
         *
         * @param inboundExecution
         *        The new value for the InboundExecution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecution(StageExecution inboundExecution);

        /**
         * Sets the value of the InboundExecution property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StageExecution.Builder} avoiding the need
         * to create one manually via {@link StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundExecution(StageExecution)}.
         * 
         * @param inboundExecution
         *        a consumer that will call methods on {@link StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundExecution(StageExecution)
         */
        default Builder inboundExecution(Consumer<StageExecution.Builder> inboundExecution) {
            return inboundExecution(StageExecution.builder().applyMutation(inboundExecution).build());
        }

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * 
         * @param inboundExecutions
         *        The inbound executions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecutions(Collection<StageExecution> inboundExecutions);

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * 
         * @param inboundExecutions
         *        The inbound executions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecutions(StageExecution... inboundExecutions);

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder#build()} is called
         * immediately and its result is passed to {@link #inboundExecutions(List<StageExecution>)}.
         * 
         * @param inboundExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundExecutions(java.util.Collection<StageExecution>)
         */
        Builder inboundExecutions(Consumer<StageExecution.Builder>... inboundExecutions);

        /**
         * <p>
         * The state of the inbound transition, which is either enabled or disabled.
         * </p>
         * 
         * @param inboundTransitionState
         *        The state of the inbound transition, which is either enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundTransitionState(TransitionState inboundTransitionState);

        /**
         * <p>
         * The state of the inbound transition, which is either enabled or disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitionState.Builder} avoiding the
         * need to create one manually via {@link TransitionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitionState.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundTransitionState(TransitionState)}.
         * 
         * @param inboundTransitionState
         *        a consumer that will call methods on {@link TransitionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundTransitionState(TransitionState)
         */
        default Builder inboundTransitionState(Consumer<TransitionState.Builder> inboundTransitionState) {
            return inboundTransitionState(TransitionState.builder().applyMutation(inboundTransitionState).build());
        }

        /**
         * <p>
         * The state of the stage.
         * </p>
         * 
         * @param actionStates
         *        The state of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionStates(Collection<ActionState> actionStates);

        /**
         * <p>
         * The state of the stage.
         * </p>
         * 
         * @param actionStates
         *        The state of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionStates(ActionState... actionStates);

        /**
         * <p>
         * The state of the stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.ActionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder#build()} is called immediately
         * and its result is passed to {@link #actionStates(List<ActionState>)}.
         * 
         * @param actionStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionStates(java.util.Collection<ActionState>)
         */
        Builder actionStates(Consumer<ActionState.Builder>... actionStates);

        /**
         * <p>
         * Information about the latest execution in the stage, including its ID and status.
         * </p>
         * 
         * @param latestExecution
         *        Information about the latest execution in the stage, including its ID and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(StageExecution latestExecution);

        /**
         * <p>
         * Information about the latest execution in the stage, including its ID and status.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageExecution.Builder} avoiding the need
         * to create one manually via {@link StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #latestExecution(StageExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(StageExecution)
         */
        default Builder latestExecution(Consumer<StageExecution.Builder> latestExecution) {
            return latestExecution(StageExecution.builder().applyMutation(latestExecution).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stageName;

        private StageExecution inboundExecution;

        private List<StageExecution> inboundExecutions = DefaultSdkAutoConstructList.getInstance();

        private TransitionState inboundTransitionState;

        private List<ActionState> actionStates = DefaultSdkAutoConstructList.getInstance();

        private StageExecution latestExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            stageName(model.stageName);
            inboundExecution(model.inboundExecution);
            inboundExecutions(model.inboundExecutions);
            inboundTransitionState(model.inboundTransitionState);
            actionStates(model.actionStates);
            latestExecution(model.latestExecution);
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final StageExecution.Builder getInboundExecution() {
            return inboundExecution != null ? inboundExecution.toBuilder() : null;
        }

        public final void setInboundExecution(StageExecution.BuilderImpl inboundExecution) {
            this.inboundExecution = inboundExecution != null ? inboundExecution.build() : null;
        }

        @Override
        public final Builder inboundExecution(StageExecution inboundExecution) {
            this.inboundExecution = inboundExecution;
            return this;
        }

        public final List<StageExecution.Builder> getInboundExecutions() {
            List<StageExecution.Builder> result = StageExecutionListCopier.copyToBuilder(this.inboundExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundExecutions(Collection<StageExecution.BuilderImpl> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copyFromBuilder(inboundExecutions);
        }

        @Override
        public final Builder inboundExecutions(Collection<StageExecution> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copy(inboundExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(StageExecution... inboundExecutions) {
            inboundExecutions(Arrays.asList(inboundExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(Consumer<StageExecution.Builder>... inboundExecutions) {
            inboundExecutions(Stream.of(inboundExecutions).map(c -> StageExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TransitionState.Builder getInboundTransitionState() {
            return inboundTransitionState != null ? inboundTransitionState.toBuilder() : null;
        }

        public final void setInboundTransitionState(TransitionState.BuilderImpl inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState != null ? inboundTransitionState.build() : null;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final List<ActionState.Builder> getActionStates() {
            List<ActionState.Builder> result = ActionStateListCopier.copyToBuilder(this.actionStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionStates(Collection<ActionState.BuilderImpl> actionStates) {
            this.actionStates = ActionStateListCopier.copyFromBuilder(actionStates);
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState... actionStates) {
            actionStates(Arrays.asList(actionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(Consumer<ActionState.Builder>... actionStates) {
            actionStates(Stream.of(actionStates).map(c -> ActionState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StageExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(StageExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        @Override
        public StageState build() {
            return new StageState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
