/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.TagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.TagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsPublisher;
import software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher;
import software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsPublisher;
import software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher;
import software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher;

/**
 * Service client for accessing CodePipeline asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>CodePipeline</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is the CodePipeline API Reference. This guide provides descriptions of the actions and data types for
 * CodePipeline. Some functionality for your pipeline can only be configured through the API. For more information, see
 * the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html">CodePipeline User Guide</a>.
 * </p>
 * <p>
 * You can use the CodePipeline API to work with pipelines, stages, actions, and transitions.
 * </p>
 * <p>
 * <i>Pipelines</i> are models of automated release processes. Each pipeline is uniquely named, and consists of stages,
 * actions, and transitions.
 * </p>
 * <p>
 * You can work with pipelines by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreatePipeline</a>, which creates a uniquely named pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeletePipeline</a>, which deletes the specified pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPipeline</a>, which returns information about the pipeline structure and pipeline metadata, including the
 * pipeline Amazon Resource Name (ARN).
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPipelineExecution</a>, which returns information about a specific execution of a pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPipelineState</a>, which returns information about the current state of the stages and actions of a pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListActionExecutions</a>, which returns action-level details for past executions. The details include full stage
 * and action-level details, including individual action duration, status, any errors that occurred during the
 * execution, and input and output artifact location details.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListPipelines</a>, which gets a summary of all of the pipelines associated with your account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListPipelineExecutions</a>, which gets a summary of the most recent executions for a pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StartPipelineExecution</a>, which runs the most recent revision of an artifact through the pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>StopPipelineExecution</a>, which stops the specified pipeline execution from continuing through the pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePipeline</a>, which updates a pipeline with edits or changes to the structure of the pipeline.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Pipelines include <i>stages</i>. Each stage contains one or more actions that must complete before the next stage
 * begins. A stage results in success or failure. If a stage fails, the pipeline stops at that stage and remains stopped
 * until either a new version of an artifact appears in the source location, or a user takes action to rerun the most
 * recent artifact through the pipeline. You can call <a>GetPipelineState</a>, which displays the status of a pipeline,
 * including the status of stages in the pipeline, or <a>GetPipeline</a>, which returns the entire structure of the
 * pipeline, including the stages of that pipeline. For more information about the structure of stages and actions, see
 * <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-structure.html">CodePipeline Pipeline
 * Structure Reference</a>.
 * </p>
 * <p>
 * Pipeline stages include <i>actions</i> that are categorized into categories such as source or build actions performed
 * in a stage of a pipeline. For example, you can use a source action to import artifacts into a pipeline from a source
 * such as Amazon S3. Like stages, you do not work with actions directly in most cases, but you do define and interact
 * with actions when working with pipeline operations such as <a>CreatePipeline</a> and <a>GetPipelineState</a>. Valid
 * action categories are:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Source
 * </p>
 * </li>
 * <li>
 * <p>
 * Build
 * </p>
 * </li>
 * <li>
 * <p>
 * Test
 * </p>
 * </li>
 * <li>
 * <p>
 * Deploy
 * </p>
 * </li>
 * <li>
 * <p>
 * Approval
 * </p>
 * </li>
 * <li>
 * <p>
 * Invoke
 * </p>
 * </li>
 * </ul>
 * <p>
 * Pipelines also include <i>transitions</i>, which allow the transition of artifacts from one stage to the next in a
 * pipeline after the actions in one stage complete.
 * </p>
 * <p>
 * You can work with transitions by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DisableStageTransition</a>, which prevents artifacts from transitioning to the next stage in a pipeline.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>EnableStageTransition</a>, which enables transition of artifacts between stages in a pipeline.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Using the API to integrate with CodePipeline</b>
 * </p>
 * <p>
 * For third-party integrators or developers who want to create their own integrations with CodePipeline, the expected
 * sequence varies from the standard API user. To integrate with CodePipeline, developers need to work with the
 * following items:
 * </p>
 * <p>
 * <b>Jobs</b>, which are instances of an action. For example, a job for a source action might import a revision of an
 * artifact from a source.
 * </p>
 * <p>
 * You can work with jobs by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>AcknowledgeJob</a>, which confirms whether a job worker has received the specified job.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetJobDetails</a>, which returns the details of a job.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PollForJobs</a>, which determines whether there are any jobs to act on.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutJobFailureResult</a>, which provides details of a job failure.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutJobSuccessResult</a>, which provides details of a job success.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Third party jobs</b>, which are instances of an action created by a partner action and integrated into
 * CodePipeline. Partner actions are created by members of the Amazon Web Services Partner Network.
 * </p>
 * <p>
 * You can work with third party jobs by calling:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>AcknowledgeThirdPartyJob</a>, which confirms whether a job worker has received the specified job.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetThirdPartyJobDetails</a>, which requests the details of a job for a partner action.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PollForThirdPartyJobs</a>, which determines whether there are any jobs to act on.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutThirdPartyJobFailureResult</a>, which provides details of a job failure.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutThirdPartyJobSuccessResult</a>, which provides details of a job success.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodePipelineAsyncClient extends AwsClient {
    String SERVICE_NAME = "codepipeline";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codepipeline";

    /**
     * <p>
     * Returns information about a specified job and whether that job has been received by the job worker. Used for
     * custom actions only.
     * </p>
     *
     * @param acknowledgeJobRequest
     *        Represents the input of an AcknowledgeJob action.
     * @return A Java Future containing the result of the AcknowledgeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNonceException The nonce was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.AcknowledgeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcknowledgeJobResponse> acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified job and whether that job has been received by the job worker. Used for
     * custom actions only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcknowledgeJobRequest.Builder} avoiding the need to
     * create one manually via {@link AcknowledgeJobRequest#builder()}
     * </p>
     *
     * @param acknowledgeJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest.Builder} to create a
     *        request. Represents the input of an AcknowledgeJob action.
     * @return A Java Future containing the result of the AcknowledgeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNonceException The nonce was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.AcknowledgeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AcknowledgeJobResponse> acknowledgeJob(Consumer<AcknowledgeJobRequest.Builder> acknowledgeJobRequest) {
        return acknowledgeJob(AcknowledgeJobRequest.builder().applyMutation(acknowledgeJobRequest).build());
    }

    /**
     * <p>
     * Confirms a job worker has received the specified job. Used for partner actions only.
     * </p>
     *
     * @param acknowledgeThirdPartyJobRequest
     *        Represents the input of an AcknowledgeThirdPartyJob action.
     * @return A Java Future containing the result of the AcknowledgeThirdPartyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNonceException The nonce was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.AcknowledgeThirdPartyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcknowledgeThirdPartyJobResponse> acknowledgeThirdPartyJob(
            AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms a job worker has received the specified job. Used for partner actions only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcknowledgeThirdPartyJobRequest.Builder} avoiding
     * the need to create one manually via {@link AcknowledgeThirdPartyJobRequest#builder()}
     * </p>
     *
     * @param acknowledgeThirdPartyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest.Builder} to
     *        create a request. Represents the input of an AcknowledgeThirdPartyJob action.
     * @return A Java Future containing the result of the AcknowledgeThirdPartyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNonceException The nonce was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.AcknowledgeThirdPartyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcknowledgeThirdPartyJobResponse> acknowledgeThirdPartyJob(
            Consumer<AcknowledgeThirdPartyJobRequest.Builder> acknowledgeThirdPartyJobRequest) {
        return acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest.builder().applyMutation(acknowledgeThirdPartyJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new custom action that can be used in all pipelines associated with the Amazon Web Services account.
     * Only used for custom actions.
     * </p>
     *
     * @param createCustomActionTypeRequest
     *        Represents the input of a CreateCustomActionType operation.
     * @return A Java Future containing the result of the CreateCustomActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.CreateCustomActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomActionTypeResponse> createCustomActionType(
            CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom action that can be used in all pipelines associated with the Amazon Web Services account.
     * Only used for custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomActionTypeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomActionTypeRequest#builder()}
     * </p>
     *
     * @param createCustomActionTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest.Builder} to create
     *        a request. Represents the input of a CreateCustomActionType operation.
     * @return A Java Future containing the result of the CreateCustomActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.CreateCustomActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomActionTypeResponse> createCustomActionType(
            Consumer<CreateCustomActionTypeRequest.Builder> createCustomActionTypeRequest) {
        return createCustomActionType(CreateCustomActionTypeRequest.builder().applyMutation(createCustomActionTypeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a pipeline.
     * </p>
     * <note>
     * <p>
     * In the pipeline structure, you must include either <code>artifactStore</code> or <code>artifactStores</code> in
     * your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use
     * <code>artifactStores</code>.
     * </p>
     * </note>
     *
     * @param createPipelineRequest
     *        Represents the input of a <code>CreatePipeline</code> action.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNameInUseException The specified pipeline name is already in use.</li>
     *         <li>InvalidStageDeclarationException The stage declaration was specified in an invalid format.</li>
     *         <li>InvalidActionDeclarationException The action declaration was specified in an invalid format.</li>
     *         <li>InvalidBlockerDeclarationException Reserved for future use.</li>
     *         <li>InvalidStructureException The structure was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pipeline.
     * </p>
     * <note>
     * <p>
     * In the pipeline structure, you must include either <code>artifactStore</code> or <code>artifactStores</code> in
     * your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use
     * <code>artifactStores</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest.Builder} to create a
     *        request. Represents the input of a <code>CreatePipeline</code> action.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNameInUseException The specified pipeline name is already in use.</li>
     *         <li>InvalidStageDeclarationException The stage declaration was specified in an invalid format.</li>
     *         <li>InvalidActionDeclarationException The action declaration was specified in an invalid format.</li>
     *         <li>InvalidBlockerDeclarationException Reserved for future use.</li>
     *         <li>InvalidStructureException The structure was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Marks a custom action as deleted. <code>PollForJobs</code> for the custom action fails after the action is marked
     * for deletion. Used for custom actions only.
     * </p>
     * <important>
     * <p>
     * To re-create a custom action after it has been deleted you must use a string in the version field that has never
     * been used before. This string can be an incremented version number, for example. To restore a deleted custom
     * action, use a JSON file that is identical to the deleted action, including the original string in the version
     * field.
     * </p>
     * </important>
     *
     * @param deleteCustomActionTypeRequest
     *        Represents the input of a <code>DeleteCustomActionType</code> operation. The custom action will be marked
     *        as deleted.
     * @return A Java Future containing the result of the DeleteCustomActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeleteCustomActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomActionTypeResponse> deleteCustomActionType(
            DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Marks a custom action as deleted. <code>PollForJobs</code> for the custom action fails after the action is marked
     * for deletion. Used for custom actions only.
     * </p>
     * <important>
     * <p>
     * To re-create a custom action after it has been deleted you must use a string in the version field that has never
     * been used before. This string can be an incremented version number, for example. To restore a deleted custom
     * action, use a JSON file that is identical to the deleted action, including the original string in the version
     * field.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomActionTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomActionTypeRequest#builder()}
     * </p>
     *
     * @param deleteCustomActionTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest.Builder} to create
     *        a request. Represents the input of a <code>DeleteCustomActionType</code> operation. The custom action will
     *        be marked as deleted.
     * @return A Java Future containing the result of the DeleteCustomActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeleteCustomActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomActionTypeResponse> deleteCustomActionType(
            Consumer<DeleteCustomActionTypeRequest.Builder> deleteCustomActionTypeRequest) {
        return deleteCustomActionType(DeleteCustomActionTypeRequest.builder().applyMutation(deleteCustomActionTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified pipeline.
     * </p>
     *
     * @param deletePipelineRequest
     *        Represents the input of a <code>DeletePipeline</code> action.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest.Builder} to create a
     *        request. Represents the input of a <code>DeletePipeline</code> action.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes a previously created webhook by name. Deleting the webhook stops CodePipeline from starting a pipeline
     * every time an external event occurs. The API returns successfully when trying to delete a webhook that is already
     * deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different
     * URL.
     * </p>
     *
     * @param deleteWebhookRequest
     * @return A Java Future containing the result of the DeleteWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteWebhook" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWebhookResponse> deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously created webhook by name. Deleting the webhook stops CodePipeline from starting a pipeline
     * every time an external event occurs. The API returns successfully when trying to delete a webhook that is already
     * deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different
     * URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebhookRequest#builder()}
     * </p>
     *
     * @param deleteWebhookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteWebhook" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWebhookResponse> deleteWebhook(Consumer<DeleteWebhookRequest.Builder> deleteWebhookRequest) {
        return deleteWebhook(DeleteWebhookRequest.builder().applyMutation(deleteWebhookRequest).build());
    }

    /**
     * <p>
     * Removes the connection between the webhook that was created by CodePipeline and the external tool with events to
     * be detected. Currently supported only for webhooks that target an action type of GitHub.
     * </p>
     *
     * @param deregisterWebhookWithThirdPartyRequest
     * @return A Java Future containing the result of the DeregisterWebhookWithThirdParty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>WebhookNotFoundException The specified webhook was entered in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeregisterWebhookWithThirdParty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeregisterWebhookWithThirdParty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWebhookWithThirdPartyResponse> deregisterWebhookWithThirdParty(
            DeregisterWebhookWithThirdPartyRequest deregisterWebhookWithThirdPartyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the connection between the webhook that was created by CodePipeline and the external tool with events to
     * be detected. Currently supported only for webhooks that target an action type of GitHub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterWebhookWithThirdPartyRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterWebhookWithThirdPartyRequest#builder()}
     * </p>
     *
     * @param deregisterWebhookWithThirdPartyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterWebhookWithThirdParty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>WebhookNotFoundException The specified webhook was entered in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DeregisterWebhookWithThirdParty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeregisterWebhookWithThirdParty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterWebhookWithThirdPartyResponse> deregisterWebhookWithThirdParty(
            Consumer<DeregisterWebhookWithThirdPartyRequest.Builder> deregisterWebhookWithThirdPartyRequest) {
        return deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest.builder()
                .applyMutation(deregisterWebhookWithThirdPartyRequest).build());
    }

    /**
     * <p>
     * Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.
     * </p>
     *
     * @param disableStageTransitionRequest
     *        Represents the input of a <code>DisableStageTransition</code> action.
     * @return A Java Future containing the result of the DisableStageTransition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DisableStageTransition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableStageTransitionResponse> disableStageTransition(
            DisableStageTransitionRequest disableStageTransitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableStageTransitionRequest.Builder} avoiding the
     * need to create one manually via {@link DisableStageTransitionRequest#builder()}
     * </p>
     *
     * @param disableStageTransitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest.Builder} to create
     *        a request. Represents the input of a <code>DisableStageTransition</code> action.
     * @return A Java Future containing the result of the DisableStageTransition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.DisableStageTransition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableStageTransitionResponse> disableStageTransition(
            Consumer<DisableStageTransitionRequest.Builder> disableStageTransitionRequest) {
        return disableStageTransition(DisableStageTransitionRequest.builder().applyMutation(disableStageTransitionRequest)
                .build());
    }

    /**
     * <p>
     * Enables artifacts in a pipeline to transition to a stage in a pipeline.
     * </p>
     *
     * @param enableStageTransitionRequest
     *        Represents the input of an <code>EnableStageTransition</code> action.
     * @return A Java Future containing the result of the EnableStageTransition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.EnableStageTransition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableStageTransitionResponse> enableStageTransition(
            EnableStageTransitionRequest enableStageTransitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables artifacts in a pipeline to transition to a stage in a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableStageTransitionRequest.Builder} avoiding the
     * need to create one manually via {@link EnableStageTransitionRequest#builder()}
     * </p>
     *
     * @param enableStageTransitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest.Builder} to create
     *        a request. Represents the input of an <code>EnableStageTransition</code> action.
     * @return A Java Future containing the result of the EnableStageTransition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.EnableStageTransition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableStageTransitionResponse> enableStageTransition(
            Consumer<EnableStageTransitionRequest.Builder> enableStageTransitionRequest) {
        return enableStageTransition(EnableStageTransitionRequest.builder().applyMutation(enableStageTransitionRequest).build());
    }

    /**
     * <p>
     * Returns information about an action type created for an external provider, where the action is to be used by
     * customers of the external provider. The action can be created with any supported integration model.
     * </p>
     *
     * @param getActionTypeRequest
     * @return A Java Future containing the result of the GetActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetActionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetActionTypeResponse> getActionType(GetActionTypeRequest getActionTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an action type created for an external provider, where the action is to be used by
     * customers of the external provider. The action can be created with any supported integration model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActionTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetActionTypeRequest#builder()}
     * </p>
     *
     * @param getActionTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetActionTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetActionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetActionTypeResponse> getActionType(Consumer<GetActionTypeRequest.Builder> getActionTypeRequest) {
        return getActionType(GetActionTypeRequest.builder().applyMutation(getActionTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about a job. Used for custom actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important>
     *
     * @param getJobDetailsRequest
     *        Represents the input of a <code>GetJobDetails</code> action.
     * @return A Java Future containing the result of the GetJobDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetJobDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetJobDetailsResponse> getJobDetails(GetJobDetailsRequest getJobDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a job. Used for custom actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobDetailsRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobDetailsRequest#builder()}
     * </p>
     *
     * @param getJobDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest.Builder} to create a
     *        request. Represents the input of a <code>GetJobDetails</code> action.
     * @return A Java Future containing the result of the GetJobDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetJobDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetJobDetailsResponse> getJobDetails(Consumer<GetJobDetailsRequest.Builder> getJobDetailsRequest) {
        return getJobDetails(GetJobDetailsRequest.builder().applyMutation(getJobDetailsRequest).build());
    }

    /**
     * <p>
     * Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of
     * a pipeline in JSON format, which can then be modified and used to update the pipeline structure with
     * <a>UpdatePipeline</a>.
     * </p>
     *
     * @param getPipelineRequest
     *        Represents the input of a <code>GetPipeline</code> action.
     * @return A Java Future containing the result of the GetPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineVersionNotFoundException The pipeline version was specified in an invalid format or cannot be
     *         found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPipelineResponse> getPipeline(GetPipelineRequest getPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of
     * a pipeline in JSON format, which can then be modified and used to update the pipeline structure with
     * <a>UpdatePipeline</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineRequest.Builder} avoiding the need to
     * create one manually via {@link GetPipelineRequest#builder()}
     * </p>
     *
     * @param getPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest.Builder} to create a request.
     *        Represents the input of a <code>GetPipeline</code> action.
     * @return A Java Future containing the result of the GetPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineVersionNotFoundException The pipeline version was specified in an invalid format or cannot be
     *         found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPipelineResponse> getPipeline(Consumer<GetPipelineRequest.Builder> getPipelineRequest) {
        return getPipeline(GetPipelineRequest.builder().applyMutation(getPipelineRequest).build());
    }

    /**
     * <p>
     * Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution
     * ID, and the name, version, and status of the pipeline.
     * </p>
     *
     * @param getPipelineExecutionRequest
     *        Represents the input of a <code>GetPipelineExecution</code> action.
     * @return A Java Future containing the result of the GetPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPipelineExecutionResponse> getPipelineExecution(
            GetPipelineExecutionRequest getPipelineExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution
     * ID, and the name, version, and status of the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetPipelineExecutionRequest#builder()}
     * </p>
     *
     * @param getPipelineExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest.Builder} to create a
     *        request. Represents the input of a <code>GetPipelineExecution</code> action.
     * @return A Java Future containing the result of the GetPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPipelineExecutionResponse> getPipelineExecution(
            Consumer<GetPipelineExecutionRequest.Builder> getPipelineExecutionRequest) {
        return getPipelineExecution(GetPipelineExecutionRequest.builder().applyMutation(getPipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Returns information about the state of a pipeline, including the stages and actions.
     * </p>
     * <note>
     * <p>
     * Values returned in the <code>revisionId</code> and <code>revisionUrl</code> fields indicate the source revision
     * information, such as the commit ID, for the current state.
     * </p>
     * </note>
     *
     * @param getPipelineStateRequest
     *        Represents the input of a <code>GetPipelineState</code> action.
     * @return A Java Future containing the result of the GetPipelineState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipelineState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPipelineStateResponse> getPipelineState(GetPipelineStateRequest getPipelineStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the state of a pipeline, including the stages and actions.
     * </p>
     * <note>
     * <p>
     * Values returned in the <code>revisionId</code> and <code>revisionUrl</code> fields indicate the source revision
     * information, such as the commit ID, for the current state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPipelineStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetPipelineStateRequest#builder()}
     * </p>
     *
     * @param getPipelineStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest.Builder} to create a
     *        request. Represents the input of a <code>GetPipelineState</code> action.
     * @return A Java Future containing the result of the GetPipelineState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetPipelineState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPipelineStateResponse> getPipelineState(
            Consumer<GetPipelineStateRequest.Builder> getPipelineStateRequest) {
        return getPipelineState(GetPipelineStateRequest.builder().applyMutation(getPipelineStateRequest).build());
    }

    /**
     * <p>
     * Requests the details of a job for a third party action. Used for partner actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important>
     *
     * @param getThirdPartyJobDetailsRequest
     *        Represents the input of a <code>GetThirdPartyJobDetails</code> action.
     * @return A Java Future containing the result of the GetThirdPartyJobDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>InvalidJobException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetThirdPartyJobDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetThirdPartyJobDetailsResponse> getThirdPartyJobDetails(
            GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests the details of a job for a third party action. Used for partner actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThirdPartyJobDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link GetThirdPartyJobDetailsRequest#builder()}
     * </p>
     *
     * @param getThirdPartyJobDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest.Builder} to
     *        create a request. Represents the input of a <code>GetThirdPartyJobDetails</code> action.
     * @return A Java Future containing the result of the GetThirdPartyJobDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>InvalidJobException The job was specified in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.GetThirdPartyJobDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetThirdPartyJobDetailsResponse> getThirdPartyJobDetails(
            Consumer<GetThirdPartyJobDetailsRequest.Builder> getThirdPartyJobDetailsRequest) {
        return getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest.builder().applyMutation(getThirdPartyJobDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the action executions that have occurred in a pipeline.
     * </p>
     *
     * @param listActionExecutionsRequest
     * @return A Java Future containing the result of the ListActionExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListActionExecutionsResponse> listActionExecutions(
            ListActionExecutionsRequest listActionExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the action executions that have occurred in a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListActionExecutionsRequest#builder()}
     * </p>
     *
     * @param listActionExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListActionExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListActionExecutionsResponse> listActionExecutions(
            Consumer<ListActionExecutionsRequest.Builder> listActionExecutionsRequest) {
        return listActionExecutions(ListActionExecutionsRequest.builder().applyMutation(listActionExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActionExecutions(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsPublisher publisher = client.listActionExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsPublisher publisher = client.listActionExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActionExecutions(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listActionExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListActionExecutionsPublisher listActionExecutionsPaginator(ListActionExecutionsRequest listActionExecutionsRequest) {
        return new ListActionExecutionsPublisher(this, listActionExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActionExecutions(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsPublisher publisher = client.listActionExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionExecutionsPublisher publisher = client.listActionExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActionExecutions(software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListActionExecutionsRequest#builder()}
     * </p>
     *
     * @param listActionExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListActionExecutionsPublisher listActionExecutionsPaginator(
            Consumer<ListActionExecutionsRequest.Builder> listActionExecutionsRequest) {
        return listActionExecutionsPaginator(ListActionExecutionsRequest.builder().applyMutation(listActionExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a summary of all CodePipeline action types associated with your account.
     * </p>
     *
     * @param listActionTypesRequest
     *        Represents the input of a <code>ListActionTypes</code> action.
     * @return A Java Future containing the result of the ListActionTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListActionTypesResponse> listActionTypes(ListActionTypesRequest listActionTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a summary of all CodePipeline action types associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListActionTypesRequest#builder()}
     * </p>
     *
     * @param listActionTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest.Builder} to create a
     *        request. Represents the input of a <code>ListActionTypes</code> action.
     * @return A Java Future containing the result of the ListActionTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListActionTypesResponse> listActionTypes(
            Consumer<ListActionTypesRequest.Builder> listActionTypesRequest) {
        return listActionTypes(ListActionTypesRequest.builder().applyMutation(listActionTypesRequest).build());
    }

    /**
     * <p>
     * Gets a summary of all CodePipeline action types associated with your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListActionTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListActionTypesResponse> listActionTypes() {
        return listActionTypes(ListActionTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActionTypesPublisher listActionTypesPaginator() {
        return listActionTypesPaginator(ListActionTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listActionTypesRequest
     *        Represents the input of a <code>ListActionTypes</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActionTypesPublisher listActionTypesPaginator(ListActionTypesRequest listActionTypesRequest) {
        return new ListActionTypesPublisher(this, listActionTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListActionTypesPublisher publisher = client.listActionTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActionTypes(software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActionTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListActionTypesRequest#builder()}
     * </p>
     *
     * @param listActionTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest.Builder} to create a
     *        request. Represents the input of a <code>ListActionTypes</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListActionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListActionTypesPublisher listActionTypesPaginator(Consumer<ListActionTypesRequest.Builder> listActionTypesRequest) {
        return listActionTypesPaginator(ListActionTypesRequest.builder().applyMutation(listActionTypesRequest).build());
    }

    /**
     * <p>
     * Gets a summary of the most recent executions for a pipeline.
     * </p>
     * <note>
     * <p>
     * When applying the filter for pipeline executions that have succeeded in the stage, the operation returns all
     * executions in the current pipeline version beginning on February 1, 2024.
     * </p>
     * </note>
     *
     * @param listPipelineExecutionsRequest
     *        Represents the input of a <code>ListPipelineExecutions</code> action.
     * @return A Java Future containing the result of the ListPipelineExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPipelineExecutionsResponse> listPipelineExecutions(
            ListPipelineExecutionsRequest listPipelineExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a summary of the most recent executions for a pipeline.
     * </p>
     * <note>
     * <p>
     * When applying the filter for pipeline executions that have succeeded in the stage, the operation returns all
     * executions in the current pipeline version beginning on February 1, 2024.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPipelineExecutionsRequest#builder()}
     * </p>
     *
     * @param listPipelineExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest.Builder} to create
     *        a request. Represents the input of a <code>ListPipelineExecutions</code> action.
     * @return A Java Future containing the result of the ListPipelineExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPipelineExecutionsResponse> listPipelineExecutions(
            Consumer<ListPipelineExecutionsRequest.Builder> listPipelineExecutionsRequest) {
        return listPipelineExecutions(ListPipelineExecutionsRequest.builder().applyMutation(listPipelineExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsPublisher publisher = client.listPipelineExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsPublisher publisher = client.listPipelineExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelineExecutionsRequest
     *        Represents the input of a <code>ListPipelineExecutions</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineExecutionsPublisher listPipelineExecutionsPaginator(
            ListPipelineExecutionsRequest listPipelineExecutionsRequest) {
        return new ListPipelineExecutionsPublisher(this, listPipelineExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsPublisher publisher = client.listPipelineExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelineExecutionsPublisher publisher = client.listPipelineExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelineExecutions(software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelineExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPipelineExecutionsRequest#builder()}
     * </p>
     *
     * @param listPipelineExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest.Builder} to create
     *        a request. Represents the input of a <code>ListPipelineExecutions</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelineExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPipelineExecutionsPublisher listPipelineExecutionsPaginator(
            Consumer<ListPipelineExecutionsRequest.Builder> listPipelineExecutionsRequest) {
        return listPipelineExecutionsPaginator(ListPipelineExecutionsRequest.builder()
                .applyMutation(listPipelineExecutionsRequest).build());
    }

    /**
     * <p>
     * Gets a summary of all of the pipelines associated with your account.
     * </p>
     *
     * @param listPipelinesRequest
     *        Represents the input of a <code>ListPipelines</code> action.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a summary of all of the pipelines associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest.Builder} to create a
     *        request. Represents the input of a <code>ListPipelines</code> action.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelines(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Gets a summary of all of the pipelines associated with your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines() {
        return listPipelines(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator() {
        return listPipelinesPaginator(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     *        Represents the input of a <code>ListPipelines</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) {
        return new ListPipelinesPublisher(this, listPipelinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest.Builder} to create a
     *        request. Represents the input of a <code>ListPipelines</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPipelinesPublisher listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelinesPaginator(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Gets a listing of all the webhooks in this Amazon Web Services Region for this account. The output lists all
     * webhooks and includes the webhook URL and ARN and the configuration for each webhook.
     * </p>
     *
     * @param listWebhooksRequest
     * @return A Java Future containing the result of the ListWebhooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebhooksResponse> listWebhooks(ListWebhooksRequest listWebhooksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a listing of all the webhooks in this Amazon Web Services Region for this account. The output lists all
     * webhooks and includes the webhook URL and ARN and the configuration for each webhook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebhooksRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebhooksRequest#builder()}
     * </p>
     *
     * @param listWebhooksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWebhooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebhooksResponse> listWebhooks(Consumer<ListWebhooksRequest.Builder> listWebhooksRequest) {
        return listWebhooks(ListWebhooksRequest.builder().applyMutation(listWebhooksRequest).build());
    }

    /**
     * <p>
     * Gets a listing of all the webhooks in this Amazon Web Services Region for this account. The output lists all
     * webhooks and includes the webhook URL and ARN and the configuration for each webhook.
     * </p>
     *
     * @return A Java Future containing the result of the ListWebhooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWebhooksResponse> listWebhooks() {
        return listWebhooks(ListWebhooksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebhooksPublisher listWebhooksPaginator() {
        return listWebhooksPaginator(ListWebhooksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation.</b>
     * </p>
     *
     * @param listWebhooksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebhooksPublisher listWebhooksPaginator(ListWebhooksRequest listWebhooksRequest) {
        return new ListWebhooksPublisher(this, listWebhooksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codepipeline.paginators.ListWebhooksPublisher publisher = client.listWebhooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebhooks(software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebhooksRequest.Builder} avoiding the need to
     * create one manually via {@link ListWebhooksRequest#builder()}
     * </p>
     *
     * @param listWebhooksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidNextTokenException The next token was specified in an invalid format. Make sure that the next
     *         token you provide is the token returned by a previous call.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.ListWebhooks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhooks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWebhooksPublisher listWebhooksPaginator(Consumer<ListWebhooksRequest.Builder> listWebhooksRequest) {
        return listWebhooksPaginator(ListWebhooksRequest.builder().applyMutation(listWebhooksRequest).build());
    }

    /**
     * <p>
     * Returns information about any jobs for CodePipeline to act on. <code>PollForJobs</code> is valid only for action
     * types with "Custom" in the owner field. If the action type contains <code>AWS</code> or <code>ThirdParty</code>
     * in the owner field, the <code>PollForJobs</code> action returns an error.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important>
     *
     * @param pollForJobsRequest
     *        Represents the input of a <code>PollForJobs</code> action.
     * @return A Java Future containing the result of the PollForJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PollForJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PollForJobsResponse> pollForJobs(PollForJobsRequest pollForJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about any jobs for CodePipeline to act on. <code>PollForJobs</code> is valid only for action
     * types with "Custom" in the owner field. If the action type contains <code>AWS</code> or <code>ThirdParty</code>
     * in the owner field, the <code>PollForJobs</code> action returns an error.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also
     * returns any secret values defined for the action.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForJobsRequest.Builder} avoiding the need to
     * create one manually via {@link PollForJobsRequest#builder()}
     * </p>
     *
     * @param pollForJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest.Builder} to create a request.
     *        Represents the input of a <code>PollForJobs</code> action.
     * @return A Java Future containing the result of the PollForJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PollForJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PollForJobsResponse> pollForJobs(Consumer<PollForJobsRequest.Builder> pollForJobsRequest) {
        return pollForJobs(PollForJobsRequest.builder().applyMutation(pollForJobsRequest).build());
    }

    /**
     * <p>
     * Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts.
     * </p>
     * </important>
     *
     * @param pollForThirdPartyJobsRequest
     *        Represents the input of a <code>PollForThirdPartyJobs</code> action.
     * @return A Java Future containing the result of the PollForThirdPartyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PollForThirdPartyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PollForThirdPartyJobsResponse> pollForThirdPartyJobs(
            PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.
     * </p>
     * <important>
     * <p>
     * When this API is called, CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for
     * the pipeline, if the action requires access to that S3 bucket for input or output artifacts.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PollForThirdPartyJobsRequest.Builder} avoiding the
     * need to create one manually via {@link PollForThirdPartyJobsRequest#builder()}
     * </p>
     *
     * @param pollForThirdPartyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest.Builder} to create
     *        a request. Represents the input of a <code>PollForThirdPartyJobs</code> action.
     * @return A Java Future containing the result of the PollForThirdPartyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PollForThirdPartyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PollForThirdPartyJobsResponse> pollForThirdPartyJobs(
            Consumer<PollForThirdPartyJobsRequest.Builder> pollForThirdPartyJobsRequest) {
        return pollForThirdPartyJobs(PollForThirdPartyJobsRequest.builder().applyMutation(pollForThirdPartyJobsRequest).build());
    }

    /**
     * <p>
     * Provides information to CodePipeline about new revisions to a source.
     * </p>
     *
     * @param putActionRevisionRequest
     *        Represents the input of a <code>PutActionRevision</code> action.
     * @return A Java Future containing the result of the PutActionRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>ActionNotFoundException The specified action cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutActionRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutActionRevisionResponse> putActionRevision(PutActionRevisionRequest putActionRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information to CodePipeline about new revisions to a source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutActionRevisionRequest.Builder} avoiding the need
     * to create one manually via {@link PutActionRevisionRequest#builder()}
     * </p>
     *
     * @param putActionRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest.Builder} to create a
     *        request. Represents the input of a <code>PutActionRevision</code> action.
     * @return A Java Future containing the result of the PutActionRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>ActionNotFoundException The specified action cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutActionRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutActionRevisionResponse> putActionRevision(
            Consumer<PutActionRevisionRequest.Builder> putActionRevisionRequest) {
        return putActionRevision(PutActionRevisionRequest.builder().applyMutation(putActionRevisionRequest).build());
    }

    /**
     * <p>
     * Provides the response to a manual approval request to CodePipeline. Valid responses include Approved and
     * Rejected.
     * </p>
     *
     * @param putApprovalResultRequest
     *        Represents the input of a <code>PutApprovalResult</code> action.
     * @return A Java Future containing the result of the PutApprovalResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidApprovalTokenException The approval request already received a response or has expired.</li>
     *         <li>ApprovalAlreadyCompletedException The approval action has already been approved or rejected.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>ActionNotFoundException The specified action cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutApprovalResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApprovalResultResponse> putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the response to a manual approval request to CodePipeline. Valid responses include Approved and
     * Rejected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutApprovalResultRequest.Builder} avoiding the need
     * to create one manually via {@link PutApprovalResultRequest#builder()}
     * </p>
     *
     * @param putApprovalResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest.Builder} to create a
     *        request. Represents the input of a <code>PutApprovalResult</code> action.
     * @return A Java Future containing the result of the PutApprovalResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidApprovalTokenException The approval request already received a response or has expired.</li>
     *         <li>ApprovalAlreadyCompletedException The approval action has already been approved or rejected.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>ActionNotFoundException The specified action cannot be found.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutApprovalResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApprovalResultResponse> putApprovalResult(
            Consumer<PutApprovalResultRequest.Builder> putApprovalResultRequest) {
        return putApprovalResult(PutApprovalResultRequest.builder().applyMutation(putApprovalResultRequest).build());
    }

    /**
     * <p>
     * Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.
     * </p>
     *
     * @param putJobFailureResultRequest
     *        Represents the input of a <code>PutJobFailureResult</code> action.
     * @return A Java Future containing the result of the PutJobFailureResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutJobFailureResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutJobFailureResultResponse> putJobFailureResult(
            PutJobFailureResultRequest putJobFailureResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutJobFailureResultRequest.Builder} avoiding the
     * need to create one manually via {@link PutJobFailureResultRequest#builder()}
     * </p>
     *
     * @param putJobFailureResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest.Builder} to create a
     *        request. Represents the input of a <code>PutJobFailureResult</code> action.
     * @return A Java Future containing the result of the PutJobFailureResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutJobFailureResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutJobFailureResultResponse> putJobFailureResult(
            Consumer<PutJobFailureResultRequest.Builder> putJobFailureResultRequest) {
        return putJobFailureResult(PutJobFailureResultRequest.builder().applyMutation(putJobFailureResultRequest).build());
    }

    /**
     * <p>
     * Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.
     * </p>
     *
     * @param putJobSuccessResultRequest
     *        Represents the input of a <code>PutJobSuccessResult</code> action.
     * @return A Java Future containing the result of the PutJobSuccessResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>OutputVariablesSizeExceededException Exceeded the total size limit for all variables in the pipeline.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutJobSuccessResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutJobSuccessResultResponse> putJobSuccessResult(
            PutJobSuccessResultRequest putJobSuccessResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutJobSuccessResultRequest.Builder} avoiding the
     * need to create one manually via {@link PutJobSuccessResultRequest#builder()}
     * </p>
     *
     * @param putJobSuccessResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest.Builder} to create a
     *        request. Represents the input of a <code>PutJobSuccessResult</code> action.
     * @return A Java Future containing the result of the PutJobSuccessResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>OutputVariablesSizeExceededException Exceeded the total size limit for all variables in the pipeline.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutJobSuccessResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutJobSuccessResultResponse> putJobSuccessResult(
            Consumer<PutJobSuccessResultRequest.Builder> putJobSuccessResultRequest) {
        return putJobSuccessResult(PutJobSuccessResultRequest.builder().applyMutation(putJobSuccessResultRequest).build());
    }

    /**
     * <p>
     * Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions
     * only.
     * </p>
     *
     * @param putThirdPartyJobFailureResultRequest
     *        Represents the input of a <code>PutThirdPartyJobFailureResult</code> action.
     * @return A Java Future containing the result of the PutThirdPartyJobFailureResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutThirdPartyJobFailureResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutThirdPartyJobFailureResultResponse> putThirdPartyJobFailureResult(
            PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions
     * only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutThirdPartyJobFailureResultRequest.Builder}
     * avoiding the need to create one manually via {@link PutThirdPartyJobFailureResultRequest#builder()}
     * </p>
     *
     * @param putThirdPartyJobFailureResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest.Builder} to
     *        create a request. Represents the input of a <code>PutThirdPartyJobFailureResult</code> action.
     * @return A Java Future containing the result of the PutThirdPartyJobFailureResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutThirdPartyJobFailureResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutThirdPartyJobFailureResultResponse> putThirdPartyJobFailureResult(
            Consumer<PutThirdPartyJobFailureResultRequest.Builder> putThirdPartyJobFailureResultRequest) {
        return putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest.builder()
                .applyMutation(putThirdPartyJobFailureResultRequest).build());
    }

    /**
     * <p>
     * Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions
     * only.
     * </p>
     *
     * @param putThirdPartyJobSuccessResultRequest
     *        Represents the input of a <code>PutThirdPartyJobSuccessResult</code> action.
     * @return A Java Future containing the result of the PutThirdPartyJobSuccessResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutThirdPartyJobSuccessResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutThirdPartyJobSuccessResultResponse> putThirdPartyJobSuccessResult(
            PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions
     * only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutThirdPartyJobSuccessResultRequest.Builder}
     * avoiding the need to create one manually via {@link PutThirdPartyJobSuccessResultRequest#builder()}
     * </p>
     *
     * @param putThirdPartyJobSuccessResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest.Builder} to
     *        create a request. Represents the input of a <code>PutThirdPartyJobSuccessResult</code> action.
     * @return A Java Future containing the result of the PutThirdPartyJobSuccessResult operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>JobNotFoundException The job was specified in an invalid format or cannot be found.</li>
     *         <li>InvalidJobStateException The job state was specified in an invalid format.</li>
     *         <li>InvalidClientTokenException The client token was specified in an invalid format</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutThirdPartyJobSuccessResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutThirdPartyJobSuccessResultResponse> putThirdPartyJobSuccessResult(
            Consumer<PutThirdPartyJobSuccessResultRequest.Builder> putThirdPartyJobSuccessResultRequest) {
        return putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest.builder()
                .applyMutation(putThirdPartyJobSuccessResultRequest).build());
    }

    /**
     * <p>
     * Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third
     * party source hosting providers to call every time there's a code change. When CodePipeline receives a POST
     * request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the
     * authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and
     * DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the
     * generated webhook URL.
     * </p>
     *
     * @param putWebhookRequest
     * @return A Java Future containing the result of the PutWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>InvalidWebhookFilterPatternException The specified event filter rule is in an invalid format.</li>
     *         <li>InvalidWebhookAuthenticationParametersException The specified authentication type is in an invalid
     *         format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutWebhookResponse> putWebhook(PutWebhookRequest putWebhookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third
     * party source hosting providers to call every time there's a code change. When CodePipeline receives a POST
     * request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the
     * authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and
     * DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the
     * generated webhook URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link PutWebhookRequest#builder()}
     * </p>
     *
     * @param putWebhookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>InvalidWebhookFilterPatternException The specified event filter rule is in an invalid format.</li>
     *         <li>InvalidWebhookAuthenticationParametersException The specified authentication type is in an invalid
     *         format.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.PutWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutWebhookResponse> putWebhook(Consumer<PutWebhookRequest.Builder> putWebhookRequest) {
        return putWebhook(PutWebhookRequest.builder().applyMutation(putWebhookRequest).build());
    }

    /**
     * <p>
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     * </p>
     *
     * @param registerWebhookWithThirdPartyRequest
     * @return A Java Future containing the result of the RegisterWebhookWithThirdParty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>WebhookNotFoundException The specified webhook was entered in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RegisterWebhookWithThirdParty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RegisterWebhookWithThirdParty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterWebhookWithThirdPartyResponse> registerWebhookWithThirdParty(
            RegisterWebhookWithThirdPartyRequest registerWebhookWithThirdPartyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterWebhookWithThirdPartyRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterWebhookWithThirdPartyRequest#builder()}
     * </p>
     *
     * @param registerWebhookWithThirdPartyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterWebhookWithThirdParty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>WebhookNotFoundException The specified webhook was entered in an invalid format or cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RegisterWebhookWithThirdParty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RegisterWebhookWithThirdParty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterWebhookWithThirdPartyResponse> registerWebhookWithThirdParty(
            Consumer<RegisterWebhookWithThirdPartyRequest.Builder> registerWebhookWithThirdPartyRequest) {
        return registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest.builder()
                .applyMutation(registerWebhookWithThirdPartyRequest).build());
    }

    /**
     * <p>
     * You can retry a stage that has failed without having to run a pipeline again from the beginning. You do this by
     * either retrying the failed actions in a stage or by retrying all actions in the stage starting from the first
     * action in the stage. When you retry the failed actions in a stage, all actions that are still in progress
     * continue working, and failed actions are triggered again. When you retry a failed stage from the first action in
     * the stage, the stage cannot have any actions in progress. Before a stage can be retried, it must either have all
     * actions failed or some actions failed and some succeeded.
     * </p>
     *
     * @param retryStageExecutionRequest
     *        Represents the input of a <code>RetryStageExecution</code> action.
     * @return A Java Future containing the result of the RetryStageExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotRetryableException Unable to retry. The pipeline structure or stage state might have changed
     *         while actions awaited retry, or the stage contains no failed actions.</li>
     *         <li>NotLatestPipelineExecutionException The stage has failed in a later run of the pipeline and the
     *         <code>pipelineExecutionId</code> associated with the request is out of date.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RetryStageExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetryStageExecutionResponse> retryStageExecution(
            RetryStageExecutionRequest retryStageExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can retry a stage that has failed without having to run a pipeline again from the beginning. You do this by
     * either retrying the failed actions in a stage or by retrying all actions in the stage starting from the first
     * action in the stage. When you retry the failed actions in a stage, all actions that are still in progress
     * continue working, and failed actions are triggered again. When you retry a failed stage from the first action in
     * the stage, the stage cannot have any actions in progress. Before a stage can be retried, it must either have all
     * actions failed or some actions failed and some succeeded.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryStageExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link RetryStageExecutionRequest#builder()}
     * </p>
     *
     * @param retryStageExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest.Builder} to create a
     *        request. Represents the input of a <code>RetryStageExecution</code> action.
     * @return A Java Future containing the result of the RetryStageExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>StageNotRetryableException Unable to retry. The pipeline structure or stage state might have changed
     *         while actions awaited retry, or the stage contains no failed actions.</li>
     *         <li>NotLatestPipelineExecutionException The stage has failed in a later run of the pipeline and the
     *         <code>pipelineExecutionId</code> associated with the request is out of date.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RetryStageExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetryStageExecutionResponse> retryStageExecution(
            Consumer<RetryStageExecutionRequest.Builder> retryStageExecutionRequest) {
        return retryStageExecution(RetryStageExecutionRequest.builder().applyMutation(retryStageExecutionRequest).build());
    }

    /**
     * <p>
     * Rolls back a stage execution.
     * </p>
     *
     * @param rollbackStageRequest
     * @return A Java Future containing the result of the RollbackStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>PipelineExecutionOutdatedException The specified pipeline execution is outdated and cannot be used as
     *         a target pipeline execution for rollback.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>UnableToRollbackStageException Unable to roll back the stage. The cause might be if the pipeline
     *         version has changed since the target pipeline execution was deployed, the stage is currently running, or
     *         an incorrect target pipeline execution ID was provided.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RollbackStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RollbackStage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RollbackStageResponse> rollbackStage(RollbackStageRequest rollbackStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rolls back a stage execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackStageRequest.Builder} avoiding the need to
     * create one manually via {@link RollbackStageRequest#builder()}
     * </p>
     *
     * @param rollbackStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RollbackStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotFoundException The pipeline execution was specified in an invalid format or
     *         cannot be found, or an execution ID does not belong to the specified pipeline.</li>
     *         <li>PipelineExecutionOutdatedException The specified pipeline execution is outdated and cannot be used as
     *         a target pipeline execution for rollback.</li>
     *         <li>StageNotFoundException The stage was specified in an invalid format or cannot be found.</li>
     *         <li>UnableToRollbackStageException Unable to roll back the stage. The cause might be if the pipeline
     *         version has changed since the target pipeline execution was deployed, the stage is currently running, or
     *         an incorrect target pipeline execution ID was provided.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.RollbackStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RollbackStage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RollbackStageResponse> rollbackStage(Consumer<RollbackStageRequest.Builder> rollbackStageRequest) {
        return rollbackStage(RollbackStageRequest.builder().applyMutation(rollbackStageRequest).build());
    }

    /**
     * <p>
     * Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location
     * specified as part of the pipeline.
     * </p>
     *
     * @param startPipelineExecutionRequest
     *        Represents the input of a <code>StartPipelineExecution</code> action.
     * @return A Java Future containing the result of the StartPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>ConcurrentPipelineExecutionsLimitExceededException The pipeline has reached the limit for concurrent
     *         pipeline executions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.StartPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPipelineExecutionResponse> startPipelineExecution(
            StartPipelineExecutionRequest startPipelineExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location
     * specified as part of the pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPipelineExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartPipelineExecutionRequest#builder()}
     * </p>
     *
     * @param startPipelineExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest.Builder} to create
     *        a request. Represents the input of a <code>StartPipelineExecution</code> action.
     * @return A Java Future containing the result of the StartPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>ConcurrentPipelineExecutionsLimitExceededException The pipeline has reached the limit for concurrent
     *         pipeline executions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.StartPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartPipelineExecutionResponse> startPipelineExecution(
            Consumer<StartPipelineExecutionRequest.Builder> startPipelineExecutionRequest) {
        return startPipelineExecution(StartPipelineExecutionRequest.builder().applyMutation(startPipelineExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing
     * in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing
     * or abandoning in-progress actions, the pipeline execution is in a <code>Stopping</code> state. After all
     * in-progress actions are completed or abandoned, the pipeline execution is in a <code>Stopped</code> state.
     * </p>
     *
     * @param stopPipelineExecutionRequest
     * @return A Java Future containing the result of the StopPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotStoppableException Unable to stop the pipeline execution. The execution might
     *         already be in a <code>Stopped</code> state, or it might no longer be in progress.</li>
     *         <li>DuplicatedStopRequestException The pipeline execution is already in a <code>Stopping</code> state. If
     *         you already chose to stop and wait, you cannot make that request again. You can choose to stop and
     *         abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you
     *         already chose to stop and abandon, you cannot make that request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.StopPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StopPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPipelineExecutionResponse> stopPipelineExecution(
            StopPipelineExecutionRequest stopPipelineExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing
     * in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing
     * or abandoning in-progress actions, the pipeline execution is in a <code>Stopping</code> state. After all
     * in-progress actions are completed or abandoned, the pipeline execution is in a <code>Stopped</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPipelineExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StopPipelineExecutionRequest#builder()}
     * </p>
     *
     * @param stopPipelineExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopPipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ConflictException Your request cannot be handled because the pipeline is busy handling ongoing
     *         activities. Try again later.</li>
     *         <li>PipelineNotFoundException The pipeline was specified in an invalid format or cannot be found.</li>
     *         <li>PipelineExecutionNotStoppableException Unable to stop the pipeline execution. The execution might
     *         already be in a <code>Stopped</code> state, or it might no longer be in progress.</li>
     *         <li>DuplicatedStopRequestException The pipeline execution is already in a <code>Stopping</code> state. If
     *         you already chose to stop and wait, you cannot make that request again. You can choose to stop and
     *         abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you
     *         already chose to stop and abandon, you cannot make that request again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.StopPipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StopPipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopPipelineExecutionResponse> stopPipelineExecution(
            Consumer<StopPipelineExecutionRequest.Builder> stopPipelineExecutionRequest) {
        return stopPipelineExecution(StopPipelineExecutionRequest.builder().applyMutation(stopPipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>TooManyTagsException The tags limit for a resource has been exceeded.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ResourceNotFoundException The resource was specified in an invalid format.</li>
     *         <li>InvalidArnException The specified resource ARN is invalid.</li>
     *         <li>InvalidTagsException The specified resource tags are invalid.</li>
     *         <li>ConcurrentModificationException Unable to modify the tag due to a simultaneous update request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an action type that was created with any supported integration model, where the action type is to be used
     * by customers of the action type provider. Use a JSON file with the action definition and
     * <code>UpdateActionType</code> to provide the full structure.
     * </p>
     *
     * @param updateActionTypeRequest
     * @return A Java Future containing the result of the UpdateActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestFailedException The request failed because of an unknown error, exception, or failure.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UpdateActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdateActionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateActionTypeResponse> updateActionType(UpdateActionTypeRequest updateActionTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an action type that was created with any supported integration model, where the action type is to be used
     * by customers of the action type provider. Use a JSON file with the action definition and
     * <code>UpdateActionType</code> to provide the full structure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActionTypeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateActionTypeRequest#builder()}
     * </p>
     *
     * @param updateActionTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateActionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RequestFailedException The request failed because of an unknown error, exception, or failure.</li>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>ActionTypeNotFoundException The specified action type cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UpdateActionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdateActionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateActionTypeResponse> updateActionType(
            Consumer<UpdateActionTypeRequest.Builder> updateActionTypeRequest) {
        return updateActionType(UpdateActionTypeRequest.builder().applyMutation(updateActionTypeRequest).build());
    }

    /**
     * <p>
     * Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure
     * and <code>UpdatePipeline</code> to provide the full structure of the pipeline. Updating the pipeline increases
     * the version number of the pipeline by 1.
     * </p>
     *
     * @param updatePipelineRequest
     *        Represents the input of an <code>UpdatePipeline</code> action.
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidStageDeclarationException The stage declaration was specified in an invalid format.</li>
     *         <li>InvalidActionDeclarationException The action declaration was specified in an invalid format.</li>
     *         <li>InvalidBlockerDeclarationException Reserved for future use.</li>
     *         <li>InvalidStructureException The structure was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure
     * and <code>UpdatePipeline</code> to provide the full structure of the pipeline. Updating the pipeline increases
     * the version number of the pipeline by 1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePipelineRequest#builder()}
     * </p>
     *
     * @param updatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest.Builder} to create a
     *        request. Represents the input of an <code>UpdatePipeline</code> action.
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The validation was specified in an invalid format.</li>
     *         <li>InvalidStageDeclarationException The stage declaration was specified in an invalid format.</li>
     *         <li>InvalidActionDeclarationException The action declaration was specified in an invalid format.</li>
     *         <li>InvalidBlockerDeclarationException Reserved for future use.</li>
     *         <li>InvalidStructureException The structure was specified in an invalid format.</li>
     *         <li>LimitExceededException The number of pipelines associated with the Amazon Web Services account has
     *         exceeded the limit allowed for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodePipelineException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodePipelineAsyncClient.UpdatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest) {
        return updatePipeline(UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest).build());
    }

    @Override
    default CodePipelineServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CodePipelineAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodePipelineAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodePipelineAsyncClient}.
     */
    static CodePipelineAsyncClientBuilder builder() {
        return new DefaultCodePipelineAsyncClientBuilder();
    }
}
