/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentWaitType {
    READY_WAIT("READY_WAIT"),
    TERMINATION_WAIT("TERMINATION_WAIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentWaitType> VALUE_MAP;
    private final String value;

    private DeploymentWaitType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentWaitType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentWaitType> knownValues() {
        EnumSet<DeploymentWaitType> knownValues = EnumSet.allOf(DeploymentWaitType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentWaitType.class, DeploymentWaitType::toString);
    }
}

