/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object includes parameters that you can use to provide information to CloudWatch to help it build more accurate
 * anomaly detection models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricCharacteristics implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricCharacteristics.Builder, MetricCharacteristics> {
    private static final SdkField<Boolean> PERIODIC_SPIKES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PeriodicSpikes").getter(getter(MetricCharacteristics::periodicSpikes))
            .setter(setter(Builder::periodicSpikes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodicSpikes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIODIC_SPIKES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean periodicSpikes;

    private MetricCharacteristics(BuilderImpl builder) {
        this.periodicSpikes = builder.periodicSpikes;
    }

    /**
     * <p>
     * Set this parameter to <code>true</code> if values for this metric consistently include spikes that should not be
     * considered to be anomalies. With this set to <code>true</code>, CloudWatch will expect to see spikes that
     * occurred consistently during the model training period, and won't flag future similar spikes as anomalies.
     * </p>
     * 
     * @return Set this parameter to <code>true</code> if values for this metric consistently include spikes that should
     *         not be considered to be anomalies. With this set to <code>true</code>, CloudWatch will expect to see
     *         spikes that occurred consistently during the model training period, and won't flag future similar spikes
     *         as anomalies.
     */
    public final Boolean periodicSpikes() {
        return periodicSpikes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodicSpikes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricCharacteristics)) {
            return false;
        }
        MetricCharacteristics other = (MetricCharacteristics) obj;
        return Objects.equals(periodicSpikes(), other.periodicSpikes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricCharacteristics").add("PeriodicSpikes", periodicSpikes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeriodicSpikes":
            return Optional.ofNullable(clazz.cast(periodicSpikes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricCharacteristics, T> g) {
        return obj -> g.apply((MetricCharacteristics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricCharacteristics> {
        /**
         * <p>
         * Set this parameter to <code>true</code> if values for this metric consistently include spikes that should not
         * be considered to be anomalies. With this set to <code>true</code>, CloudWatch will expect to see spikes that
         * occurred consistently during the model training period, and won't flag future similar spikes as anomalies.
         * </p>
         * 
         * @param periodicSpikes
         *        Set this parameter to <code>true</code> if values for this metric consistently include spikes that
         *        should not be considered to be anomalies. With this set to <code>true</code>, CloudWatch will expect
         *        to see spikes that occurred consistently during the model training period, and won't flag future
         *        similar spikes as anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicSpikes(Boolean periodicSpikes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean periodicSpikes;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricCharacteristics model) {
            periodicSpikes(model.periodicSpikes);
        }

        public final Boolean getPeriodicSpikes() {
            return periodicSpikes;
        }

        public final void setPeriodicSpikes(Boolean periodicSpikes) {
            this.periodicSpikes = periodicSpikes;
        }

        @Override
        public final Builder periodicSpikes(Boolean periodicSpikes) {
            this.periodicSpikes = periodicSpikes;
            return this;
        }

        @Override
        public MetricCharacteristics build() {
            return new MetricCharacteristics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
