/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdiConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdiConfiguration> {
    private static final SdkField<EdiType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("type").getter(EdiConfiguration.getter(EdiConfiguration::type)).setter(EdiConfiguration.setter(Builder::type)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<S3Location> INPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputLocation").getter(EdiConfiguration.getter(EdiConfiguration::inputLocation)).setter(EdiConfiguration.setter(Builder::inputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLocation").build()}).build();
    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(EdiConfiguration.getter(EdiConfiguration::outputLocation)).setter(EdiConfiguration.setter(Builder::outputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerId").getter(EdiConfiguration.getter(EdiConfiguration::transformerId)).setter(EdiConfiguration.setter(Builder::transformerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, INPUT_LOCATION_FIELD, OUTPUT_LOCATION_FIELD, TRANSFORMER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final EdiType type;
    private final S3Location inputLocation;
    private final S3Location outputLocation;
    private final String transformerId;

    private EdiConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.inputLocation = builder.inputLocation;
        this.outputLocation = builder.outputLocation;
        this.transformerId = builder.transformerId;
    }

    public final EdiType type() {
        return this.type;
    }

    public final S3Location inputLocation() {
        return this.inputLocation;
    }

    public final S3Location outputLocation() {
        return this.outputLocation;
    }

    public final String transformerId() {
        return this.transformerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdiConfiguration)) {
            return false;
        }
        EdiConfiguration other = (EdiConfiguration)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.inputLocation(), other.inputLocation()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.transformerId(), other.transformerId());
    }

    public final String toString() {
        return ToString.builder((String)"EdiConfiguration").add("Type", (Object)this.type()).add("InputLocation", (Object)this.inputLocation()).add("OutputLocation", (Object)this.outputLocation()).add("TransformerId", (Object)this.transformerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "inputLocation": {
                return Optional.ofNullable(clazz.cast(this.inputLocation()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "transformerId": {
                return Optional.ofNullable(clazz.cast(this.transformerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdiConfiguration, T> g) {
        return obj -> g.apply((EdiConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EdiType type;
        private S3Location inputLocation;
        private S3Location outputLocation;
        private String transformerId;

        private BuilderImpl() {
        }

        private BuilderImpl(EdiConfiguration model) {
            this.type(model.type);
            this.inputLocation(model.inputLocation);
            this.outputLocation(model.outputLocation);
            this.transformerId(model.transformerId);
        }

        public final EdiType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(EdiType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(EdiType type) {
            this.type = type;
            return this;
        }

        public final S3Location.Builder getInputLocation() {
            return this.inputLocation != null ? this.inputLocation.toBuilder() : null;
        }

        public final void setInputLocation(S3Location.BuilderImpl inputLocation) {
            this.inputLocation = inputLocation != null ? inputLocation.build() : null;
        }

        @Override
        public final Builder inputLocation(S3Location inputLocation) {
            this.inputLocation = inputLocation;
            return this;
        }

        public final S3Location.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getTransformerId() {
            return this.transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public EdiConfiguration build() {
            return new EdiConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdiConfiguration> {
        public Builder type(EdiType var1);

        default public Builder type(Consumer<EdiType.Builder> type) {
            return this.type((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(type)).build());
        }

        public Builder inputLocation(S3Location var1);

        default public Builder inputLocation(Consumer<S3Location.Builder> inputLocation) {
            return this.inputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(inputLocation)).build());
        }

        public Builder outputLocation(S3Location var1);

        default public Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return this.outputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(outputLocation)).build());
        }

        public Builder transformerId(String var1);
    }
}

