/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.b2bi.endpoints.B2BiEndpointParams;
import software.amazon.awssdk.services.b2bi.endpoints.B2BiEndpointProvider;
import software.amazon.awssdk.services.b2bi.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.b2bi.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.b2bi.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultB2BiEndpointProvider
implements B2BiEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(B2BiEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(B2BiEndpointParams params, LocalState locals) {
        RuleResult result = DefaultB2BiEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultB2BiEndpointProvider.endpointRule6(params, locals);
    }

    private static RuleResult endpointRule1(B2BiEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultB2BiEndpointProvider.endpointRule3(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(B2BiEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(B2BiEndpointParams params, LocalState locals) {
        RuleResult result = DefaultB2BiEndpointProvider.endpointRule4(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultB2BiEndpointProvider.endpointRule5(params, locals);
    }

    private static RuleResult endpointRule4(B2BiEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(B2BiEndpointParams params, LocalState locals) {
        RuleResult result = DefaultB2BiEndpointProvider.endpointRule7(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultB2BiEndpointProvider.endpointRule26(params, locals);
    }

    private static RuleResult endpointRule7(B2BiEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultB2BiEndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(B2BiEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule9(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultB2BiEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultB2BiEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultB2BiEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(B2BiEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultB2BiEndpointProvider.endpointRule13(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(B2BiEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultB2BiEndpointProvider.endpointRule11(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(B2BiEndpointParams params, LocalState locals) {
        return DefaultB2BiEndpointProvider.endpointRule12(params, locals);
    }

    private static RuleResult endpointRule12(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://b2bi-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule13(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule14(B2BiEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultB2BiEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(B2BiEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultB2BiEndpointProvider.endpointRule16(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(B2BiEndpointParams params, LocalState locals) {
        return DefaultB2BiEndpointProvider.endpointRule17(params, locals);
    }

    private static RuleResult endpointRule17(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://b2bi-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule18(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule19(B2BiEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultB2BiEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultB2BiEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(B2BiEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultB2BiEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(B2BiEndpointParams params, LocalState locals) {
        return DefaultB2BiEndpointProvider.endpointRule22(params, locals);
    }

    private static RuleResult endpointRule22(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://b2bi." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule23(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule24(B2BiEndpointParams params, LocalState locals) {
        return DefaultB2BiEndpointProvider.endpointRule25(params, locals);
    }

    private static RuleResult endpointRule25(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://b2bi." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule26(B2BiEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

