/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A comment that's posted by a user on a control. This includes the author's name, the comment text, and a timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlComment implements SdkPojo, Serializable, ToCopyableBuilder<ControlComment.Builder, ControlComment> {
    private static final SdkField<String> AUTHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorName").getter(getter(ControlComment::authorName)).setter(setter(Builder::authorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorName").build()).build();

    private static final SdkField<String> COMMENT_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commentBody").getter(getter(ControlComment::commentBody)).setter(setter(Builder::commentBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentBody").build()).build();

    private static final SdkField<Instant> POSTED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("postedDate").getter(getter(ControlComment::postedDate)).setter(setter(Builder::postedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHOR_NAME_FIELD,
            COMMENT_BODY_FIELD, POSTED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authorName;

    private final String commentBody;

    private final Instant postedDate;

    private ControlComment(BuilderImpl builder) {
        this.authorName = builder.authorName;
        this.commentBody = builder.commentBody;
        this.postedDate = builder.postedDate;
    }

    /**
     * <p>
     * The name of the user who authored the comment.
     * </p>
     * 
     * @return The name of the user who authored the comment.
     */
    public final String authorName() {
        return authorName;
    }

    /**
     * <p>
     * The body text of a control comment.
     * </p>
     * 
     * @return The body text of a control comment.
     */
    public final String commentBody() {
        return commentBody;
    }

    /**
     * <p>
     * The time when the comment was posted.
     * </p>
     * 
     * @return The time when the comment was posted.
     */
    public final Instant postedDate() {
        return postedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorName());
        hashCode = 31 * hashCode + Objects.hashCode(commentBody());
        hashCode = 31 * hashCode + Objects.hashCode(postedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlComment)) {
            return false;
        }
        ControlComment other = (ControlComment) obj;
        return Objects.equals(authorName(), other.authorName()) && Objects.equals(commentBody(), other.commentBody())
                && Objects.equals(postedDate(), other.postedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlComment")
                .add("AuthorName", authorName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CommentBody", commentBody() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostedDate", postedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorName":
            return Optional.ofNullable(clazz.cast(authorName()));
        case "commentBody":
            return Optional.ofNullable(clazz.cast(commentBody()));
        case "postedDate":
            return Optional.ofNullable(clazz.cast(postedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlComment, T> g) {
        return obj -> g.apply((ControlComment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlComment> {
        /**
         * <p>
         * The name of the user who authored the comment.
         * </p>
         * 
         * @param authorName
         *        The name of the user who authored the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorName(String authorName);

        /**
         * <p>
         * The body text of a control comment.
         * </p>
         * 
         * @param commentBody
         *        The body text of a control comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentBody(String commentBody);

        /**
         * <p>
         * The time when the comment was posted.
         * </p>
         * 
         * @param postedDate
         *        The time when the comment was posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postedDate(Instant postedDate);
    }

    static final class BuilderImpl implements Builder {
        private String authorName;

        private String commentBody;

        private Instant postedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlComment model) {
            authorName(model.authorName);
            commentBody(model.commentBody);
            postedDate(model.postedDate);
        }

        public final String getAuthorName() {
            return authorName;
        }

        public final void setAuthorName(String authorName) {
            this.authorName = authorName;
        }

        @Override
        public final Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final String getCommentBody() {
            return commentBody;
        }

        public final void setCommentBody(String commentBody) {
            this.commentBody = commentBody;
        }

        @Override
        public final Builder commentBody(String commentBody) {
            this.commentBody = commentBody;
            return this;
        }

        public final Instant getPostedDate() {
            return postedDate;
        }

        public final void setPostedDate(Instant postedDate) {
            this.postedDate = postedDate;
        }

        @Override
        public final Builder postedDate(Instant postedDate) {
            this.postedDate = postedDate;
            return this;
        }

        @Override
        public ControlComment build() {
            return new ControlComment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
