/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentResponse extends AppConfigResponse implements
        ToCopyableBuilder<GetDeploymentResponse.Builder, GetDeploymentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetDeploymentResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(GetDeploymentResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStrategyId").getter(getter(GetDeploymentResponse::deploymentStrategyId))
            .setter(setter(Builder::deploymentStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStrategyId").build())
            .build();

    private static final SdkField<String> CONFIGURATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationProfileId").getter(getter(GetDeploymentResponse::configurationProfileId))
            .setter(setter(Builder::configurationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationProfileId").build())
            .build();

    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentNumber").getter(getter(GetDeploymentResponse::deploymentNumber))
            .setter(setter(Builder::deploymentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentNumber").build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(GetDeploymentResponse::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> CONFIGURATION_LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationLocationUri").getter(getter(GetDeploymentResponse::configurationLocationUri))
            .setter(setter(Builder::configurationLocationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationLocationUri").build())
            .build();

    private static final SdkField<String> CONFIGURATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationVersion").getter(getter(GetDeploymentResponse::configurationVersion))
            .setter(setter(Builder::configurationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationVersion").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetDeploymentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_DURATION_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentDurationInMinutes")
            .getter(getter(GetDeploymentResponse::deploymentDurationInMinutes))
            .setter(setter(Builder::deploymentDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentDurationInMinutes")
                    .build()).build();

    private static final SdkField<String> GROWTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrowthType").getter(getter(GetDeploymentResponse::growthTypeAsString))
            .setter(setter(Builder::growthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthType").build()).build();

    private static final SdkField<Float> GROWTH_FACTOR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("GrowthFactor").getter(getter(GetDeploymentResponse::growthFactor)).setter(setter(Builder::growthFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrowthFactor").build()).build();

    private static final SdkField<Integer> FINAL_BAKE_TIME_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FinalBakeTimeInMinutes").getter(getter(GetDeploymentResponse::finalBakeTimeInMinutes))
            .setter(setter(Builder::finalBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBakeTimeInMinutes").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetDeploymentResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<DeploymentEvent>> EVENT_LOG_FIELD = SdkField
            .<List<DeploymentEvent>> builder(MarshallingType.LIST)
            .memberName("EventLog")
            .getter(getter(GetDeploymentResponse::eventLog))
            .setter(setter(Builder::eventLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLog").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> PERCENTAGE_COMPLETE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("PercentageComplete").getter(getter(GetDeploymentResponse::percentageComplete))
            .setter(setter(Builder::percentageComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build())
            .build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt")
            .getter(getter(GetDeploymentResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedAt")
            .getter(getter(GetDeploymentResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<AppliedExtension>> APPLIED_EXTENSIONS_FIELD = SdkField
            .<List<AppliedExtension>> builder(MarshallingType.LIST)
            .memberName("AppliedExtensions")
            .getter(getter(GetDeploymentResponse::appliedExtensions))
            .setter(setter(Builder::appliedExtensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedExtensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppliedExtension> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppliedExtension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(GetDeploymentResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(GetDeploymentResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(GetDeploymentResponse::versionLabel)).setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ENVIRONMENT_ID_FIELD, DEPLOYMENT_STRATEGY_ID_FIELD, CONFIGURATION_PROFILE_ID_FIELD, DEPLOYMENT_NUMBER_FIELD,
            CONFIGURATION_NAME_FIELD, CONFIGURATION_LOCATION_URI_FIELD, CONFIGURATION_VERSION_FIELD, DESCRIPTION_FIELD,
            DEPLOYMENT_DURATION_IN_MINUTES_FIELD, GROWTH_TYPE_FIELD, GROWTH_FACTOR_FIELD, FINAL_BAKE_TIME_IN_MINUTES_FIELD,
            STATE_FIELD, EVENT_LOG_FIELD, PERCENTAGE_COMPLETE_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD,
            APPLIED_EXTENSIONS_FIELD, KMS_KEY_ARN_FIELD, KMS_KEY_IDENTIFIER_FIELD, VERSION_LABEL_FIELD));

    private final String applicationId;

    private final String environmentId;

    private final String deploymentStrategyId;

    private final String configurationProfileId;

    private final Integer deploymentNumber;

    private final String configurationName;

    private final String configurationLocationUri;

    private final String configurationVersion;

    private final String description;

    private final Integer deploymentDurationInMinutes;

    private final String growthType;

    private final Float growthFactor;

    private final Integer finalBakeTimeInMinutes;

    private final String state;

    private final List<DeploymentEvent> eventLog;

    private final Float percentageComplete;

    private final Instant startedAt;

    private final Instant completedAt;

    private final List<AppliedExtension> appliedExtensions;

    private final String kmsKeyArn;

    private final String kmsKeyIdentifier;

    private final String versionLabel;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentStrategyId = builder.deploymentStrategyId;
        this.configurationProfileId = builder.configurationProfileId;
        this.deploymentNumber = builder.deploymentNumber;
        this.configurationName = builder.configurationName;
        this.configurationLocationUri = builder.configurationLocationUri;
        this.configurationVersion = builder.configurationVersion;
        this.description = builder.description;
        this.deploymentDurationInMinutes = builder.deploymentDurationInMinutes;
        this.growthType = builder.growthType;
        this.growthFactor = builder.growthFactor;
        this.finalBakeTimeInMinutes = builder.finalBakeTimeInMinutes;
        this.state = builder.state;
        this.eventLog = builder.eventLog;
        this.percentageComplete = builder.percentageComplete;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.appliedExtensions = builder.appliedExtensions;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.versionLabel = builder.versionLabel;
    }

    /**
     * <p>
     * The ID of the application that was deployed.
     * </p>
     * 
     * @return The ID of the application that was deployed.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the environment that was deployed.
     * </p>
     * 
     * @return The ID of the environment that was deployed.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The ID of the deployment strategy that was deployed.
     * </p>
     * 
     * @return The ID of the deployment strategy that was deployed.
     */
    public final String deploymentStrategyId() {
        return deploymentStrategyId;
    }

    /**
     * <p>
     * The ID of the configuration profile that was deployed.
     * </p>
     * 
     * @return The ID of the configuration profile that was deployed.
     */
    public final String configurationProfileId() {
        return configurationProfileId;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @return The sequence number of the deployment.
     */
    public final Integer deploymentNumber() {
        return deploymentNumber;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String configurationName() {
        return configurationName;
    }

    /**
     * <p>
     * Information about the source location of the configuration.
     * </p>
     * 
     * @return Information about the source location of the configuration.
     */
    public final String configurationLocationUri() {
        return configurationLocationUri;
    }

    /**
     * <p>
     * The configuration version that was deployed.
     * </p>
     * 
     * @return The configuration version that was deployed.
     */
    public final String configurationVersion() {
        return configurationVersion;
    }

    /**
     * <p>
     * The description of the deployment.
     * </p>
     * 
     * @return The description of the deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @return Total amount of time the deployment lasted.
     */
    public final Integer deploymentDurationInMinutes() {
        return deploymentDurationInMinutes;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */
    public final GrowthType growthType() {
        return GrowthType.fromValue(growthType);
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #growthType} will
     * return {@link GrowthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #growthTypeAsString}.
     * </p>
     * 
     * @return The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */
    public final String growthTypeAsString() {
        return growthType;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets to receive a deployed configuration during each interval.
     */
    public final Float growthFactor() {
        return growthFactor;
    }

    /**
     * <p>
     * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no
     * longer eligible for automatic rollback.
     * </p>
     * 
     * @return The amount of time that AppConfig monitored for alarms before considering the deployment to be complete
     *         and no longer eligible for automatic rollback.
     */
    public final Integer finalBakeTimeInMinutes() {
        return finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public final DeploymentState state() {
        return DeploymentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DeploymentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventLog property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventLog() {
        return eventLog != null && !(eventLog instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventLog} method.
     * </p>
     * 
     * @return A list containing all events related to a deployment. The most recent events are displayed first.
     */
    public final List<DeploymentEvent> eventLog() {
        return eventLog;
    }

    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     * 
     * @return The percentage of targets for which the deployment is available.
     */
    public final Float percentageComplete() {
        return percentageComplete;
    }

    /**
     * <p>
     * The time the deployment started.
     * </p>
     * 
     * @return The time the deployment started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The time the deployment completed.
     * </p>
     * 
     * @return The time the deployment completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppliedExtensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppliedExtensions() {
        return appliedExtensions != null && !(appliedExtensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppliedExtensions} method.
     * </p>
     * 
     * @return A list of extensions that were processed as part of the deployment. The extensions that were previously
     *         associated to the configuration profile, environment, or the application when
     *         <code>StartDeployment</code> was called.
     */
    public final List<AppliedExtension> appliedExtensions() {
        return appliedExtensions;
    }

    /**
     * <p>
     * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt
     * secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or
     * secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * </p>
     * 
     * @return The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
     *         encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted
     *         with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created
     * or updated.
     * </p>
     * 
     * @return The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was
     *         created or updated.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * A user-defined label for an AppConfig hosted configuration version.
     * </p>
     * 
     * @return A user-defined label for an AppConfig hosted configuration version.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationLocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(configurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(growthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(growthFactor());
        hashCode = 31 * hashCode + Objects.hashCode(finalBakeTimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventLog() ? eventLog() : null);
        hashCode = 31 * hashCode + Objects.hashCode(percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppliedExtensions() ? appliedExtensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(deploymentStrategyId(), other.deploymentStrategyId())
                && Objects.equals(configurationProfileId(), other.configurationProfileId())
                && Objects.equals(deploymentNumber(), other.deploymentNumber())
                && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(configurationLocationUri(), other.configurationLocationUri())
                && Objects.equals(configurationVersion(), other.configurationVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(deploymentDurationInMinutes(), other.deploymentDurationInMinutes())
                && Objects.equals(growthTypeAsString(), other.growthTypeAsString())
                && Objects.equals(growthFactor(), other.growthFactor())
                && Objects.equals(finalBakeTimeInMinutes(), other.finalBakeTimeInMinutes())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasEventLog() == other.hasEventLog()
                && Objects.equals(eventLog(), other.eventLog())
                && Objects.equals(percentageComplete(), other.percentageComplete())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(completedAt(), other.completedAt())
                && hasAppliedExtensions() == other.hasAppliedExtensions()
                && Objects.equals(appliedExtensions(), other.appliedExtensions())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(versionLabel(), other.versionLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeploymentResponse").add("ApplicationId", applicationId())
                .add("EnvironmentId", environmentId()).add("DeploymentStrategyId", deploymentStrategyId())
                .add("ConfigurationProfileId", configurationProfileId()).add("DeploymentNumber", deploymentNumber())
                .add("ConfigurationName", configurationName()).add("ConfigurationLocationUri", configurationLocationUri())
                .add("ConfigurationVersion", configurationVersion()).add("Description", description())
                .add("DeploymentDurationInMinutes", deploymentDurationInMinutes()).add("GrowthType", growthTypeAsString())
                .add("GrowthFactor", growthFactor()).add("FinalBakeTimeInMinutes", finalBakeTimeInMinutes())
                .add("State", stateAsString()).add("EventLog", hasEventLog() ? eventLog() : null)
                .add("PercentageComplete", percentageComplete()).add("StartedAt", startedAt()).add("CompletedAt", completedAt())
                .add("AppliedExtensions", hasAppliedExtensions() ? appliedExtensions() : null).add("KmsKeyArn", kmsKeyArn())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).add("VersionLabel", versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "DeploymentStrategyId":
            return Optional.ofNullable(clazz.cast(deploymentStrategyId()));
        case "ConfigurationProfileId":
            return Optional.ofNullable(clazz.cast(configurationProfileId()));
        case "DeploymentNumber":
            return Optional.ofNullable(clazz.cast(deploymentNumber()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "ConfigurationLocationUri":
            return Optional.ofNullable(clazz.cast(configurationLocationUri()));
        case "ConfigurationVersion":
            return Optional.ofNullable(clazz.cast(configurationVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeploymentDurationInMinutes":
            return Optional.ofNullable(clazz.cast(deploymentDurationInMinutes()));
        case "GrowthType":
            return Optional.ofNullable(clazz.cast(growthTypeAsString()));
        case "GrowthFactor":
            return Optional.ofNullable(clazz.cast(growthFactor()));
        case "FinalBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(finalBakeTimeInMinutes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EventLog":
            return Optional.ofNullable(clazz.cast(eventLog()));
        case "PercentageComplete":
            return Optional.ofNullable(clazz.cast(percentageComplete()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "AppliedExtensions":
            return Optional.ofNullable(clazz.cast(appliedExtensions()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeploymentResponse> {
        /**
         * <p>
         * The ID of the application that was deployed.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the environment that was deployed.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The ID of the deployment strategy that was deployed.
         * </p>
         * 
         * @param deploymentStrategyId
         *        The ID of the deployment strategy that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStrategyId(String deploymentStrategyId);

        /**
         * <p>
         * The ID of the configuration profile that was deployed.
         * </p>
         * 
         * @param configurationProfileId
         *        The ID of the configuration profile that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationProfileId(String configurationProfileId);

        /**
         * <p>
         * The sequence number of the deployment.
         * </p>
         * 
         * @param deploymentNumber
         *        The sequence number of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentNumber(Integer deploymentNumber);

        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param configurationName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * <p>
         * Information about the source location of the configuration.
         * </p>
         * 
         * @param configurationLocationUri
         *        Information about the source location of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationLocationUri(String configurationLocationUri);

        /**
         * <p>
         * The configuration version that was deployed.
         * </p>
         * 
         * @param configurationVersion
         *        The configuration version that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationVersion(String configurationVersion);

        /**
         * <p>
         * The description of the deployment.
         * </p>
         * 
         * @param description
         *        The description of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Total amount of time the deployment lasted.
         * </p>
         * 
         * @param deploymentDurationInMinutes
         *        Total amount of time the deployment lasted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes);

        /**
         * <p>
         * The algorithm used to define how percentage grew over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grew over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(String growthType);

        /**
         * <p>
         * The algorithm used to define how percentage grew over time.
         * </p>
         * 
         * @param growthType
         *        The algorithm used to define how percentage grew over time.
         * @see GrowthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GrowthType
         */
        Builder growthType(GrowthType growthType);

        /**
         * <p>
         * The percentage of targets to receive a deployed configuration during each interval.
         * </p>
         * 
         * @param growthFactor
         *        The percentage of targets to receive a deployed configuration during each interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder growthFactor(Float growthFactor);

        /**
         * <p>
         * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and
         * no longer eligible for automatic rollback.
         * </p>
         * 
         * @param finalBakeTimeInMinutes
         *        The amount of time that AppConfig monitored for alarms before considering the deployment to be
         *        complete and no longer eligible for automatic rollback.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes);

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param state
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the deployment.
         * </p>
         * 
         * @param state
         *        The state of the deployment.
         * @see DeploymentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentState
         */
        Builder state(DeploymentState state);

        /**
         * <p>
         * A list containing all events related to a deployment. The most recent events are displayed first.
         * </p>
         * 
         * @param eventLog
         *        A list containing all events related to a deployment. The most recent events are displayed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventLog(Collection<DeploymentEvent> eventLog);

        /**
         * <p>
         * A list containing all events related to a deployment. The most recent events are displayed first.
         * </p>
         * 
         * @param eventLog
         *        A list containing all events related to a deployment. The most recent events are displayed first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventLog(DeploymentEvent... eventLog);

        /**
         * <p>
         * A list containing all events related to a deployment. The most recent events are displayed first.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appconfig.model.DeploymentEvent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appconfig.model.DeploymentEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appconfig.model.DeploymentEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #eventLog(List<DeploymentEvent>)}.
         * 
         * @param eventLog
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appconfig.model.DeploymentEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventLog(java.util.Collection<DeploymentEvent>)
         */
        Builder eventLog(Consumer<DeploymentEvent.Builder>... eventLog);

        /**
         * <p>
         * The percentage of targets for which the deployment is available.
         * </p>
         * 
         * @param percentageComplete
         *        The percentage of targets for which the deployment is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageComplete(Float percentageComplete);

        /**
         * <p>
         * The time the deployment started.
         * </p>
         * 
         * @param startedAt
         *        The time the deployment started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The time the deployment completed.
         * </p>
         * 
         * @param completedAt
         *        The time the deployment completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * A list of extensions that were processed as part of the deployment. The extensions that were previously
         * associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
         * was called.
         * </p>
         * 
         * @param appliedExtensions
         *        A list of extensions that were processed as part of the deployment. The extensions that were
         *        previously associated to the configuration profile, environment, or the application when
         *        <code>StartDeployment</code> was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedExtensions(Collection<AppliedExtension> appliedExtensions);

        /**
         * <p>
         * A list of extensions that were processed as part of the deployment. The extensions that were previously
         * associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
         * was called.
         * </p>
         * 
         * @param appliedExtensions
         *        A list of extensions that were processed as part of the deployment. The extensions that were
         *        previously associated to the configuration profile, environment, or the application when
         *        <code>StartDeployment</code> was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedExtensions(AppliedExtension... appliedExtensions);

        /**
         * <p>
         * A list of extensions that were processed as part of the deployment. The extensions that were previously
         * associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
         * was called.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appconfig.model.AppliedExtension.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appconfig.model.AppliedExtension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appconfig.model.AppliedExtension.Builder#build()} is called
         * immediately and its result is passed to {@link #appliedExtensions(List<AppliedExtension>)}.
         * 
         * @param appliedExtensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appconfig.model.AppliedExtension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedExtensions(java.util.Collection<AppliedExtension>)
         */
        Builder appliedExtensions(Consumer<AppliedExtension.Builder>... appliedExtensions);

        /**
         * <p>
         * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
         * encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with
         * SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
         *        encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted
         *        with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter
         *        Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was
         * created or updated.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource
         *        was created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * A user-defined label for an AppConfig hosted configuration version.
         * </p>
         * 
         * @param versionLabel
         *        A user-defined label for an AppConfig hosted configuration version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);
    }

    static final class BuilderImpl extends AppConfigResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String environmentId;

        private String deploymentStrategyId;

        private String configurationProfileId;

        private Integer deploymentNumber;

        private String configurationName;

        private String configurationLocationUri;

        private String configurationVersion;

        private String description;

        private Integer deploymentDurationInMinutes;

        private String growthType;

        private Float growthFactor;

        private Integer finalBakeTimeInMinutes;

        private String state;

        private List<DeploymentEvent> eventLog = DefaultSdkAutoConstructList.getInstance();

        private Float percentageComplete;

        private Instant startedAt;

        private Instant completedAt;

        private List<AppliedExtension> appliedExtensions = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyArn;

        private String kmsKeyIdentifier;

        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            applicationId(model.applicationId);
            environmentId(model.environmentId);
            deploymentStrategyId(model.deploymentStrategyId);
            configurationProfileId(model.configurationProfileId);
            deploymentNumber(model.deploymentNumber);
            configurationName(model.configurationName);
            configurationLocationUri(model.configurationLocationUri);
            configurationVersion(model.configurationVersion);
            description(model.description);
            deploymentDurationInMinutes(model.deploymentDurationInMinutes);
            growthType(model.growthType);
            growthFactor(model.growthFactor);
            finalBakeTimeInMinutes(model.finalBakeTimeInMinutes);
            state(model.state);
            eventLog(model.eventLog);
            percentageComplete(model.percentageComplete);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
            appliedExtensions(model.appliedExtensions);
            kmsKeyArn(model.kmsKeyArn);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            versionLabel(model.versionLabel);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDeploymentStrategyId() {
            return deploymentStrategyId;
        }

        public final void setDeploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
        }

        @Override
        public final Builder deploymentStrategyId(String deploymentStrategyId) {
            this.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        public final String getConfigurationProfileId() {
            return configurationProfileId;
        }

        public final void setConfigurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
        }

        @Override
        public final Builder configurationProfileId(String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        public final Integer getDeploymentNumber() {
            return deploymentNumber;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getConfigurationLocationUri() {
            return configurationLocationUri;
        }

        public final void setConfigurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
        }

        @Override
        public final Builder configurationLocationUri(String configurationLocationUri) {
            this.configurationLocationUri = configurationLocationUri;
            return this;
        }

        public final String getConfigurationVersion() {
            return configurationVersion;
        }

        public final void setConfigurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
        }

        @Override
        public final Builder configurationVersion(String configurationVersion) {
            this.configurationVersion = configurationVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeploymentDurationInMinutes() {
            return deploymentDurationInMinutes;
        }

        public final void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
        }

        @Override
        public final Builder deploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
            this.deploymentDurationInMinutes = deploymentDurationInMinutes;
            return this;
        }

        public final String getGrowthType() {
            return growthType;
        }

        public final void setGrowthType(String growthType) {
            this.growthType = growthType;
        }

        @Override
        public final Builder growthType(String growthType) {
            this.growthType = growthType;
            return this;
        }

        @Override
        public final Builder growthType(GrowthType growthType) {
            this.growthType(growthType == null ? null : growthType.toString());
            return this;
        }

        public final Float getGrowthFactor() {
            return growthFactor;
        }

        public final void setGrowthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
        }

        @Override
        public final Builder growthFactor(Float growthFactor) {
            this.growthFactor = growthFactor;
            return this;
        }

        public final Integer getFinalBakeTimeInMinutes() {
            return finalBakeTimeInMinutes;
        }

        public final void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
        }

        @Override
        public final Builder finalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
            this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DeploymentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<DeploymentEvent.Builder> getEventLog() {
            List<DeploymentEvent.Builder> result = DeploymentEventsCopier.copyToBuilder(this.eventLog);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventLog(Collection<DeploymentEvent.BuilderImpl> eventLog) {
            this.eventLog = DeploymentEventsCopier.copyFromBuilder(eventLog);
        }

        @Override
        public final Builder eventLog(Collection<DeploymentEvent> eventLog) {
            this.eventLog = DeploymentEventsCopier.copy(eventLog);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLog(DeploymentEvent... eventLog) {
            eventLog(Arrays.asList(eventLog));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventLog(Consumer<DeploymentEvent.Builder>... eventLog) {
            eventLog(Stream.of(eventLog).map(c -> DeploymentEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Float getPercentageComplete() {
            return percentageComplete;
        }

        public final void setPercentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Float percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final List<AppliedExtension.Builder> getAppliedExtensions() {
            List<AppliedExtension.Builder> result = AppliedExtensionsCopier.copyToBuilder(this.appliedExtensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedExtensions(Collection<AppliedExtension.BuilderImpl> appliedExtensions) {
            this.appliedExtensions = AppliedExtensionsCopier.copyFromBuilder(appliedExtensions);
        }

        @Override
        public final Builder appliedExtensions(Collection<AppliedExtension> appliedExtensions) {
            this.appliedExtensions = AppliedExtensionsCopier.copy(appliedExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedExtensions(AppliedExtension... appliedExtensions) {
            appliedExtensions(Arrays.asList(appliedExtensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedExtensions(Consumer<AppliedExtension.Builder>... appliedExtensions) {
            appliedExtensions(Stream.of(appliedExtensions).map(c -> AppliedExtension.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
