/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegionsRequest extends AccountRequest implements
        ToCopyableBuilder<ListRegionsRequest.Builder, ListRegionsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListRegionsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRegionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> REGION_OPT_STATUS_CONTAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegionOptStatusContains")
            .getter(getter(ListRegionsRequest::regionOptStatusContainsAsStrings))
            .setter(setter(Builder::regionOptStatusContainsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOptStatusContains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REGION_OPT_STATUS_CONTAINS_FIELD));

    private final String accountId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> regionOptStatusContains;

    private ListRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.regionOptStatusContains = builder.regionOptStatusContains;
    }

    /**
     * <p>
     * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
     * with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation. To use this parameter, the caller must be an identity in the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >organization's management account</a> or a delegated administrator account. The specified account ID must be a
     * member account in the same organization. The organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features enabled</a>, and the organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     * access</a> enabled for the Account Management service, and optionally a <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
     * admin</a> account assigned.
     * </p>
     * <note>
     * <p>
     * The management account can't specify its own <code>AccountId</code>. It must call the operation in standalone
     * context by not including the <code>AccountId</code> parameter.
     * </p>
     * </note>
     * <p>
     * To call this operation on an account that is not a member of an organization, don't specify this parameter.
     * Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or
     * modify.
     * </p>
     * 
     * @return Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
     *         modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services
     *         account of the identity used to call the operation. To use this parameter, the caller must be an identity
     *         in the <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     *         >organization's management account</a> or a delegated administrator account. The specified account ID
     *         must be a member account in the same organization. The organization must have <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >all features enabled</a>, and the organization must have <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     *         access</a> enabled for the Account Management service, and optionally a <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
     *         >delegated admin</a> account assigned.</p> <note>
     *         <p>
     *         The management account can't specify its own <code>AccountId</code>. It must call the operation in
     *         standalone context by not including the <code>AccountId</code> parameter.
     *         </p>
     *         </note>
     *         <p>
     *         To call this operation on an account that is not a member of an organization, don't specify this
     *         parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish
     *         to retrieve or modify.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The total number of items to return in the command’s output. If the total number of items available is more than
     * the value specified, a <code>NextToken</code> is provided in the command’s output. To resume pagination, provide
     * the <code>NextToken</code> value in the <code>starting-token</code> argument of a subsequent command. Do not use
     * the <code>NextToken</code> response element directly outside of the Amazon Web Services CLI. For usage examples,
     * see <a href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon Web
     * Services Command Line Interface User Guide</i>.
     * </p>
     * 
     * @return The total number of items to return in the command’s output. If the total number of items available is
     *         more than the value specified, a <code>NextToken</code> is provided in the command’s output. To resume
     *         pagination, provide the <code>NextToken</code> value in the <code>starting-token</code> argument of a
     *         subsequent command. Do not use the <code>NextToken</code> response element directly outside of the Amazon
     *         Web Services CLI. For usage examples, see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon
     *         Web Services Command Line Interface User Guide</i>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token used to specify where to start paginating. This is the <code>NextToken</code> from a previously truncated
     * response. For usage examples, see <a
     * href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon Web
     * Services Command Line Interface User Guide</i>.
     * </p>
     * 
     * @return A token used to specify where to start paginating. This is the <code>NextToken</code> from a previously
     *         truncated response. For usage examples, see <a
     *         href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon
     *         Web Services Command Line Interface User Guide</i>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the list
     * of Regions for a given account. For example, passing in a value of ENABLING will only return a list of Regions
     * with a Region status of ENABLING.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionOptStatusContains} method.
     * </p>
     * 
     * @return A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter
     *         the list of Regions for a given account. For example, passing in a value of ENABLING will only return a
     *         list of Regions with a Region status of ENABLING.
     */
    public final List<RegionOptStatus> regionOptStatusContains() {
        return RegionOptStatusListCopier.copyStringToEnum(regionOptStatusContains);
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionOptStatusContains property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegionOptStatusContains() {
        return regionOptStatusContains != null && !(regionOptStatusContains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the list
     * of Regions for a given account. For example, passing in a value of ENABLING will only return a list of Regions
     * with a Region status of ENABLING.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionOptStatusContains} method.
     * </p>
     * 
     * @return A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter
     *         the list of Regions for a given account. For example, passing in a value of ENABLING will only return a
     *         list of Regions with a Region status of ENABLING.
     */
    public final List<String> regionOptStatusContainsAsStrings() {
        return regionOptStatusContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionOptStatusContains() ? regionOptStatusContainsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionsRequest)) {
            return false;
        }
        ListRegionsRequest other = (ListRegionsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && hasRegionOptStatusContains() == other.hasRegionOptStatusContains()
                && Objects.equals(regionOptStatusContainsAsStrings(), other.regionOptStatusContainsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegionsRequest").add("AccountId", accountId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken())
                .add("RegionOptStatusContains", hasRegionOptStatusContains() ? regionOptStatusContainsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RegionOptStatusContains":
            return Optional.ofNullable(clazz.cast(regionOptStatusContainsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegionsRequest, T> g) {
        return obj -> g.apply((ListRegionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccountRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRegionsRequest> {
        /**
         * <p>
         * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
         * with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of
         * the identity used to call the operation. To use this parameter, the caller must be an identity in the <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">
         * organization's management account</a> or a delegated administrator account. The specified account ID must be
         * a member account in the same organization. The organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         * >all features enabled</a>, and the organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
         * access</a> enabled for the Account Management service, and optionally a <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
         * admin</a> account assigned.
         * </p>
         * <note>
         * <p>
         * The management account can't specify its own <code>AccountId</code>. It must call the operation in standalone
         * context by not including the <code>AccountId</code> parameter.
         * </p>
         * </note>
         * <p>
         * To call this operation on an account that is not a member of an organization, don't specify this parameter.
         * Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or
         * modify.
         * </p>
         * 
         * @param accountId
         *        Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
         *        modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web
         *        Services account of the identity used to call the operation. To use this parameter, the caller must be
         *        an identity in the <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         *        >organization's management account</a> or a delegated administrator account. The specified account ID
         *        must be a member account in the same organization. The organization must have <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         *        >all features enabled</a>, and the organization must have <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html"
         *        >trusted access</a> enabled for the Account Management service, and optionally a <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
         *        >delegated admin</a> account assigned.</p> <note>
         *        <p>
         *        The management account can't specify its own <code>AccountId</code>. It must call the operation in
         *        standalone context by not including the <code>AccountId</code> parameter.
         *        </p>
         *        </note>
         *        <p>
         *        To call this operation on an account that is not a member of an organization, don't specify this
         *        parameter. Instead, call the operation using an identity belonging to the account whose contacts you
         *        wish to retrieve or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The total number of items to return in the command’s output. If the total number of items available is more
         * than the value specified, a <code>NextToken</code> is provided in the command’s output. To resume pagination,
         * provide the <code>NextToken</code> value in the <code>starting-token</code> argument of a subsequent command.
         * Do not use the <code>NextToken</code> response element directly outside of the Amazon Web Services CLI. For
         * usage examples, see <a href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a>
         * in the <i>Amazon Web Services Command Line Interface User Guide</i>.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return in the command’s output. If the total number of items available is
         *        more than the value specified, a <code>NextToken</code> is provided in the command’s output. To resume
         *        pagination, provide the <code>NextToken</code> value in the <code>starting-token</code> argument of a
         *        subsequent command. Do not use the <code>NextToken</code> response element directly outside of the
         *        Amazon Web Services CLI. For usage examples, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon
         *        Web Services Command Line Interface User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token used to specify where to start paginating. This is the <code>NextToken</code> from a previously
         * truncated response. For usage examples, see <a
         * href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon Web
         * Services Command Line Interface User Guide</i>.
         * </p>
         * 
         * @param nextToken
         *        A token used to specify where to start paginating. This is the <code>NextToken</code> from a
         *        previously truncated response. For usage examples, see <a
         *        href="http://docs.aws.amazon.com/cli/latest/userguide/pagination.html">Pagination</a> in the <i>Amazon
         *        Web Services Command Line Interface User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the
         * list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of
         * Regions with a Region status of ENABLING.
         * </p>
         * 
         * @param regionOptStatusContains
         *        A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to
         *        filter the list of Regions for a given account. For example, passing in a value of ENABLING will only
         *        return a list of Regions with a Region status of ENABLING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOptStatusContainsWithStrings(Collection<String> regionOptStatusContains);

        /**
         * <p>
         * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the
         * list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of
         * Regions with a Region status of ENABLING.
         * </p>
         * 
         * @param regionOptStatusContains
         *        A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to
         *        filter the list of Regions for a given account. For example, passing in a value of ENABLING will only
         *        return a list of Regions with a Region status of ENABLING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOptStatusContainsWithStrings(String... regionOptStatusContains);

        /**
         * <p>
         * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the
         * list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of
         * Regions with a Region status of ENABLING.
         * </p>
         * 
         * @param regionOptStatusContains
         *        A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to
         *        filter the list of Regions for a given account. For example, passing in a value of ENABLING will only
         *        return a list of Regions with a Region status of ENABLING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOptStatusContains(Collection<RegionOptStatus> regionOptStatusContains);

        /**
         * <p>
         * A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to filter the
         * list of Regions for a given account. For example, passing in a value of ENABLING will only return a list of
         * Regions with a Region status of ENABLING.
         * </p>
         * 
         * @param regionOptStatusContains
         *        A list of Region statuses (Enabling, Enabled, Disabling, Disabled, Enabled_by_default) to use to
         *        filter the list of Regions for a given account. For example, passing in a value of ENABLING will only
         *        return a list of Regions with a Region status of ENABLING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOptStatusContains(RegionOptStatus... regionOptStatusContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccountRequest.BuilderImpl implements Builder {
        private String accountId;

        private Integer maxResults;

        private String nextToken;

        private List<String> regionOptStatusContains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionsRequest model) {
            super(model);
            accountId(model.accountId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            regionOptStatusContainsWithStrings(model.regionOptStatusContains);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getRegionOptStatusContains() {
            if (regionOptStatusContains instanceof SdkAutoConstructList) {
                return null;
            }
            return regionOptStatusContains;
        }

        public final void setRegionOptStatusContains(Collection<String> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copy(regionOptStatusContains);
        }

        @Override
        public final Builder regionOptStatusContainsWithStrings(Collection<String> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copy(regionOptStatusContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOptStatusContainsWithStrings(String... regionOptStatusContains) {
            regionOptStatusContainsWithStrings(Arrays.asList(regionOptStatusContains));
            return this;
        }

        @Override
        public final Builder regionOptStatusContains(Collection<RegionOptStatus> regionOptStatusContains) {
            this.regionOptStatusContains = RegionOptStatusListCopier.copyEnumToString(regionOptStatusContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOptStatusContains(RegionOptStatus... regionOptStatusContains) {
            regionOptStatusContains(Arrays.asList(regionOptStatusContains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRegionsRequest build() {
            return new ListRegionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
