/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.fauxpas.FauxPas;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.HttpStatusAdapter;
import org.zalando.problem.spring.web.advice.Lists;
import org.zalando.problem.spring.web.advice.MediaTypes;

public interface AdviceTrait {
    public static final Logger LOG = LoggerFactory.getLogger(AdviceTrait.class);

    default public ResponseEntity<Problem> create(Throwable throwable, NativeWebRequest request) {
        ThrowableProblem problem = this.toProblem(throwable);
        return this.create(throwable, (Problem)problem, request);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request) {
        return this.create(status, throwable, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, HttpHeaders headers) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status), request, headers);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, URI type) {
        return this.create(status, throwable, request, new HttpHeaders(), type);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, HttpHeaders headers, URI type) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status, type), request, headers);
    }

    default public ThrowableProblem toProblem(Throwable throwable) {
        StatusType status = this.resolveStatus(throwable).map(HttpStatusAdapter::new).orElse((StatusType)Status.INTERNAL_SERVER_ERROR);
        return this.toProblem(throwable, status);
    }

    default public Optional<HttpStatus> resolveStatus(Throwable type) {
        ResponseStatus candidate = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(type.getClass(), ResponseStatus.class);
        if (candidate == null) {
            if (type.getCause() == null) {
                return Optional.empty();
            }
            return this.resolveStatus(type.getCause());
        }
        return Optional.of(candidate.code());
    }

    default public ThrowableProblem toProblem(Throwable throwable, StatusType status) {
        return this.toProblem(throwable, status, Problem.DEFAULT_TYPE);
    }

    default public ThrowableProblem toProblem(Throwable throwable, StatusType status, URI type) {
        StackTraceElement[] stackTrace;
        Throwable cause = throwable.getCause();
        ProblemBuilder builder = Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage());
        if (cause == null || !this.isCausalChainsEnabled()) {
            stackTrace = throwable.getStackTrace();
        } else {
            builder.withCause(this.toProblem(cause));
            StackTraceElement[] next = cause.getStackTrace();
            StackTraceElement[] current = throwable.getStackTrace();
            int length = current.length - Lists.lengthOfTrailingPartialSubList(Arrays.asList(next), Arrays.asList(current));
            stackTrace = new StackTraceElement[length];
            System.arraycopy(current, 0, stackTrace, 0, length);
        }
        ThrowableProblem problem = builder.build();
        problem.setStackTrace(stackTrace);
        return problem;
    }

    default public boolean isCausalChainsEnabled() {
        return false;
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request) {
        return this.create(problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request, HttpHeaders headers) {
        return this.create((Throwable)problem, (Problem)problem, request, headers);
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request) {
        return this.create(throwable, problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request, HttpHeaders headers) {
        HttpStatus status = HttpStatus.valueOf((int)Optional.ofNullable(problem.getStatus()).orElse((StatusType)Status.INTERNAL_SERVER_ERROR).getStatusCode());
        this.log(throwable, problem, request, status);
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            request.setAttribute("javax.servlet.error.exception", (Object)throwable, 0);
        }
        return this.process((ResponseEntity<Problem>)this.negotiate(request).map(contentType -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).contentType(contentType).body((Object)problem)).orElseGet((Supplier<ResponseEntity>)FauxPas.throwingSupplier(() -> {
            ResponseEntity<Problem> fallback = this.fallback(throwable, problem, request, headers);
            if (fallback.getBody() == null) {
                ServletServerHttpResponse response = new ServletServerHttpResponse((HttpServletResponse)request.getNativeResponse(HttpServletResponse.class));
                response.setStatusCode(fallback.getStatusCode());
                response.getHeaders().putAll((Map)fallback.getHeaders());
                response.getBody();
                response.flush();
            }
            return fallback;
        })));
    }

    default public void log(Throwable throwable, Problem problem, NativeWebRequest request, HttpStatus status) {
        if (status.is4xxClientError()) {
            LOG.warn("{}: {}", (Object)status.getReasonPhrase(), (Object)throwable.getMessage());
        } else if (status.is5xxServerError()) {
            LOG.error(status.getReasonPhrase(), throwable);
        }
    }

    default public Optional<MediaType> negotiate(NativeWebRequest request) {
        HeaderContentNegotiationStrategy negotiator = new HeaderContentNegotiationStrategy();
        List mediaTypes = negotiator.resolveMediaTypes(request);
        if (mediaTypes.isEmpty()) {
            return Optional.of(MediaTypes.PROBLEM);
        }
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.includes(MediaType.APPLICATION_JSON) || mediaType.includes(MediaTypes.PROBLEM)) {
                return Optional.of(MediaTypes.PROBLEM);
            }
            if (!mediaType.includes(MediaTypes.X_PROBLEM)) continue;
            return Optional.of(MediaTypes.X_PROBLEM);
        }
        boolean isNeitherAcceptingJsonNorProblemJsonButSomeVendorSpecificJson = mediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaTypes.WILDCARD_JSON).includes(arg_0));
        if (isNeitherAcceptingJsonNorProblemJsonButSomeVendorSpecificJson) {
            return Optional.of(MediaTypes.PROBLEM);
        }
        return Optional.empty();
    }

    default public ResponseEntity<Problem> fallback(Throwable throwable, Problem problem, NativeWebRequest request, HttpHeaders headers) {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body(null);
    }

    default public ResponseEntity<Problem> process(ResponseEntity<Problem> entity) {
        return entity;
    }
}

