/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonFormatter;
import wiremock.org.xmlunit.diff.ComparisonType;
import wiremock.org.xmlunit.util.TransformerFactoryConfigurer;

public class DefaultComparisonFormatter
implements ComparisonFormatter {
    private TransformerFactory factory;

    @Override
    public String getDescription(Comparison difference) {
        ComparisonType type = difference.getType();
        String description = type.getDescription();
        Comparison.Detail controlDetails = difference.getControlDetails();
        Comparison.Detail testDetails = difference.getTestDetails();
        String controlTarget = this.getShortString(controlDetails.getTarget(), controlDetails.getXPath(), type);
        String testTarget = this.getShortString(testDetails.getTarget(), testDetails.getXPath(), type);
        if (type == ComparisonType.ATTR_NAME_LOOKUP) {
            return String.format("Expected %s '%s' - comparing %s to %s", description, controlDetails.getXPath(), controlTarget, testTarget);
        }
        return String.format("Expected %s '%s' but was '%s' - comparing %s to %s", description, this.getValue(controlDetails.getValue(), type), this.getValue(testDetails.getValue(), type), controlTarget, testTarget);
    }

    public void setTransformerFactory(TransformerFactory f) {
        this.factory = f;
    }

    protected Object getValue(Object value, ComparisonType type) {
        return type == ComparisonType.NODE_TYPE ? this.nodeType((Short)value) : value;
    }

    protected String getShortString(Node node, String xpath, ComparisonType type) {
        StringBuilder sb = new StringBuilder();
        if (type == ComparisonType.HAS_DOCTYPE_DECLARATION) {
            Document doc = (Document)node;
            this.appendDocumentType(sb, doc.getDoctype());
            this.appendDocumentElementIndication(sb, doc);
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            this.appendDocumentXmlDeclaration(sb, doc);
            this.appendDocumentElementIndication(sb, doc);
        } else if (node instanceof DocumentType) {
            DocumentType docType = (DocumentType)node;
            this.appendDocumentType(sb, docType);
            this.appendDocumentElementIndication(sb, docType.getOwnerDocument());
        } else if (node instanceof Attr) {
            this.appendAttribute(sb, (Attr)node);
        } else if (node instanceof Element) {
            this.appendElement(sb, (Element)node);
        } else if (node instanceof Text) {
            this.appendText(sb, (Text)node);
        } else if (node instanceof Comment) {
            this.appendComment(sb, (Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.appendProcessingInstruction(sb, (ProcessingInstruction)node);
        } else if (node == null) {
            sb.append("<NULL>");
        } else {
            sb.append("<!--NodeType ").append(node.getNodeType()).append(' ').append(node.getNodeName()).append('/').append(node.getNodeValue()).append("-->");
        }
        this.appendXPath(sb, xpath);
        return sb.toString();
    }

    protected void appendXPath(StringBuilder sb, String xpath) {
        if (xpath != null && xpath.length() > 0) {
            sb.append(" at ").append(xpath);
        }
    }

    protected boolean appendDocumentXmlDeclaration(StringBuilder sb, Document doc) {
        if ("1.0".equals(doc.getXmlVersion()) && doc.getXmlEncoding() == null && !doc.getXmlStandalone()) {
            return false;
        }
        sb.append("<?xml version=\"");
        sb.append(doc.getXmlVersion());
        sb.append("\"");
        if (doc.getXmlEncoding() != null) {
            sb.append(" encoding=\"");
            sb.append(doc.getXmlEncoding());
            sb.append("\"");
        }
        if (doc.getXmlStandalone()) {
            sb.append(" standalone=\"yes\"");
        }
        sb.append("?>");
        return true;
    }

    protected void appendDocumentElementIndication(StringBuilder sb, Document doc) {
        sb.append("<");
        sb.append(doc.getDocumentElement().getNodeName());
        sb.append("...>");
    }

    protected boolean appendDocumentType(StringBuilder sb, DocumentType type) {
        if (type == null) {
            return false;
        }
        sb.append("<!DOCTYPE ").append(type.getName());
        boolean hasNoPublicId = true;
        if (type.getPublicId() != null && type.getPublicId().length() > 0) {
            sb.append(" PUBLIC \"").append(type.getPublicId()).append('\"');
            hasNoPublicId = false;
        }
        if (type.getSystemId() != null && type.getSystemId().length() > 0) {
            if (hasNoPublicId) {
                sb.append(" SYSTEM");
            }
            sb.append(" \"").append(type.getSystemId()).append("\"");
        }
        sb.append(">");
        return true;
    }

    protected void appendProcessingInstruction(StringBuilder sb, ProcessingInstruction instr) {
        sb.append("<?").append(instr.getTarget()).append(' ').append(instr.getData()).append("?>");
    }

    protected void appendComment(StringBuilder sb, Comment aNode) {
        sb.append("<!--").append(aNode.getNodeValue()).append("-->");
    }

    protected void appendText(StringBuilder sb, Text aNode) {
        sb.append("<").append(aNode.getParentNode().getNodeName()).append(" ...>");
        if (aNode instanceof CDATASection) {
            sb.append("<![CDATA[").append(aNode.getNodeValue()).append("]]>");
        } else {
            sb.append(aNode.getNodeValue());
        }
        sb.append("</").append(aNode.getParentNode().getNodeName()).append(">");
    }

    protected void appendElement(StringBuilder sb, Element aNode) {
        sb.append("<").append(aNode.getNodeName()).append("...").append(">");
    }

    protected void appendAttribute(StringBuilder sb, Attr aNode) {
        sb.append("<").append(aNode.getOwnerElement().getNodeName());
        sb.append(' ').append(aNode.getNodeName()).append("=\"").append(aNode.getNodeValue()).append("\"...>");
    }

    @Override
    public String getDetails(Comparison.Detail difference, ComparisonType type, boolean formatXml) {
        if (difference.getTarget() == null) {
            return "<NULL>";
        }
        return this.getFullFormattedXml(difference.getTarget(), type, formatXml);
    }

    protected String getFullFormattedXml(Node node, ComparisonType type, boolean formatXml) {
        Node nodeToConvert;
        StringBuilder sb = new StringBuilder();
        if (type == ComparisonType.CHILD_NODELIST_SEQUENCE) {
            nodeToConvert = node.getParentNode();
        } else {
            if (node instanceof Document) {
                Document doc = (Document)node;
                this.appendFullDocumentHeader(sb, doc);
                return sb.toString();
            }
            if (node instanceof DocumentType) {
                Document doc = node.getOwnerDocument();
                this.appendFullDocumentHeader(sb, doc);
                return sb.toString();
            }
            nodeToConvert = node instanceof Attr ? ((Attr)node).getOwnerElement() : (node instanceof CharacterData ? node.getParentNode() : node);
        }
        sb.append(this.getFormattedNodeXml(nodeToConvert, formatXml));
        return sb.toString().trim();
    }

    protected void appendFullDocumentHeader(StringBuilder sb, Document doc) {
        if (this.appendDocumentXmlDeclaration(sb, doc)) {
            sb.append("\n");
        }
        if (this.appendDocumentType(sb, doc.getDoctype())) {
            sb.append("\n");
        }
        this.appendOnlyElementStartTagWithAttributes(sb, doc.getDocumentElement());
    }

    private void appendOnlyElementStartTagWithAttributes(StringBuilder sb, Element element) {
        sb.append("<");
        sb.append(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!(node instanceof Attr)) continue;
            Attr attr = (Attr)node;
            sb.append(" ");
            sb.append(attr.toString());
        }
        if (element.hasChildNodes()) {
            sb.append(">\n  ...");
        } else {
            sb.append("/>");
        }
    }

    protected String getFormattedNodeXml(Node nodeToConvert, boolean formatXml) {
        String formattedNodeXml;
        try {
            int numberOfBlanksToIndent = formatXml ? 2 : -1;
            Transformer transformer = this.createXmlTransformer(numberOfBlanksToIndent);
            StringWriter buffer = new StringWriter();
            transformer.transform(new DOMSource(nodeToConvert), new StreamResult(buffer));
            formattedNodeXml = buffer.toString();
        }
        catch (Exception e) {
            formattedNodeXml = "ERROR " + e.getMessage();
        }
        return formattedNodeXml;
    }

    protected Transformer createXmlTransformer(int numberOfBlanksToIndent) throws TransformerConfigurationException {
        TransformerFactory fac = this.factory;
        if (fac == null) {
            TransformerFactoryConfigurer.Builder b = TransformerFactoryConfigurer.builder().withExternalStylesheetLoadingDisabled().withDTDLoadingDisabled();
            if (numberOfBlanksToIndent >= 0) {
                b = b.withSafeAttribute("indent-number", numberOfBlanksToIndent);
            }
            fac = b.build().configure(TransformerFactory.newInstance());
        }
        Transformer transformer = fac.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        if (numberOfBlanksToIndent >= 0) {
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(numberOfBlanksToIndent));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            transformer.setOutputProperty("indent", "yes");
        }
        return transformer;
    }

    protected String nodeType(short type) {
        switch (type) {
            case 1: {
                return "Element";
            }
            case 10: {
                return "Document Type";
            }
            case 6: {
                return "Entity";
            }
            case 5: {
                return "Entity Reference";
            }
            case 12: {
                return "Notation";
            }
            case 3: {
                return "Text";
            }
            case 8: {
                return "Comment";
            }
            case 4: {
                return "CDATA Section";
            }
            case 2: {
                return "Attribute";
            }
            case 7: {
                return "Processing Instruction";
            }
        }
        return Short.toString(type);
    }
}

