/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static <T> ClassLoader getLoader(Class<T> className) {
        return ParameterUtils.getFirstNonNull(className.getClassLoader(), Thread.currentThread().getContextClassLoader());
    }

    public static <T> URL getResource(Class<T> className, String resourceName) {
        ClassLoader loader = ResourceUtil.getLoader(className);
        URL url = loader.getResource(resourceName);
        ParameterUtils.checkParameter(url != null, String.format("resource %s not found.", resourceName));
        return loader.getResource(resourceName);
    }

    public static <T> URI getResourceURI(Class<T> className, String resourceName) {
        try {
            return ResourceUtil.getResource(className, resourceName).toURI();
        }
        catch (URISyntaxException e) {
            return Exceptions.throwUnchecked(e, URI.class);
        }
    }

    public static <T> Path getResourcePath(Class<T> className, String resourceName) {
        return Paths.get(ResourceUtil.getResourceURI(className, resourceName));
    }
}

