/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import com.github.tomakehurst.wiremock.common.NetworkAddressUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class NetworkAddressRules {
    private final Set<NetworkAddressRange> allowed;
    private final Set<NetworkAddressRange> allowedHostPatterns;
    private final Set<NetworkAddressRange> denied;
    private final Set<NetworkAddressRange> deniedHostPatterns;
    public static final NetworkAddressRules ALLOW_ALL = new NetworkAddressRules(Set.of(NetworkAddressRange.ALL), Collections.emptySet());

    public static Builder builder() {
        return new Builder();
    }

    public NetworkAddressRules(Set<NetworkAddressRange> allowed, Set<NetworkAddressRange> denied) {
        this.allowed = NetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet()), Set.of(NetworkAddressRange.ALL));
        this.allowedHostPatterns = NetworkAddressRules.defaultIfEmpty(allowed.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).collect(Collectors.toSet()), Set.of(NetworkAddressRange.ALL));
        this.denied = denied.stream().filter(networkAddressRange -> !(networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard)).collect(Collectors.toSet());
        this.deniedHostPatterns = denied.stream().filter(networkAddressRange -> networkAddressRange instanceof NetworkAddressRange.DomainNameWildcard).map(networkAddressRange -> (NetworkAddressRange.DomainNameWildcard)networkAddressRange).collect(Collectors.toSet());
    }

    private static <T> Set<T> defaultIfEmpty(Set<T> original, Set<T> ifEmpty) {
        if (original.isEmpty()) {
            return ifEmpty;
        }
        return original;
    }

    public boolean isAllowed(String testValue) {
        if (NetworkAddressUtils.isValidInet4Address(testValue)) {
            return this.allowed.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.denied.stream().noneMatch(rule -> rule.isIncluded(testValue));
        }
        return this.allowedHostPatterns.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.deniedHostPatterns.stream().noneMatch(rule -> rule.isIncluded(testValue));
    }

    public static class Builder {
        private final Set<NetworkAddressRange> allowed = new HashSet<NetworkAddressRange>();
        private final Set<NetworkAddressRange> denied = new HashSet<NetworkAddressRange>();

        public Builder allow(String expression) {
            this.allowed.add(NetworkAddressRange.of(expression));
            return this;
        }

        public Builder deny(String expression) {
            this.denied.add(NetworkAddressRange.of(expression));
            return this;
        }

        public NetworkAddressRules build() {
            Set<NetworkAddressRange> allowedRanges = this.allowed;
            if (allowedRanges.isEmpty()) {
                allowedRanges = Set.of(NetworkAddressRange.ALL);
            }
            return new NetworkAddressRules(Set.copyOf(allowedRanges), Set.copyOf(this.denied));
        }
    }
}

