/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class FormParser {
    public static Map<String, ListOrSingle<String>> parse(String formText, boolean urlDecode) {
        return FormParser.parse(formText, urlDecode, "utf-8");
    }

    public static Map<String, ListOrSingle<String>> parse(String formText, boolean urlDecode, String encoding) {
        LinkedHashMap<String, ListOrSingle<String>> map = new LinkedHashMap<String, ListOrSingle<String>>();
        for (String formField : formText.split("&")) {
            String[] parts = formField.split("=");
            if (parts.length <= 1) continue;
            String key = parts[0];
            String value = urlDecode ? FormParser.urlDecode(parts[1].trim(), encoding) : parts[1].trim();
            ListOrSingle existing = (ListOrSingle)map.get(key);
            if (existing != null) {
                existing.add(value);
                continue;
            }
            map.put(key, ListOrSingle.of(new String[]{value}));
        }
        return map;
    }

    private static String urlDecode(String text, String encoding) {
        try {
            return URLDecoder.decode(text, encoding);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }
}

