/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time;

import wiremock.com.ethlo.time.DateTimeParser;
import wiremock.com.ethlo.time.DateTimeTokens;
import wiremock.com.ethlo.time.Field;
import wiremock.com.ethlo.time.internal.fixed.ITUParser;
import wiremock.com.ethlo.time.token.ConfigurableDateTimeParser;
import wiremock.com.ethlo.time.token.DateTimeToken;

public class DateTimeParsers {
    private static final ConfigurableDateTimeParser DATE = (ConfigurableDateTimeParser)DateTimeParsers.of(DateTimeTokens.digits(Field.YEAR, 4), DateTimeTokens.separators('-'), DateTimeTokens.digits(Field.MONTH, 2), DateTimeTokens.separators('-'), DateTimeTokens.digits(Field.DAY, 2));
    private static final DateTimeParser LOCAL_TIME = DateTimeParsers.of(DateTimeTokens.digits(Field.HOUR, 2), DateTimeTokens.separators(':'), DateTimeTokens.digits(Field.MINUTE, 2), DateTimeTokens.separators(':'), DateTimeTokens.digits(Field.SECOND, 2), DateTimeTokens.separators('.'), DateTimeTokens.fractions());

    public static DateTimeParser of(DateTimeToken ... tokens) {
        return ConfigurableDateTimeParser.of(tokens);
    }

    public static DateTimeParser rfc3339() {
        return ITUParser.getInstance();
    }

    public static DateTimeParser localDate() {
        return DATE;
    }

    public static DateTimeParser localTime() {
        return LOCAL_TIME;
    }
}

