/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.client;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.org.apache.hc.client5.http.entity.GzipCompressingEntity;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.ContentType;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpEntity;
import wiremock.org.apache.hc.core5.http.NameValuePair;
import wiremock.org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import wiremock.org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import wiremock.org.apache.hc.core5.http.io.entity.EntityUtils;
import wiremock.org.apache.hc.core5.http.io.entity.InputStreamEntity;
import wiremock.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import wiremock.org.apache.hc.core5.http.message.BasicHeader;

public class ApacheBackedHttpClient
implements HttpClient {
    private final CloseableHttpClient apacheHttpClient;
    private final boolean preserveUserAgentProxyHeader;

    public ApacheBackedHttpClient(CloseableHttpClient apacheHttpClient, boolean preserveUserAgentProxyHeader) {
        this.apacheHttpClient = apacheHttpClient;
        this.preserveUserAgentProxyHeader = preserveUserAgentProxyHeader;
    }

    @Override
    public Response execute(Request request) throws IOException {
        ClassicHttpRequest apacheRequest = ApacheBackedHttpClient.createApacheRequest(request, this.preserveUserAgentProxyHeader);
        return this.apacheHttpClient.execute(apacheRequest, ApacheBackedHttpClient::toWireMockHttpResponse);
    }

    private static ClassicHttpRequest createApacheRequest(Request request, boolean preserveUserAgentProxyHeader) {
        ContentType contentType = request.contentTypeHeader().isPresent() ? ContentType.parse(request.contentTypeHeader().firstValue()) : ContentType.APPLICATION_OCTET_STREAM.withCharset(StandardCharsets.UTF_8);
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create(request.getMethod().getName()).setUri(request.getAbsoluteUrl()).setHeaders((Header[])request.getHeaders().all().stream().filter(header -> !FORBIDDEN_REQUEST_HEADERS.contains(header.key().toLowerCase()) || preserveUserAgentProxyHeader && header.key().equalsIgnoreCase("user-agent")).flatMap(header -> header.values().stream().map(headerValue -> new BasicHeader(header.key(), headerValue))).toArray(Header[]::new));
        if (request.getBody() != null) {
            AbstractHttpEntity entity = request.containsHeader("transfer-encoding") && request.header("transfer-encoding").firstValue().equals("chunked") ? new InputStreamEntity(new ByteArrayInputStream(request.getBody()), -1L, contentType) : new ByteArrayEntity(request.getBody(), request.contentTypeHeader().isPresent() ? contentType : null);
            requestBuilder.setEntity(ApacheBackedHttpClient.applyGzipWrapperIfRequired(request, entity));
        }
        return requestBuilder.build();
    }

    private static HttpEntity applyGzipWrapperIfRequired(Request originalRequest, HttpEntity content) {
        if (originalRequest.containsHeader("content-encoding") && originalRequest.header("content-encoding").firstValue().contains("gzip")) {
            return new GzipCompressingEntity(content);
        }
        return content;
    }

    private static Response toWireMockHttpResponse(ClassicHttpResponse apacheResponse) throws IOException {
        List<HttpHeader> headers = Arrays.stream(apacheResponse.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName)).entrySet().stream().map(entry -> new HttpHeader((String)entry.getKey(), (Collection<String>)((List)entry.getValue()).stream().map(NameValuePair::getValue).collect(Collectors.toUnmodifiableList()))).collect(Collectors.toUnmodifiableList());
        Response.Builder responseBuilder = Response.response().status(apacheResponse.getCode()).headers(new HttpHeaders(headers)).protocol(apacheResponse.getVersion().toString());
        HttpEntity entity = apacheResponse.getEntity();
        if (entity != null) {
            responseBuilder.body(EntityUtils.toByteArray(entity));
        }
        if (apacheResponse.getReasonPhrase() != null) {
            responseBuilder.statusMessage(apacheResponse.getReasonPhrase());
        }
        return responseBuilder.build();
    }
}

