/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.AbstractFormattingHelper;

public class FormatJsonHelper
extends AbstractFormattingHelper {
    @Override
    String getName() {
        return "formatJson";
    }

    @Override
    String getDataFormat() {
        return "JSON";
    }

    @Override
    protected String apply(String bodyText, AbstractFormattingHelper.Format format) {
        try {
            switch (format) {
                case pretty: {
                    return Json.prettyPrint(bodyText);
                }
                case compact: {
                    return Json.node(bodyText).toString();
                }
            }
            throw new IllegalStateException();
        }
        catch (JsonException e) {
            return this.handleError("There was an error parsing the json. Please make sure the json is valid", e);
        }
    }
}

