/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.xml.DelegateDocumentBuilderFactory;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class SkipResolvingEntitiesDocumentBuilderFactory
extends DelegateDocumentBuilderFactory {
    SkipResolvingEntitiesDocumentBuilderFactory(DocumentBuilderFactory delegate) {
        super(delegate);
    }

    @Override
    public DocumentBuilder newDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = this.delegate.newDocumentBuilder();
            documentBuilder.setEntityResolver(new ResolveToEmptyString());
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            return Exceptions.throwUnchecked(e, DocumentBuilder.class);
        }
    }

    private static class ResolveToEmptyString
    implements EntityResolver {
        private ResolveToEmptyString() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

