/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.EnableWireMock;
import org.wiremock.spring.internal.WireMockContextCustomizer;

public class WireMockContextCustomizerFactory
implements ContextCustomizerFactory {
    static final ConfigureWireMock DEFAULT_CONFIGURE_WIREMOCK = DefaultConfigureWireMock.class.getAnnotation(ConfigureWireMock.class);

    static ConfigureWireMock[] getConfigureWireMocksOrDefault(ConfigureWireMock ... configureWireMock) {
        if (configureWireMock == null || configureWireMock.length == 0) {
            return new ConfigureWireMock[]{DEFAULT_CONFIGURE_WIREMOCK};
        }
        return configureWireMock;
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ConfigureWiremockHolder holder = new ConfigureWiremockHolder();
        this.parseDefinitions(testClass, holder);
        if (holder.isEmpty()) {
            return null;
        }
        return new WireMockContextCustomizer(holder.asArray());
    }

    private void parseDefinitions(Class<?> testClass, ConfigureWiremockHolder parser) {
        parser.parse(testClass);
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.parseDefinitions(testClass.getEnclosingClass(), parser);
        }
    }

    private static class ConfigureWiremockHolder {
        private final List<ConfigureWireMock> annotations = new ArrayList<ConfigureWireMock>();

        private ConfigureWiremockHolder() {
        }

        void add(ConfigureWireMock ... annotations) {
            this.annotations.addAll(Arrays.asList(annotations));
            this.sanityCheckDuplicateNames(this.annotations);
            this.sanityCheckHttpOrHttpsMustBeEnabled(this.annotations);
            this.sanityCheckHttpAndHttpsMustUseDifferentPorts(this.annotations);
            this.sanityCheckUniquePorts(this.annotations);
        }

        void parse(Class<?> clazz) {
            EnableWireMock annotation = (EnableWireMock)AnnotationUtils.findAnnotation(clazz, EnableWireMock.class);
            if (annotation != null) {
                this.add(WireMockContextCustomizerFactory.getConfigureWireMocksOrDefault(annotation.value()));
            }
        }

        private void sanityCheckDuplicateNames(List<ConfigureWireMock> check) {
            List<String> names = check.stream().map(it -> it.name()).toList();
            Set dublicateNames = names.stream().filter(it -> Collections.frequency(names, it) > 1).collect(Collectors.toSet());
            if (!dublicateNames.isEmpty()) {
                throw new IllegalStateException("Names of mocks must be unique, found duplicates of: " + dublicateNames.stream().sorted().collect(Collectors.joining(",")));
            }
        }

        private void sanityCheckHttpOrHttpsMustBeEnabled(List<ConfigureWireMock> check) {
            for (ConfigureWireMock configureWireMock : check) {
                if (configureWireMock.port() != -1 || configureWireMock.httpsPort() != -1) continue;
                throw new IllegalStateException("ConfigureWireMock " + configureWireMock.name() + " has both HTTP and HTTPS disabled. It is an invalid configuration.");
            }
        }

        private void sanityCheckUniquePorts(List<ConfigureWireMock> check) {
            List ports = check.stream().map(it -> List.of(Integer.valueOf(it.port()), Integer.valueOf(it.httpsPort()))).toList().stream().collect(ArrayList::new, List::addAll, List::addAll);
            Set dublicatePors = ports.stream().filter(it -> it > 0).filter(it -> Collections.frequency(ports, it) > 1).collect(Collectors.toSet());
            if (!dublicatePors.isEmpty()) {
                throw new IllegalStateException("Some statically configured ports are being used mor than once: " + dublicatePors.stream().sorted().map(it -> it.toString()).collect(Collectors.joining(",")));
            }
        }

        private void sanityCheckHttpAndHttpsMustUseDifferentPorts(List<ConfigureWireMock> check) {
            for (ConfigureWireMock configureWireMock : check) {
                if (configureWireMock.port() <= 0 || configureWireMock.port() != configureWireMock.httpsPort()) continue;
                throw new IllegalStateException("ConfigureWireMock " + configureWireMock.name() + " uses same port " + configureWireMock.port() + " for HTTP and HTTPS.");
            }
        }

        boolean isEmpty() {
            return this.annotations.isEmpty();
        }

        ConfigureWireMock[] asArray() {
            return this.annotations.toArray(new ConfigureWireMock[0]);
        }
    }

    @ConfigureWireMock(name="wiremock")
    private static class DefaultConfigureWireMock {
        private DefaultConfigureWireMock() {
        }
    }
}

