/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.util.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.io.IOUtils;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.util.js.CachedCompilation;
import org.visallo.web.util.js.SourceMapType;

public class BabelExecutor {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(BabelExecutor.class);
    private ScriptEngine engine;
    private Bindings bindings;
    private Future babelFuture;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public BabelExecutor() {
        this.babelFuture = this.executorService.submit(() -> this.initializeBabel());
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(() -> {
            this.babelFuture.get();
            return task.call();
        });
    }

    public synchronized void compileWithSharedEngine(CachedCompilation cachedCompilation, SourceMapType sourceMapType) throws ScriptException {
        ScriptEngine engine = this.engine;
        Bindings bindings = this.bindings;
        bindings.put("input", (Object)cachedCompilation.getInput());
        bindings.put("resourcePath", (Object)cachedCompilation.getResourcePath());
        bindings.put("sourcePath", (Object)(cachedCompilation.getPath() + ".src"));
        bindings.put("sourceMapType", this.sourceMapJsType(sourceMapType));
        Object output = engine.eval(this.getTransformJavaScript(), bindings);
        Bindings result = (Bindings)output;
        if (result.containsKey("error")) {
            throw new VisalloException((String)result.get("error"));
        }
        if (sourceMapType == SourceMapType.EXTERNAL) {
            String sourceMap = (String)result.get("sourceMap");
            cachedCompilation.setSourceMap(sourceMap);
        }
        cachedCompilation.setOutput((String)result.get("code"));
    }

    private String getTransformJavaScript() {
        String transform = null;
        try (StringWriter writer = new StringWriter();){
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("babel-transform.js"), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            transform = writer.toString();
        }
        catch (IOException e) {
            throw new VisalloException("Unable to read babel transformer");
        }
        if (transform == null) {
            throw new VisalloException("Babel configuration not found");
        }
        return transform;
    }

    private Object sourceMapJsType(SourceMapType sourceMapType) {
        switch (sourceMapType) {
            case EXTERNAL: {
                return true;
            }
            case INLINE: {
                return "inline";
            }
        }
        return false;
    }

    private void initializeBabel() {
        try {
            long start = System.nanoTime();
            LOGGER.info("Initializing Babel Transformer...", new Object[0]);
            InputStreamReader babelReader = new InputStreamReader(this.getClass().getResourceAsStream("babel.js"));
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            if (engine == null) {
                throw new VisalloException("JavaScript Engine \"nashorn\" not found. Unable to compile jsx");
            }
            SimpleBindings bindings = new SimpleBindings();
            engine.eval((Reader)babelReader, (Bindings)bindings);
            LOGGER.info("Babel Transformer initialized in %d seconds...", new Object[]{TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start)});
            this.engine = engine;
            this.bindings = bindings;
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize babel transpiler: %s", new Object[]{e.getMessage()});
            throw new VisalloException("Unable to initialize babel transpiler", (Throwable)e);
        }
    }
}

