/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.notification.ExpirationAge;
import org.visallo.core.model.notification.ExpirationAgeUnit;
import org.visallo.core.model.notification.UserNotificationRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.clientapi.model.ClientApiWorkspace;
import org.visallo.web.clientapi.model.ClientApiWorkspaceUpdateData;
import org.visallo.web.clientapi.model.GraphPosition;
import org.visallo.web.clientapi.model.WorkspaceAccess;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.SourceGuid;

public class WorkspaceUpdate
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceUpdate.class);
    private final WorkspaceRepository workspaceRepository;
    private final WorkQueueRepository workQueueRepository;
    private final UserNotificationRepository userNotificationRepository;

    @Inject
    public WorkspaceUpdate(WorkspaceRepository workspaceRepository, WorkQueueRepository workQueueRepository, UserNotificationRepository userNotificationRepository) {
        this.workspaceRepository = workspaceRepository;
        this.workQueueRepository = workQueueRepository;
        this.userNotificationRepository = userNotificationRepository;
    }

    @Handle
    public ClientApiSuccess handle(@Required(name="data") ClientApiWorkspaceUpdateData updateData, @ActiveWorkspaceId String workspaceId, @SourceGuid String sourceGuid, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        if (workspace == null) {
            throw new VisalloResourceNotFoundException("Could not find workspace: " + workspaceId);
        }
        if (updateData.getTitle() != null) {
            this.setTitle(workspace, updateData.getTitle(), user);
        }
        this.updateEntities(workspace, updateData.getEntityUpdates(), user);
        this.deleteEntities(workspace, updateData.getEntityDeletes(), user);
        this.updateUsers(workspace, updateData.getUserUpdates(), resourceBundle, user);
        workspace = this.workspaceRepository.findById(workspaceId, user);
        ClientApiWorkspace clientApiWorkspaceAfterUpdateButBeforeDelete = this.workspaceRepository.toClientApi(workspace, user, true, authorizations);
        List previousUsers = clientApiWorkspaceAfterUpdateButBeforeDelete.getUsers();
        this.deleteUsers(workspace, updateData.getUserDeletes(), user);
        ClientApiWorkspace clientApiWorkspace = this.workspaceRepository.toClientApi(workspace, user, true, authorizations);
        this.workQueueRepository.pushWorkspaceChange(clientApiWorkspace, previousUsers, user.getUserId(), sourceGuid);
        return VisalloResponse.SUCCESS;
    }

    private void setTitle(Workspace workspace, String title, User authUser) {
        LOGGER.debug("setting title (%s): %s", new Object[]{workspace.getWorkspaceId(), title});
        this.workspaceRepository.setTitle(workspace, title, authUser);
    }

    private void deleteUsers(Workspace workspace, List<String> userDeletes, User authUser) {
        for (String userId : userDeletes) {
            LOGGER.debug("user delete (%s): %s", new Object[]{workspace.getWorkspaceId(), userId});
            this.workspaceRepository.deleteUserFromWorkspace(workspace, userId, authUser);
            this.workQueueRepository.pushWorkspaceDelete(workspace.getWorkspaceId(), userId);
        }
    }

    private void updateUsers(Workspace workspace, List<ClientApiWorkspaceUpdateData.UserUpdate> userUpdates, ResourceBundle resourceBundle, User authUser) {
        for (ClientApiWorkspaceUpdateData.UserUpdate update : userUpdates) {
            String subtitle;
            String title;
            LOGGER.debug("user update (%s): %s", new Object[]{workspace.getWorkspaceId(), update.toString()});
            String userId = update.getUserId();
            WorkspaceAccess workspaceAccess = update.getAccess();
            WorkspaceRepository.UpdateUserOnWorkspaceResult updateUserOnWorkspaceResults = this.workspaceRepository.updateUserOnWorkspace(workspace, userId, workspaceAccess, authUser);
            switch (updateUserOnWorkspaceResults) {
                case UPDATE: {
                    title = resourceBundle.getString("workspaces.notification.shareUpdated.title");
                    subtitle = resourceBundle.getString("workspaces.notification.shareUpdated.subtitle");
                    break;
                }
                default: {
                    title = resourceBundle.getString("workspaces.notification.shared.title");
                    subtitle = resourceBundle.getString("workspaces.notification.shared.subtitle");
                }
            }
            String message = MessageFormat.format(subtitle, authUser.getDisplayName(), workspace.getDisplayTitle());
            JSONObject payload = new JSONObject();
            payload.put("workspaceId", (Object)workspace.getWorkspaceId());
            this.userNotificationRepository.createNotification(userId, title, message, "switchWorkspace", payload, new ExpirationAge(7, ExpirationAgeUnit.DAY), authUser);
        }
    }

    private void deleteEntities(Workspace workspace, List<String> entityIdsToDelete, User authUser) {
        this.workspaceRepository.softDeleteEntitiesFromWorkspace(workspace, entityIdsToDelete, authUser);
    }

    private void updateEntities(Workspace workspace, List<ClientApiWorkspaceUpdateData.EntityUpdate> entityUpdates, User authUser) {
        List updates = Lists.transform(entityUpdates, (Function)new Function<ClientApiWorkspaceUpdateData.EntityUpdate, WorkspaceRepository.Update>(){

            @Nullable
            public WorkspaceRepository.Update apply(ClientApiWorkspaceUpdateData.EntityUpdate u) {
                String vertexId = u.getVertexId();
                GraphPosition graphPosition = u.getGraphPosition();
                String graphLayoutJson = u.getGraphLayoutJson();
                return new WorkspaceRepository.Update(vertexId, Boolean.valueOf(true), graphPosition, graphLayoutJson);
            }
        });
        this.workspaceRepository.updateEntitiesOnWorkspace(workspace, (Collection)updates, authUser);
    }
}

