/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.util.Arrays;
import org.vertexium.Authorizations;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.workspace.WorkspaceUndoHelper;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiUndoItem;
import org.visallo.web.clientapi.model.ClientApiWorkspaceUndoResponse;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class WorkspaceUndo
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceUndo.class);
    private final WorkspaceUndoHelper workspaceUndoHelper;

    @Inject
    public WorkspaceUndo(WorkspaceUndoHelper workspaceUndoHelper, OntologyRepository ontologyRepository) {
        String artifactContainsImageOfEntityIri;
        this.workspaceUndoHelper = workspaceUndoHelper;
        String entityHasImageIri = ontologyRepository.getRelationshipIRIByIntent("entityHasImage");
        if (entityHasImageIri == null) {
            LOGGER.warn("'entityHasImage' intent has not been defined. Please update your ontology.", new Object[0]);
        }
        if ((artifactContainsImageOfEntityIri = ontologyRepository.getRelationshipIRIByIntent("artifactContainsImageOfEntity")) == null) {
            LOGGER.warn("'artifactContainsImageOfEntity' intent has not been defined. Please update your ontology.", new Object[0]);
        }
    }

    @Handle
    public ClientApiWorkspaceUndoResponse handle(@Required(name="undoData") ClientApiUndoItem[] undoData, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        LOGGER.debug("undoing:\n%s", new Object[]{Joiner.on((String)"\n").join((Object[])undoData)});
        ClientApiWorkspaceUndoResponse workspaceUndoResponse = new ClientApiWorkspaceUndoResponse();
        this.workspaceUndoHelper.undo(Arrays.asList(undoData), workspaceUndoResponse, workspaceId, user, authorizations);
        LOGGER.debug("undoing results: %s", new Object[]{workspaceUndoResponse});
        return workspaceUndoResponse;
    }
}

