/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.BadRequestException;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class VertexSetPropertyVisibility
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexSetPropertyVisibility.class);
    private final Graph graph;
    private final WorkspaceRepository workspaceRepository;
    private final VisibilityTranslator visibilityTranslator;
    private final GraphRepository graphRepository;
    private final WorkQueueRepository workQueueRepository;

    @Inject
    public VertexSetPropertyVisibility(Graph graph, WorkspaceRepository workspaceRepository, VisibilityTranslator visibilityTranslator, GraphRepository graphRepository, WorkQueueRepository workQueueRepository) {
        this.graph = graph;
        this.workspaceRepository = workspaceRepository;
        this.visibilityTranslator = visibilityTranslator;
        this.graphRepository = graphRepository;
        this.workQueueRepository = workQueueRepository;
    }

    @Handle
    public ClientApiSuccess handle(@Required(name="graphVertexId") String graphVertexId, @Required(name="newVisibilitySource") String newVisibilitySource, @Optional(name="oldVisibilitySource") String oldVisibilitySource, @Optional(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        if (vertex == null) {
            throw new VisalloResourceNotFoundException("Could not find vertex: " + graphVertexId, (Object)graphVertexId);
        }
        if (!this.graph.isVisibilityValid(this.visibilityTranslator.toVisibility(newVisibilitySource).getVisibility(), authorizations)) {
            LOGGER.warn("%s is not a valid visibility for %s user", new Object[]{newVisibilitySource, user.getDisplayName()});
            throw new BadRequestException("newVisibilitySource", resourceBundle.getString("visibility.invalid"));
        }
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, graphVertexId, null, null, user);
        Property property = this.graphRepository.updatePropertyVisibilitySource((Element)vertex, propertyKey, propertyName, oldVisibilitySource, newVisibilitySource, workspaceId, user, authorizations);
        this.graph.flush();
        this.workQueueRepository.pushGraphPropertyQueue((Element)vertex, property, workspaceId, newVisibilitySource, Priority.HIGH);
        return VisalloResponse.SUCCESS;
    }
}

