/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.Locale;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiHistoricalPropertyResults;

public class VertexGetHistory
implements ParameterizedHandler {
    private Graph graph;

    @Inject
    public VertexGetHistory(Graph graph) {
        this.graph = graph;
    }

    @Handle
    public ClientApiHistoricalPropertyResults handle(@Required(name="graphVertexId") String graphVertexId, @Optional(name="startTime") Long startTime, @Optional(name="endTime") Long endTime, Locale locale, ResourceBundle resourceBundle, Authorizations authorizations) throws Exception {
        Vertex vertex = this.graph.getVertex(graphVertexId, authorizations);
        if (vertex == null) {
            throw new VisalloResourceNotFoundException(String.format("vertex %s not found", graphVertexId));
        }
        Iterable historicalPropertyValues = vertex.getHistoricalPropertyValues(startTime, endTime, authorizations);
        return ClientApiConverter.toClientApi((Iterable)historicalPropertyValues, (Locale)locale, (ResourceBundle)resourceBundle);
    }
}

