/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.user;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiUsers;
import org.visallo.web.clientapi.model.UserStatus;

public class UserList
implements ParameterizedHandler {
    private final UserRepository userRepository;
    private final WorkspaceRepository workspaceRepository;

    @Inject
    public UserList(UserRepository userRepository, WorkspaceRepository workspaceRepository) {
        this.userRepository = userRepository;
        this.workspaceRepository = workspaceRepository;
    }

    @Handle
    public ClientApiUsers handle(User user, @Optional(name="q") String query, @Optional(name="workspaceId") String workspaceId, @Optional(name="userIds[]") String[] userIds, @Optional(name="status") String status, @Optional(name="skip", defaultValue="0") int skip, @Optional(name="limit", defaultValue="100") int limit) throws Exception {
        List<Object> users;
        if (userIds != null) {
            Preconditions.checkArgument((query == null ? 1 : 0) != 0, (Object)"Cannot use userIds[] and q at the same time");
            Preconditions.checkArgument((workspaceId == null ? 1 : 0) != 0, (Object)"Cannot use userIds[] and workspaceId at the same time");
            users = new ArrayList<User>();
            for (String userId : userIds) {
                User u = this.userRepository.findById(userId);
                if (u == null) {
                    throw new VisalloResourceNotFoundException("User " + userId + " not found");
                }
                users.add(u);
            }
        } else if (status != null && status.length() > 0) {
            users = IterableUtils.toList((Iterable)this.userRepository.findByStatus(skip, limit, UserStatus.valueOf((String)status)));
        } else {
            users = IterableUtils.toList((Iterable)this.userRepository.find(query));
            if (workspaceId != null) {
                users = IterableUtils.toList(this.getUsersWithWorkspaceAccess(workspaceId, users, user));
            }
        }
        Iterable<String> workspaceIds = this.getCurrentWorkspaceIds((Iterable<User>)users);
        Map<String, String> workspaceNames = this.getWorkspaceNames(workspaceIds, user);
        return this.userRepository.toClientApi(users, workspaceNames);
    }

    private Map<String, String> getWorkspaceNames(Iterable<String> workspaceIds, User user) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Workspace workspace : this.workspaceRepository.findByIds(workspaceIds, user)) {
            if (workspace == null) continue;
            result.put(workspace.getWorkspaceId(), workspace.getDisplayTitle());
        }
        return result;
    }

    private Iterable<String> getCurrentWorkspaceIds(Iterable<User> users) {
        return new ConvertingIterable<User, String>(users){

            protected String convert(User user) {
                return user.getCurrentWorkspaceId();
            }
        };
    }

    private Iterable<User> getUsersWithWorkspaceAccess(String workspaceId, Iterable<User> users, User user) {
        final List usersWithAccess = this.workspaceRepository.findUsersWithAccess(workspaceId, user);
        return new FilterIterable<User>(users){

            protected boolean isIncluded(User u) {
                return this.contains(usersWithAccess, u);
            }

            private boolean contains(List<WorkspaceUser> usersWithAccess2, User u) {
                for (WorkspaceUser userWithAccess : usersWithAccess2) {
                    if (!userWithAccess.getUserId().equals(u.getUserId())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

