/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ping;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.ContentType;
import com.v5analytics.webster.annotations.Handle;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRepository;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.ping.PingUtil;
import org.visallo.web.parameterProviders.RemoteAddr;
import org.visallo.web.routes.ping.PingResponse;

public class Ping
implements ParameterizedHandler {
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final LongRunningProcessRepository longRunningProcessRepository;
    private final Authorizations authorizations;
    private final PingUtil pingUtil;

    @Inject
    public Ping(UserRepository userRepository, Graph graph, WorkQueueRepository workQueueRepository, LongRunningProcessRepository longRunningProcessRepository, PingUtil pingUtil, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.longRunningProcessRepository = longRunningProcessRepository;
        this.pingUtil = pingUtil;
        this.authorizations = authorizationRepository.getGraphAuthorizations(userRepository.getSystemUser(), new String[0]);
    }

    @Handle
    @ContentType(value="text/plain")
    public PingResponse ping(@RemoteAddr String remoteAddr) {
        long startTime = System.currentTimeMillis();
        String vertexId = this.pingUtil.search(this.graph, this.authorizations);
        long searchTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        this.pingUtil.retrieve(vertexId, this.graph, this.authorizations);
        long retrievalTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        Vertex pingVertex = this.pingUtil.createVertex(remoteAddr, searchTime, retrievalTime, this.graph, this.authorizations);
        long saveTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        this.pingUtil.enqueueToWorkQueue(pingVertex, this.workQueueRepository, Priority.HIGH);
        this.pingUtil.enqueueToLongRunningProcess(pingVertex, this.longRunningProcessRepository, this.authorizations);
        long enqueueTime = System.currentTimeMillis() - startTime;
        return new PingResponse(searchTime, retrievalTime, saveTime, enqueueTime);
    }
}

