/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.edge;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import java.util.ResourceBundle;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.BadRequestException;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class EdgeSetVisibility
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(EdgeSetVisibility.class);
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final WorkspaceRepository workspaceRepository;
    private final GraphRepository graphRepository;
    private final VisibilityTranslator visibilityTranslator;

    @Inject
    public EdgeSetVisibility(Graph graph, WorkQueueRepository workQueueRepository, WorkspaceRepository workspaceRepository, GraphRepository graphRepository, VisibilityTranslator visibilityTranslator) {
        this.graph = graph;
        this.workQueueRepository = workQueueRepository;
        this.workspaceRepository = workspaceRepository;
        this.graphRepository = graphRepository;
        this.visibilityTranslator = visibilityTranslator;
    }

    @Handle
    public ClientApiElement handle(@Required(name="graphEdgeId") String graphEdgeId, @Required(name="visibilitySource") String visibilitySource, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Edge graphEdge = this.graph.getEdge(graphEdgeId, authorizations);
        if (graphEdge == null) {
            throw new VisalloResourceNotFoundException("Could not find edge: " + graphEdgeId);
        }
        if (!this.graph.isVisibilityValid(this.visibilityTranslator.toVisibility(visibilitySource).getVisibility(), authorizations)) {
            LOGGER.warn("%s is not a valid visibility for %s user", new Object[]{visibilitySource, user.getDisplayName()});
            throw new BadRequestException("visibilitySource", resourceBundle.getString("visibility.invalid"));
        }
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, graphEdge.getVertexId(Direction.IN), null, null, user);
        this.workspaceRepository.updateEntityOnWorkspace(workspaceId, graphEdge.getVertexId(Direction.OUT), null, null, user);
        LOGGER.info("changing edge (%s) visibility source to %s", new Object[]{graphEdge.getId(), visibilitySource});
        this.graphRepository.updateElementVisibilitySource((Element)graphEdge, SandboxStatusUtil.getSandboxStatus((Element)graphEdge, (String)workspaceId), visibilitySource, workspaceId, authorizations);
        this.graph.flush();
        this.workQueueRepository.pushGraphPropertyQueue((Element)graphEdge, null, VisalloProperties.VISIBILITY_JSON.getPropertyName(), workspaceId, visibilitySource, Priority.HIGH);
        return ClientApiConverter.toClientApi((Element)graphEdge, (String)workspaceId, (Authorizations)authorizations);
    }
}

