/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.AuthenticationHandler;
import org.visallo.web.parameterProviders.RemoteAddr;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class RemoteAddrParameterProviderFactory
extends ParameterProviderFactory<String> {
    private final ParameterProvider<String> parameterProvider;

    @Inject
    public RemoteAddrParameterProviderFactory(UserRepository userRepository, Configuration configuration) {
        this.parameterProvider = new VisalloBaseParameterProvider<String>(userRepository, configuration){

            public String getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                return AuthenticationHandler.getRemoteAddr(request);
            }
        };
    }

    public boolean isHandled(Method handleMethod, Class<? extends String> parameterType, Annotation[] parameterAnnotations) {
        return RemoteAddrParameterProviderFactory.getRemoteAddrAnnotation(parameterAnnotations) != null;
    }

    public ParameterProvider<String> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        RemoteAddr remoteAddrAnnotation = RemoteAddrParameterProviderFactory.getRemoteAddrAnnotation(parameterAnnotations);
        Preconditions.checkNotNull((Object)remoteAddrAnnotation, (Object)("cannot find " + RemoteAddr.class.getName()));
        return this.parameterProvider;
    }

    private static RemoteAddr getRemoteAddrAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof RemoteAddr)) continue;
            return (RemoteAddr)annotation;
        }
        return null;
    }
}

