/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class ActiveWorkspaceIdParameterProviderFactory
extends ParameterProviderFactory<String> {
    private final ParameterProvider<String> requiredParameterProvider;
    private final ParameterProvider<String> notRequiredParameterProvider;

    @Inject
    public ActiveWorkspaceIdParameterProviderFactory(UserRepository userRepository, Configuration configuration) {
        this.requiredParameterProvider = new VisalloBaseParameterProvider<String>(userRepository, configuration){

            public String getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                return 1.getActiveWorkspaceId(request);
            }
        };
        this.notRequiredParameterProvider = new VisalloBaseParameterProvider<String>(userRepository, configuration){

            public String getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                return 2.getActiveWorkspaceIdOrDefault(request);
            }
        };
    }

    public boolean isHandled(Method handleMethod, Class<? extends String> parameterType, Annotation[] parameterAnnotations) {
        return ActiveWorkspaceIdParameterProviderFactory.getActiveWorkspaceIdAnnotation(parameterAnnotations) != null;
    }

    public ParameterProvider<String> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        ActiveWorkspaceId activeWorkspaceIdAnnotation = ActiveWorkspaceIdParameterProviderFactory.getActiveWorkspaceIdAnnotation(parameterAnnotations);
        Preconditions.checkNotNull((Object)activeWorkspaceIdAnnotation, (Object)("cannot find " + ActiveWorkspaceId.class.getName()));
        if (activeWorkspaceIdAnnotation.required()) {
            return this.requiredParameterProvider;
        }
        return this.notRequiredParameterProvider;
    }

    private static ActiveWorkspaceId getActiveWorkspaceIdAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ActiveWorkspaceId)) continue;
            return (ActiveWorkspaceId)annotation;
        }
        return null;
    }
}

