/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.artifactThumbnails.ArtifactThumbnailRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.properties.types.MetadataVisalloProperty;
import org.visallo.core.model.properties.types.VisalloPropertyBase;

public class WebConfiguration {
    public static final String PREFIX = "web.ui.";
    public static final String THROTTLE_MESSAGING_SECONDS = "web.ui.throttle.messaging.seconds";
    public static final String CACHE_VERTEX_LRU_EXPIRATION_SECONDS = "web.ui.cache.vertex.lru.expiration.seconds";
    public static final String CACHE_VERTEX_MAX_SIZE = "web.ui.cache.vertex.max_size";
    public static final String CACHE_EDGE_LRU_EXPIRATION_SECONDS = "web.ui.cache.edge.lru.expiration.seconds";
    public static final String CACHE_EDGE_MAX_SIZE = "web.ui.cache.edge.max_size";
    public static final String VERTEX_LOAD_RELATED_MAX_BEFORE_PROMPT = "web.ui.vertex.loadRelatedMaxBeforePrompt";
    public static final String VERTEX_LOAD_RELATED_MAX_FORCE_SEARCH = "web.ui.vertex.loadRelatedMaxForceSearch";
    public static final String VERTEX_RELATIONSHIPS_MAX_PER_SECTION = "web.ui.vertex.relationships.maxPerSection";
    public static final String DETAIL_HISTORY_STACK_MAX = "web.ui.detail.history.stack.max";
    public static final String VIDEO_PREVIEW_FRAMES_COUNT = "web.ui.video.preview.frames.count";
    public static final String FIELD_JUSTIFICATION_VALIDATION = "web.ui.field.justification.validation";
    public static final String SEARCH_DISABLE_WILDCARD_SEARCH = "web.ui.search.disableWildcardSearch";
    public static final String NOTIFICATIONS_LOCAL_AUTO_DISMISS_SECONDS = "web.ui.notifications.local.autoDismissSeconds";
    public static final String NOTIFICATIONS_SYSTEM_AUTO_DISMISS_SECONDS = "web.ui.notifications.system.autoDismissSeconds";
    public static final String NOTIFICATIONS_USER_AUTO_DISMISS_SECONDS = "web.ui.notifications.user.autoDismissSeconds";
    public static final String TYPEAHEAD_PROPERTIES_MAX_ITEMS = "web.ui.typeahead.properties.maxItems";
    public static final String TYPEAHEAD_CONCEPTS_MAX_ITEMS = "web.ui.typeahead.concepts.maxItems";
    public static final String TYPEAHEAD_EDGE_LABELS_MAX_ITEMS = "web.ui.typeahead.edgeLabels.maxItems";
    public static final String PROPERTIES_MULTIVALUE_DEFAULT_VISIBLE_COUNT = "web.ui.properties.multivalue.defaultVisibleCount";
    public static final String PROPERTIES_METADATA_PROPERTY_NAMES = "web.ui.properties.metadata.propertyNames";
    public static final String PROPERTIES_METADATA_PROPERTY_NAMES_DISPLAY = "web.ui.properties.metadata.propertyNamesDisplay";
    public static final String PROPERTIES_METADATA_PROPERTY_NAMES_TYPE = "web.ui.properties.metadata.propertyNamesType";
    public static final String MAP_PROVIDER = "web.ui.map.provider";
    public static final String MAP_PROVIDER_OSM_URL = "web.ui.map.provider.osm.url";
    public static final String LOGIN_SHOW_POWERED_BY = "web.ui.login.showPoweredBy";
    public static final String SHOW_VERSION_COMMENTS = "web.ui.showVersionComments";
    public static final PropertyMetadata PROPERTY_METADATA_SOURCE_TIMEZONE = new PropertyMetadata("http://visallo.org#sourceTimezone", "properties.metadata.label.source_timezone", "timezone");
    public static final PropertyMetadata PROPERTY_METADATA_MODIFIED_DATE = new PropertyMetadata((VisalloPropertyBase)VisalloProperties.MODIFIED_DATE, "properties.metadata.label.modified_date", "datetime");
    public static final PropertyMetadata PROPERTY_METADATA_MODIFIED_BY = new PropertyMetadata((VisalloPropertyBase)VisalloProperties.MODIFIED_BY, "properties.metadata.label.modified_by", "user");
    public static final PropertyMetadata PROPERTY_METADATA_STATUS = new PropertyMetadata("sandboxStatus", "properties.metadata.label.status", "sandboxStatus");
    public static final PropertyMetadata PROPERTY_METADATA_CONFIDENCE = new PropertyMetadata((MetadataVisalloProperty)VisalloProperties.CONFIDENCE_METADATA, "properties.metadata.label.confidence", "percent");
    public static final Map<String, String> DEFAULTS = new HashMap<String, String>();

    public static JustificationFieldValidation getJustificationFieldValidation(Configuration configuration) {
        return JustificationFieldValidation.valueOf(configuration.get(FIELD_JUSTIFICATION_VALIDATION, DEFAULTS.get(FIELD_JUSTIFICATION_VALIDATION)));
    }

    public static boolean justificationRequired(Configuration configuration) {
        return WebConfiguration.getJustificationFieldValidation(configuration).equals((Object)JustificationFieldValidation.REQUIRED);
    }

    static {
        DEFAULTS.put(LOGIN_SHOW_POWERED_BY, "false");
        DEFAULTS.put(SHOW_VERSION_COMMENTS, "true");
        DEFAULTS.put(THROTTLE_MESSAGING_SECONDS, "2");
        DEFAULTS.put(CACHE_VERTEX_LRU_EXPIRATION_SECONDS, Integer.toString(600));
        DEFAULTS.put(CACHE_VERTEX_MAX_SIZE, "500");
        DEFAULTS.put(CACHE_EDGE_LRU_EXPIRATION_SECONDS, Integer.toString(600));
        DEFAULTS.put(CACHE_EDGE_MAX_SIZE, "250");
        DEFAULTS.put(VERTEX_LOAD_RELATED_MAX_BEFORE_PROMPT, "50");
        DEFAULTS.put(VERTEX_LOAD_RELATED_MAX_FORCE_SEARCH, "250");
        DEFAULTS.put(VERTEX_RELATIONSHIPS_MAX_PER_SECTION, "5");
        DEFAULTS.put(DETAIL_HISTORY_STACK_MAX, "5");
        DEFAULTS.put(VIDEO_PREVIEW_FRAMES_COUNT, Integer.toString(ArtifactThumbnailRepository.FRAMES_PER_PREVIEW));
        DEFAULTS.put(FIELD_JUSTIFICATION_VALIDATION, JustificationFieldValidation.OPTIONAL.toString());
        DEFAULTS.put(SEARCH_DISABLE_WILDCARD_SEARCH, "false");
        DEFAULTS.put(NOTIFICATIONS_LOCAL_AUTO_DISMISS_SECONDS, "2");
        DEFAULTS.put(NOTIFICATIONS_SYSTEM_AUTO_DISMISS_SECONDS, "-1");
        DEFAULTS.put(NOTIFICATIONS_USER_AUTO_DISMISS_SECONDS, "5");
        DEFAULTS.put(TYPEAHEAD_CONCEPTS_MAX_ITEMS, "-1");
        DEFAULTS.put(TYPEAHEAD_PROPERTIES_MAX_ITEMS, "-1");
        DEFAULTS.put(TYPEAHEAD_EDGE_LABELS_MAX_ITEMS, "-1");
        DEFAULTS.put(PROPERTIES_MULTIVALUE_DEFAULT_VISIBLE_COUNT, "2");
        DEFAULTS.put(PROPERTIES_METADATA_PROPERTY_NAMES, Joiner.on((char)',').join((Object)PROPERTY_METADATA_SOURCE_TIMEZONE.getName(), (Object)PROPERTY_METADATA_MODIFIED_DATE.getName(), new Object[]{PROPERTY_METADATA_MODIFIED_BY.getName(), PROPERTY_METADATA_STATUS.getName(), PROPERTY_METADATA_CONFIDENCE.getName()}));
        DEFAULTS.put(PROPERTIES_METADATA_PROPERTY_NAMES_DISPLAY, Joiner.on((char)',').join((Object)PROPERTY_METADATA_SOURCE_TIMEZONE.getMessageKey(), (Object)PROPERTY_METADATA_MODIFIED_DATE.getMessageKey(), new Object[]{PROPERTY_METADATA_MODIFIED_BY.getMessageKey(), PROPERTY_METADATA_STATUS.getMessageKey(), PROPERTY_METADATA_CONFIDENCE.getMessageKey()}));
        DEFAULTS.put(PROPERTIES_METADATA_PROPERTY_NAMES_TYPE, Joiner.on((char)',').join((Object)PROPERTY_METADATA_SOURCE_TIMEZONE.getDataType(), (Object)PROPERTY_METADATA_MODIFIED_DATE.getDataType(), new Object[]{PROPERTY_METADATA_MODIFIED_BY.getDataType(), PROPERTY_METADATA_STATUS.getDataType(), PROPERTY_METADATA_CONFIDENCE.getDataType()}));
        DEFAULTS.put(MAP_PROVIDER, MapProvider.GOOGLE.toString());
        DEFAULTS.put(MAP_PROVIDER_OSM_URL, "https://a.tile.openstreetmap.org/${z}/${x}/${y}.png,https://b.tile.openstreetmap.org/${z}/${x}/${y}.png,https://c.tile.openstreetmap.org/${z}/${x}/${y}.png");
    }

    public static enum JustificationFieldValidation {
        REQUIRED,
        OPTIONAL,
        NONE;

    }

    public static enum MapProvider {
        GOOGLE("google"),
        OSM("osm"),
        ARCGIS93REST("ArcGIS93Rest");

        private String string;

        private MapProvider(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static class PropertyMetadata {
        private String name;
        private String messageKey;
        private String dataType;

        public PropertyMetadata(VisalloPropertyBase visalloProperty, String messageKey, String dataType) {
            this(visalloProperty.getPropertyName(), messageKey, dataType);
        }

        public PropertyMetadata(MetadataVisalloProperty visalloProperty, String messageKey, String dataType) {
            this(visalloProperty.getMetadataKey(), messageKey, dataType);
        }

        public PropertyMetadata(String name, String messageKey, String dataType) {
            this.name = name;
            this.messageKey = messageKey;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public String getDataType() {
            return this.dataType;
        }
    }
}

