/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.inject.Injector;
import com.v5analytics.webster.App;
import com.v5analytics.webster.DefaultParameterValueConverter;
import com.v5analytics.webster.Handler;
import com.v5analytics.webster.handlers.StaticResourceHandler;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import com.v5analytics.webster.resultWriters.ResultWriterFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.vertexium.util.CloseableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.config.VisalloResourceBundleManager;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.notification.SystemNotificationSeverity;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.JavascriptResourceHandler;
import org.visallo.web.JsxResourceHandler;
import org.visallo.web.LessResourceHandler;
import org.visallo.web.StyleAppendableHandler;
import org.visallo.web.VisalloDefaultResultWriterFactory;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.parameterProviders.ActiveWorkspaceIdParameterProviderFactory;
import org.visallo.web.parameterProviders.AuthorizationsParameterProviderFactory;
import org.visallo.web.parameterProviders.BaseUrlParameterProviderFactory;
import org.visallo.web.parameterProviders.ClientApiObjectArrayParameterValueConverter;
import org.visallo.web.parameterProviders.ClientApiObjectParameterValueConverter;
import org.visallo.web.parameterProviders.ClientApiSourceInfoParameterProviderFactory;
import org.visallo.web.parameterProviders.FormulaEvaluatorUserContextParameterProviderFactory;
import org.visallo.web.parameterProviders.JustificationTextParameterProviderFactory;
import org.visallo.web.parameterProviders.LocaleParameterProviderFactory;
import org.visallo.web.parameterProviders.RemoteAddrParameterProviderFactory;
import org.visallo.web.parameterProviders.ResourceBundleParameterProviderFactory;
import org.visallo.web.parameterProviders.SourceGuidParameterProviderFactory;
import org.visallo.web.parameterProviders.TimeZoneParameterProviderFactory;
import org.visallo.web.parameterProviders.UserParameterProviderFactory;
import org.visallo.web.parameterProviders.VisalloResponseParameterProviderFactory;
import org.visallo.web.parameterProviders.WebAppParameterProviderFactory;
import org.visallo.web.parameterValueConverters.JSONObjectParameterValueConverter;
import org.visallo.web.routes.notification.SystemNotificationSeverityValueConverter;
import org.visallo.web.util.js.SourceMapType;

public class WebApp
extends App {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WebApp.class);
    private final Injector injector;
    private final boolean devMode;
    private final boolean pluginDevMode;
    private final List<String> pluginsJsResourcesWebWorker = new ArrayList<String>();
    private final List<String> pluginsJsResourcesBeforeAuth = new ArrayList<String>();
    private final List<String> pluginsJsResourcesAfterAuth = new ArrayList<String>();
    private final StyleAppendableHandler pluginsCssResourceHandler = new StyleAppendableHandler();
    private final List<String> pluginsCssResources = new ArrayList<String>();
    private VisalloResourceBundleManager visalloResourceBundleManager = new VisalloResourceBundleManager();
    private VisalloDefaultResultWriterFactory visalloDefaultResultWriterFactory;

    public WebApp(ServletContext servletContext, Injector injector) {
        super(servletContext);
        this.injector = injector;
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(ActiveWorkspaceIdParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(JustificationTextParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(BaseUrlParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(AuthorizationsParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(TimeZoneParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(SourceGuidParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(LocaleParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(VisalloResponseParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(UserParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(FormulaEvaluatorUserContextParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(ResourceBundleParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(ClientApiSourceInfoParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(WebAppParameterProviderFactory.class)));
        App.registeredParameterProviderFactory((ParameterProviderFactory)((ParameterProviderFactory)injector.getInstance(RemoteAddrParameterProviderFactory.class)));
        App.registerParameterValueConverter(ClientApiObject.class, (DefaultParameterValueConverter.Converter)new ClientApiObjectParameterValueConverter());
        App.registerParameterValueConverter(ClientApiObject[].class, (DefaultParameterValueConverter.Converter)new ClientApiObjectArrayParameterValueConverter());
        App.registerParameterValueConverter(SystemNotificationSeverity.class, (DefaultParameterValueConverter.Converter)new SystemNotificationSeverityValueConverter());
        App.registerParameterValueConverter(JSONObject.class, (DefaultParameterValueConverter.Converter)new JSONObjectParameterValueConverter());
        this.visalloDefaultResultWriterFactory = (VisalloDefaultResultWriterFactory)InjectHelper.getInstance(VisalloDefaultResultWriterFactory.class);
        Configuration config = (Configuration)injector.getInstance(Configuration.class);
        this.devMode = config.getBoolean("devMode", false);
        this.pluginDevMode = config.getBoolean("pluginDevMode", false);
        if (!this.isDevModeEnabled()) {
            String pluginsCssRoute = "plugins.css";
            this.get("/" + pluginsCssRoute, new Handler[]{this.pluginsCssResourceHandler});
            this.pluginsCssResources.add(pluginsCssRoute);
        }
    }

    protected ResultWriterFactory getResultWriterFactory(Method handleMethod) {
        return this.visalloDefaultResultWriterFactory;
    }

    protected Handler[] instantiateHandlers(Class<? extends Handler>[] handlerClasses) throws Exception {
        Handler[] handlers = new Handler[handlerClasses.length];
        for (int i = 0; i < handlerClasses.length; ++i) {
            handlers[i] = (Handler)this.injector.getInstance(handlerClasses[i]);
        }
        return handlers;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getRequestURI().endsWith("ejs")) {
            response.setContentType("text/plain");
        }
        response.setCharacterEncoding("UTF-8");
        super.handle(request, response);
    }

    private void register(String name, String type, String pathPrefix, Boolean includeInPage, String closureExternResourcePath) {
        this.register(name, type, pathPrefix, includeInPage, closureExternResourcePath, this.pluginsJsResourcesAfterAuth, false);
    }

    private void register(String name, String type, String pathPrefix, boolean includeInPage, String closureExternResourcePath, List<String> resourceList, boolean skipCompile) {
        String resourcePath = "/" + (pathPrefix + name).replaceAll("^/", "");
        if (type.equals("application/javascript") && !this.pluginDevMode && !skipCompile) {
            boolean enableSourceMaps = this.isDevModeEnabled();
            JavascriptResourceHandler handler = new JavascriptResourceHandler(name, resourcePath, enableSourceMaps, closureExternResourcePath);
            this.get(resourcePath, new Handler[]{handler});
            if (enableSourceMaps) {
                this.get(resourcePath + ".map", new Handler[]{handler});
                this.get(resourcePath + ".src", new Handler[]{handler});
            }
        } else {
            this.get(resourcePath, new Handler[]{new StaticResourceHandler(((Object)((Object)this)).getClass(), name, type)});
        }
        if (includeInPage) {
            resourceList.add(resourcePath);
        }
    }

    public void registerJavaScript(String scriptResourceName, Boolean includeInPage, String closureExternResourcePath) {
        this.register(scriptResourceName, "application/javascript", "jsc", includeInPage, closureExternResourcePath);
    }

    public void registerJavaScript(String scriptResourceName, Boolean includeInPage) {
        this.register(scriptResourceName, "application/javascript", "jsc", includeInPage, null);
    }

    public void registerJavaScript(JavaScriptResource javaScriptResource) {
        this.register(javaScriptResource.getResourcePath(), "application/javascript", "jsc", javaScriptResource.isIncludeInPage(), null, this.pluginsJsResourcesAfterAuth, javaScriptResource.isSkipCompile());
    }

    public void registerJavaScript(String scriptResourceName) {
        this.registerJavaScript(scriptResourceName, true);
    }

    public void registerJavaScriptComponent(String scriptResourceName) {
        if (scriptResourceName.endsWith("jsx")) {
            String resourcePath = "/" + ("jsc" + scriptResourceName).replaceAll("^/", "");
            String toResourcePath = resourcePath.replaceAll("jsx$", "js");
            SourceMapType map = this.pluginDevMode ? SourceMapType.INLINE : SourceMapType.EXTERNAL;
            JsxResourceHandler handler = new JsxResourceHandler(scriptResourceName, resourcePath, toResourcePath, map);
            this.get(toResourcePath, new Handler[]{handler});
            if (map == SourceMapType.EXTERNAL) {
                this.get(toResourcePath + ".map", new Handler[]{handler});
                this.get(toResourcePath + ".src", new Handler[]{handler});
            }
        } else {
            throw new VisalloException("JavaScript components must be .jsx");
        }
    }

    public void registerWebWorkerJavaScript(String scriptResourceName, String closureExternResourcePath) {
        this.register(scriptResourceName, "application/javascript", "jsc", true, closureExternResourcePath, this.pluginsJsResourcesWebWorker, false);
    }

    public void registerWebWorkerJavaScript(String scriptResourceName) {
        this.registerWebWorkerJavaScript(scriptResourceName, null);
    }

    public void registerBeforeAuthenticationJavaScript(String scriptResourceName) {
        this.register(scriptResourceName, "application/javascript", "jsc", true, null, this.pluginsJsResourcesBeforeAuth, false);
    }

    public void registerJavaScriptTemplate(String scriptResourceName) {
        this.register(scriptResourceName, "text/plain", "jsc", false, null);
    }

    public void registerFile(String resourceName, String mimeType) {
        this.register(resourceName, mimeType, "", false, null);
    }

    public void registerCss(String cssResourceName) {
        String resourcePath = "css" + cssResourceName;
        if (this.isDevModeEnabled()) {
            this.get("/" + resourcePath, new Handler[]{new StaticResourceHandler(((Object)((Object)this)).getClass(), cssResourceName, "text/css")});
            this.pluginsCssResources.add(resourcePath);
        } else {
            this.pluginsCssResourceHandler.appendCssResource(cssResourceName);
        }
    }

    public void registerLess(String lessResourceName) {
        String resourcePath = "css" + lessResourceName + ".css";
        if (this.isDevModeEnabled()) {
            this.get("/" + resourcePath, new Handler[]{new LessResourceHandler(lessResourceName)});
            this.pluginsCssResources.add(resourcePath);
        } else {
            this.pluginsCssResourceHandler.appendLessResource(lessResourceName);
        }
    }

    public static Locale getLocal(String language, String country, String variant) {
        if (language != null) {
            if (country != null) {
                if (variant != null) {
                    return new Locale(language, country, variant);
                }
                return new Locale(language, country);
            }
            return new Locale(language);
        }
        return Locale.getDefault();
    }

    public void registerResourceBundle(String resourceBundleResourceName) {
        InputStream stream = WebApp.class.getResourceAsStream(resourceBundleResourceName);
        if (stream == null) {
            throw new VisalloException("Could not find resource bundle resource: " + resourceBundleResourceName);
        }
        try {
            Pattern pattern = Pattern.compile(".*_([a-z]{2})(?:_([A-Z]{2}))?(?:_(.+))?\\.properties");
            Matcher matcher = pattern.matcher(resourceBundleResourceName);
            if (matcher.matches()) {
                String language = matcher.group(1);
                String country = matcher.group(2);
                String variant = matcher.group(3);
                Locale locale = WebApp.getLocal(language, country, variant);
                LOGGER.info("registering ResourceBundle plugin file: %s with locale: %s", new Object[]{resourceBundleResourceName, locale});
                this.visalloResourceBundleManager.register(stream, locale);
            } else {
                LOGGER.info("registering ResourceBundle plugin file: %s", new Object[]{resourceBundleResourceName});
                this.visalloResourceBundleManager.register(stream);
            }
        }
        catch (IOException e) {
            throw new VisalloException("Could not read resource bundle resource: " + resourceBundleResourceName);
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)stream);
        }
    }

    public ResourceBundle getBundle(Locale locale) {
        return this.visalloResourceBundleManager.getBundle(locale);
    }

    public List<String> getPluginsJsResourcesBeforeAuth() {
        return this.pluginsJsResourcesBeforeAuth;
    }

    public List<String> getPluginsJsResourcesWebWorker() {
        return this.pluginsJsResourcesWebWorker;
    }

    public List<String> getPluginsJsResourcesAfterAuth() {
        return this.pluginsJsResourcesAfterAuth;
    }

    public List<String> getPluginsCssResources() {
        return this.pluginsCssResources;
    }

    public boolean isDevModeEnabled() {
        return this.devMode;
    }

    public static class JavaScriptResource {
        private final String resourcePath;
        private boolean includeInPage = true;
        private boolean skipCompile = false;

        public JavaScriptResource(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public JavaScriptResource includeInPage(boolean includeInPage) {
            this.includeInPage = includeInPage;
            return this;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public boolean isIncludeInPage() {
            return this.includeInPage;
        }

        public boolean isSkipCompile() {
            return this.skipCompile;
        }

        public JavaScriptResource skipCompile(boolean skipCompile) {
            this.skipCompile = skipCompile;
            return this;
        }
    }
}

