/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.HttpConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.bootstrap.VisalloBootstrap;
import org.visallo.core.config.Configuration;
import org.visallo.core.config.ConfigurationLoader;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.ApplicationGzipFilter;
import org.visallo.web.CacheServletFilter;
import org.visallo.web.Messaging;
import org.visallo.web.MessagingFilter;
import org.visallo.web.MessagingThrottleFilter;
import org.visallo.web.RequestDebugFilter;
import org.visallo.web.Router;
import org.visallo.web.WebConfiguration;
import org.visallo.web.initializers.ApplicationBootstrapInitializer;

public class ApplicationBootstrap
implements ServletContextListener {
    private static VisalloLogger LOGGER;
    public static final String CONFIG_HTTP_TRANSPORT_GUARANTEE = "http.transportGuarantee";
    public static final String APP_CONFIG_LOADER = "application.config.loader";
    public static final String ORG_ECLIPSE_JETTY_SERVLET_DEFAULT_DIR_ALLOWED = "org.eclipse.jetty.servlet.Default.dirAllowed";
    public static final String VISALLO_SERVLET_NAME = "visallo";
    public static final String ATMOSPHERE_SERVLET_NAME = "atmosphere";
    public static final String DEBUG_FILTER_NAME = "debug";
    public static final String CACHE_FILTER_NAME = "cache";
    public static final String GZIP_FILTER_NAME = "gzip";
    private volatile boolean isStopped = false;
    private Configuration config;
    private List<ApplicationBootstrapInitializer> applicationBootstrapInitializers = new ArrayList<ApplicationBootstrapInitializer>();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            if (context == null) {
                throw new RuntimeException("Failed to initialize context. Visallo is not running.");
            }
            VisalloLoggerFactory.setProcessType((String)"web");
            HashMap<String, String> initParameters = new HashMap<String, String>(this.getInitParametersAsMap(context));
            initParameters.putAll(WebConfiguration.DEFAULTS);
            this.config = ConfigurationLoader.load((String)context.getInitParameter(APP_CONFIG_LOADER), initParameters);
            LOGGER = VisalloLoggerFactory.getLogger(ApplicationBootstrap.class);
            LOGGER.info("Running application with configuration:\n%s", new Object[]{this.config});
            this.setupInjector(context, this.config);
            this.verifyGraphVersion();
            this.setupGraphAuthorizations();
            Iterable initializers = ServiceLoaderUtil.load(ApplicationBootstrapInitializer.class, (Configuration)this.config);
            for (ApplicationBootstrapInitializer initializer : initializers) {
                initializer.initialize(context);
                this.applicationBootstrapInitializers.add(initializer);
            }
            this.setupWebApp(context, this.config);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ApplicationBootstrap.this.contextDestroyed(null);
                }
            });
        }
        catch (Throwable ex) {
            if (LOGGER != null) {
                LOGGER.error("Could not startup context", ex);
            }
            throw new VisalloException("Could not startup context", ex);
        }
    }

    private void verifyGraphVersion() {
        GraphRepository graphRepository = (GraphRepository)InjectHelper.getInstance(GraphRepository.class);
        graphRepository.verifyVersion();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        ((ShutdownService)InjectHelper.getInstance(ShutdownService.class)).shutdown();
    }

    private void setupInjector(ServletContext context, Configuration config) {
        LOGGER.debug("setupInjector", new Object[0]);
        InjectHelper.inject((Object)this, (InjectHelper.ModuleMaker)VisalloBootstrap.bootstrapModuleMaker((Configuration)config), (Configuration)config);
        context.setAttribute(Injector.class.getName(), (Object)InjectHelper.getInjector());
        InjectHelper.getInstance(OntologyRepository.class);
    }

    private void setupGraphAuthorizations() {
        LOGGER.debug("setupGraphAuthorizations", new Object[0]);
        GraphAuthorizationRepository graphAuthorizationRepository = (GraphAuthorizationRepository)InjectHelper.getInstance(GraphAuthorizationRepository.class);
        graphAuthorizationRepository.addAuthorizationToGraph(new String[]{VISALLO_SERVLET_NAME, "user", "termMention", "longRunningProcess", "ontology", "workspace", "videoFrame"});
    }

    private void setupWebApp(ServletContext context, Configuration config) {
        LOGGER.debug("setupWebApp", new Object[0]);
        Router router = new Router(context);
        ServletRegistration.Dynamic servlet = context.addServlet(VISALLO_SERVLET_NAME, (Servlet)router);
        servlet.addMapping(new String[]{"/*"});
        servlet.setAsyncSupported(true);
        servlet.setInitParameter(ORG_ECLIPSE_JETTY_SERVLET_DEFAULT_DIR_ALLOWED, "false");
        this.addSecurityConstraint(servlet, config);
        this.addAtmosphereServlet(context, config);
        this.addDebugFilter(context);
        this.addCacheFilter(context);
        if (this.shouldAddGzipFilter(context, config)) {
            this.addGzipFilter(context);
        }
        LOGGER.info("JavaScript / Less modifications will not be reflected on server. Run `grunt` from webapp directory in development", new Object[0]);
    }

    private void addAtmosphereServlet(ServletContext context, Configuration config) {
        ServletRegistration.Dynamic servlet = context.addServlet(ATMOSPHERE_SERVLET_NAME, AtmosphereServlet.class);
        context.addListener(SessionSupport.class);
        servlet.addMapping(new String[]{"/messaging/*"});
        servlet.setAsyncSupported(true);
        servlet.setLoadOnStartup(0);
        servlet.setInitParameter(AtmosphereHandler.class.getName(), Messaging.class.getName());
        servlet.setInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        servlet.setInitParameter("org.atmosphere.cpr.broadcastFilterClasses", MessagingFilter.class.getName() + "," + MessagingThrottleFilter.class.getName());
        servlet.setInitParameter(AtmosphereInterceptor.class.getName(), HeartbeatInterceptor.class.getName());
        servlet.setInitParameter("org.atmosphere.interceptor.HeartbeatInterceptor.heartbeatFrequencyInSeconds", "30");
        servlet.setInitParameter("org.atmosphere.cpr.CometSupport.maxInactiveActivity", "-1");
        servlet.setInitParameter("org.atmosphere.cpr.broadcasterCacheClass", UUIDBroadcasterCache.class.getName());
        servlet.setInitParameter("org.atmosphere.cpr.dropAccessControlAllowOriginHeader", "true");
        servlet.setInitParameter("org.atmosphere.websocket.maxTextMessageSize", "1048576");
        servlet.setInitParameter("org.atmosphere.websocket.maxBinaryMessageSize", "1048576");
        this.addSecurityConstraint(servlet, config);
    }

    private void addDebugFilter(ServletContext context) {
        FilterRegistration.Dynamic filter = context.addFilter(DEBUG_FILTER_NAME, RequestDebugFilter.class);
        filter.setAsyncSupported(true);
        filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
    }

    private void addCacheFilter(ServletContext context) {
        String[] mappings;
        FilterRegistration.Dynamic filter = context.addFilter(CACHE_FILTER_NAME, CacheServletFilter.class);
        filter.setAsyncSupported(true);
        for (String mapping : mappings = new String[]{"/", "*.html", "*.css", "*.js", "*.ejs", "*.less", "*.hbs", "*.map"}) {
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{mapping});
        }
    }

    private boolean shouldAddGzipFilter(ServletContext context, Configuration config) {
        return config.getBoolean("http.gzipEnabled", this.getGzipEnabledDefault(context));
    }

    private boolean getGzipEnabledDefault(ServletContext context) {
        return this.isJetty(context);
    }

    private boolean isJetty(ServletContext context) {
        return context.getServerInfo() != null && context.getServerInfo().toLowerCase().contains("jetty");
    }

    private void addGzipFilter(ServletContext context) {
        String[] mappings;
        FilterRegistration.Dynamic filter = context.addFilter(GZIP_FILTER_NAME, ApplicationGzipFilter.class);
        filter.setInitParameter("mimeTypes", "application/json,text/html,text/plain,text/xml,application/xhtml+xml,text/css,application/javascript,image/svg+xml");
        filter.setAsyncSupported(true);
        for (String mapping : mappings = new String[]{"/*"}) {
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{mapping});
        }
    }

    private void addSecurityConstraint(ServletRegistration.Dynamic servletRegistration, Configuration config) {
        ServletSecurity.TransportGuarantee transportGuarantee = ServletSecurity.TransportGuarantee.CONFIDENTIAL;
        String constraintType = config.get(CONFIG_HTTP_TRANSPORT_GUARANTEE, null);
        if (constraintType != null) {
            transportGuarantee = ServletSecurity.TransportGuarantee.valueOf((String)constraintType);
        }
        HttpConstraintElement httpConstraintElement = new HttpConstraintElement(transportGuarantee, new String[0]);
        ServletSecurityElement securityElement = new ServletSecurityElement(httpConstraintElement);
        servletRegistration.setServletSecurity(securityElement);
    }

    private Map<String, String> getInitParametersAsMap(ServletContext context) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParameterName = (String)e.nextElement();
            initParameters.put(initParameterName, context.getInitParameter(initParameterName));
        }
        return initParameters;
    }
}

