/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.webflow.view;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.webflow.context.servlet.AjaxHandler;
import org.springframework.webflow.context.servlet.DefaultAjaxHandler;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.spring6.webflow.view.AjaxEnabledView;

public class AjaxThymeleafViewResolver
extends ThymeleafViewResolver {
    private static final Logger vrlogger = LoggerFactory.getLogger(AjaxThymeleafViewResolver.class);
    private AjaxHandler ajaxHandler = new DefaultAjaxHandler();

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    @Override
    protected View createView(String viewName, Locale locale) throws Exception {
        AjaxEnabledView ajaxEnabledView;
        if (!this.canHandle(viewName, locale)) {
            return null;
        }
        if (this.ajaxHandler == null) {
            throw new ConfigurationException("[THYMELEAF] AJAX Handler set into " + AjaxThymeleafViewResolver.class.getSimpleName() + " instance is null.");
        }
        if (viewName.startsWith("redirect:")) {
            vrlogger.trace("[THYMELEAF] View {} is a redirect. An AJAX-enabled RedirectView implementation will be handling the request.", (Object)viewName);
            String redirectUrl = viewName.substring("redirect:".length());
            return new AjaxRedirectView(this.ajaxHandler, redirectUrl, this.isRedirectContextRelative(), this.isRedirectHttp10Compatible());
        }
        View view = super.createView(viewName, locale);
        if (view instanceof AjaxEnabledView && (ajaxEnabledView = (AjaxEnabledView)view).getAjaxHandler() == null && this.getAjaxHandler() != null) {
            ajaxEnabledView.setAjaxHandler(this.getAjaxHandler());
        }
        return view;
    }

    private static class AjaxRedirectView
    extends RedirectView {
        private static final Logger vlogger = LoggerFactory.getLogger(AjaxRedirectView.class);
        private AjaxHandler ajaxHandler = new DefaultAjaxHandler();

        AjaxRedirectView(AjaxHandler ajaxHandler, String redirectUrl, boolean redirectContextRelative, boolean redirectHttp10Compatible) {
            super(redirectUrl, redirectContextRelative, redirectHttp10Compatible);
            this.ajaxHandler = ajaxHandler;
        }

        protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String targetUrl, boolean http10Compatible) throws IOException {
            if (this.ajaxHandler == null) {
                throw new ConfigurationException("[THYMELEAF] AJAX Handler set into " + AjaxThymeleafViewResolver.class.getSimpleName() + " instance is null.");
            }
            if (this.ajaxHandler.isAjaxRequest(request, response)) {
                if (vlogger.isTraceEnabled()) {
                    vlogger.trace("[THYMELEAF] RedirectView for URL \"{}\" is an AJAX request. AjaxHandler of class {} will be in charge of processing the request.", (Object)targetUrl, (Object)this.ajaxHandler.getClass().getName());
                }
                this.ajaxHandler.sendAjaxRedirect(targetUrl, request, response, false);
            } else {
                vlogger.trace("[THYMELEAF] RedirectView for URL \"{}\" is not an AJAX request. Request will be handled as a normal redirect", (Object)targetUrl);
                super.sendRedirect(request, response, targetUrl, http10Compatible);
            }
        }
    }
}

