/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect.processor;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;

public class AuthorizeUrlAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    public static final int ATTR_PRECEDENCE = 300;
    public static final String ATTR_NAME = "authorize-url";

    public AuthorizeUrlAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            return false;
        }
        int spaceIndex = (attributeValue = attributeValue.trim()).indexOf(32);
        String url = (spaceIndex < 0 ? attributeValue : attributeValue.substring(spaceIndex + 1)).trim();
        String method = (spaceIndex < 0 ? "GET" : attributeValue.substring(0, spaceIndex)).trim();
        IContext context = arguments.getContext();
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + ". Spring Security integration can only be used in " + "web environements.");
        }
        IWebContext webContext = (IWebContext)context;
        HttpServletRequest request = webContext.getHttpServletRequest();
        ServletContext servletContext = webContext.getServletContext();
        Authentication authentication = AuthUtils.getAuthenticationObject();
        if (authentication == null) {
            return false;
        }
        return AuthUtils.authorizeUsingUrlCheck(url, method, authentication, request, servletContext);
    }
}

