/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.auth;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.extras.springsecurity3.auth.AuthUtils;
import org.thymeleaf.util.Validate;

public final class Authorization {
    private final IProcessingContext processingContext;
    private final Authentication authentication;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;

    public Authorization(IProcessingContext processingContext, Authentication authentication, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.processingContext = processingContext;
        this.authentication = authentication;
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
    }

    public IProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean expr(String expression) {
        return this.expression(expression);
    }

    public boolean expression(String expression) {
        Validate.notEmpty((String)expression, (String)"Access expression cannot be null");
        return AuthUtils.authorizeUsingAccessExpression(this.processingContext, expression, this.authentication, this.request, this.response, this.servletContext);
    }

    public boolean url(String url) {
        return this.url("GET", url);
    }

    public boolean url(String method, String url) {
        Validate.notEmpty((String)url, (String)"URL cannot be null");
        return AuthUtils.authorizeUsingUrlCheck(url, method, this.authentication, this.request, this.servletContext);
    }
}

