/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.authentication;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tachyon.security.User;
import tachyon.security.authentication.AuthenticationProvider;

public final class PlainSaslServer
implements SaslServer {
    private String mAuthorizationId;
    private boolean mCompleted = false;
    private CallbackHandler mHandler;

    PlainSaslServer(CallbackHandler handler) throws SaslException {
        this.mHandler = handler;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        Preconditions.checkState((!this.mCompleted ? 1 : 0) != 0, (Object)"PLAIN authentication has completed");
        Preconditions.checkArgument((response != null ? 1 : 0) != 0, (Object)"Received null response");
        try {
            String payload;
            try {
                payload = new String(response, "UTF-8");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Received corrupt response", e);
            }
            String[] parts = payload.split("\u0000", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid message format, parts must contain 3 items");
            }
            String authorizationId = parts[0];
            String authenticationId = parts[1];
            String passwd = parts[2];
            Preconditions.checkState((authenticationId != null && !authenticationId.isEmpty() ? 1 : 0) != 0, (Object)"No authentication identity provided");
            Preconditions.checkState((passwd != null && !passwd.isEmpty() ? 1 : 0) != 0, (Object)"No password provided");
            if (authorizationId == null || authorizationId.isEmpty()) {
                authorizationId = authenticationId;
            } else if (!authorizationId.equals(authenticationId)) {
                throw new UnsupportedOperationException("Impersonation is not supported now.");
            }
            NameCallback nameCallback = new NameCallback("User");
            nameCallback.setName(authenticationId);
            PasswordCallback passwordCallback = new PasswordCallback("Password", false);
            passwordCallback.setPassword(passwd.toCharArray());
            AuthorizeCallback authCallback = new AuthorizeCallback(authenticationId, authorizationId);
            Callback[] cbList = new Callback[]{nameCallback, passwordCallback, authCallback};
            this.mHandler.handle(cbList);
            if (!authCallback.isAuthorized()) {
                throw new SaslException("AuthorizeCallback authorized failure");
            }
            this.mAuthorizationId = authCallback.getAuthorizedID();
            AuthorizedClientUser.set(this.mAuthorizationId);
        }
        catch (Exception e) {
            throw new SaslException("Plain authentication failed: " + e.getMessage(), e);
        }
        this.mCompleted = true;
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.mCompleted;
    }

    @Override
    public String getAuthorizationID() {
        this.checkNotComplete();
        return this.mAuthorizationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        throw new UnsupportedOperationException("PLAIN doesn't support wrap or unwrap operation");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        throw new UnsupportedOperationException("PLAIN doesn't support wrap or unwrap operation");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.checkNotComplete();
        return "javax.security.sasl.qop".equals(propName) ? "auth" : null;
    }

    @Override
    public void dispose() {
        if (this.mCompleted) {
            AuthorizedClientUser.remove();
        }
        this.mCompleted = false;
        this.mHandler = null;
        this.mAuthorizationId = null;
    }

    private void checkNotComplete() {
        if (!this.mCompleted) {
            throw new IllegalStateException("PLAIN authentication not completed");
        }
    }

    public static final class AuthorizedClientUser {
        private static ThreadLocal<User> sUserThreadLocal = new ThreadLocal();

        public static void set(String userName) {
            sUserThreadLocal.set(new User(userName));
        }

        public static User get() {
            return sUserThreadLocal.get();
        }

        public static void remove() {
            sUserThreadLocal.remove();
        }
    }

    public static final class PlainServerCallbackHandler
    implements CallbackHandler {
        private final AuthenticationProvider mAuthenticationProvider;

        public PlainServerCallbackHandler(AuthenticationProvider authenticationProvider) {
            this.mAuthenticationProvider = authenticationProvider;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            String password = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    username = nc.getName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    password = new String(pc.getPassword());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unsupport callback");
            }
            this.mAuthenticationProvider.authenticate(username, password);
            if (ac != null) {
                ac.setAuthorized(true);
            }
        }
    }
}

