/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security;

import java.io.IOException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import tachyon.conf.TachyonConf;
import tachyon.security.User;
import tachyon.security.authentication.AuthType;
import tachyon.security.login.TachyonJaasConfiguration;

public final class LoginUser {
    private static User sLoginUser;

    private LoginUser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static User get(TachyonConf conf) throws IOException {
        if (sLoginUser != null) return sLoginUser;
        Class<LoginUser> clazz = LoginUser.class;
        synchronized (LoginUser.class) {
            if (sLoginUser != null) return sLoginUser;
            sLoginUser = LoginUser.login(conf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sLoginUser;
        }
    }

    private static User login(TachyonConf conf) throws IOException {
        AuthType authType = conf.getEnum("tachyon.security.authentication.type", AuthType.class);
        LoginUser.checkSecurityEnabled(authType);
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(authType.getAuthName(), subject, null, new TachyonJaasConfiguration());
            loginContext.login();
            Set<User> userSet = subject.getPrincipals(User.class);
            if (userSet.isEmpty()) {
                throw new LoginException("No Tachyon User is found.");
            }
            if (userSet.size() > 1) {
                throw new LoginException("More than one Tachyon User is found");
            }
            return userSet.iterator().next();
        }
        catch (LoginException e) {
            throw new IOException("Fail to login", e);
        }
    }

    private static void checkSecurityEnabled(AuthType authType) {
        if (authType != AuthType.SIMPLE && authType != AuthType.CUSTOM) {
            throw new UnsupportedOperationException("User is not supported in " + authType.getAuthName() + " mode");
        }
    }
}

