/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import io.netty.buffer.ByteBuf;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;

public final class RPCErrorResponse
extends RPCResponse {
    private final RPCResponse.Status mStatus;

    public RPCErrorResponse(RPCResponse.Status status) {
        this.mStatus = status;
    }

    public static RPCErrorResponse decode(ByteBuf in) {
        return new RPCErrorResponse(RPCResponse.Status.fromShort(in.readShort()));
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeShort((int)this.mStatus.getId());
    }

    @Override
    public int getEncodedLength() {
        return 2;
    }

    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_ERROR_RESPONSE;
    }

    public String toString() {
        return "RPCErrorResponse(" + (Object)((Object)this.mStatus) + ")";
    }
}

