/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;

@ChannelHandler.Sharable
public final class ClientHandler
extends SimpleChannelInboundHandler<RPCMessage> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final HashSet<ResponseListener> mListeners = new HashSet(4);

    public void addListener(ResponseListener listener) {
        this.mListeners.add((ResponseListener)Preconditions.checkNotNull((Object)listener));
    }

    public void removeListener(ResponseListener listener) {
        this.mListeners.remove(listener);
    }

    public void channelRead0(ChannelHandlerContext ctx, RPCMessage msg) throws IOException {
        if (!(msg instanceof RPCResponse)) {
            throw new IllegalArgumentException("No handler implementation for rpc message type: " + msg.getType());
        }
        this.handleResponse(ctx, (RPCResponse)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("Exception thrown while processing request", cause);
        ctx.close();
    }

    private void handleResponse(ChannelHandlerContext ctx, RPCResponse resp) throws IOException {
        for (ResponseListener listener : this.mListeners) {
            listener.onResponseReceived(resp);
        }
    }

    public static interface ResponseListener {
        public void onResponseReceived(RPCResponse var1);
    }
}

