/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file.options;

import tachyon.client.ClientContext;
import tachyon.client.UnderStorageType;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.thrift.MkdirTOptions;

public final class MkdirOptions {
    private final boolean mRecursive;
    private final UnderStorageType mUnderStorageType;

    public static MkdirOptions defaults() {
        return new Builder(ClientContext.getConf()).build();
    }

    private MkdirOptions(Builder builder) {
        this.mRecursive = builder.mRecursive;
        this.mUnderStorageType = builder.mUnderStorageType;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mUnderStorageType;
    }

    public MkdirTOptions toThrift() {
        MkdirTOptions options = new MkdirTOptions();
        options.setPersisted(this.mUnderStorageType.isSyncPersist());
        options.setRecursive(this.mRecursive);
        return options;
    }

    public static class Builder {
        private boolean mRecursive = false;
        private UnderStorageType mUnderStorageType;

        public Builder(TachyonConf conf) {
            WriteType defaultWriteType = conf.getEnum("tachyon.user.file.writetype.default", WriteType.class);
            this.mUnderStorageType = defaultWriteType.getUnderStorageType();
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public Builder setUnderStorageType(UnderStorageType underStorageType) {
            this.mUnderStorageType = underStorageType;
            return this;
        }

        public Builder setWriteType(WriteType writeType) {
            this.mUnderStorageType = writeType.getUnderStorageType();
            return this;
        }

        public MkdirOptions build() {
            return new MkdirOptions(this);
        }
    }
}

