/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import java.io.IOException;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.DeleteOptions;
import tachyon.client.file.options.FreeOptions;
import tachyon.client.file.options.GetInfoOptions;
import tachyon.client.file.options.ListStatusOptions;
import tachyon.client.file.options.LoadMetadataOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.client.file.options.MountOptions;
import tachyon.client.file.options.OpenOptions;
import tachyon.client.file.options.RenameOptions;
import tachyon.client.file.options.SetStateOptions;
import tachyon.client.file.options.UnmountOptions;
import tachyon.exception.FileAlreadyExistsException;
import tachyon.exception.FileDoesNotExistException;
import tachyon.exception.InvalidPathException;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;

interface TachyonFileSystemCore {
    public TachyonFile create(TachyonURI var1, CreateOptions var2) throws IOException, FileAlreadyExistsException, InvalidPathException, TachyonException;

    public void delete(TachyonFile var1, DeleteOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public void free(TachyonFile var1, FreeOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public FileInfo getInfo(TachyonFile var1, GetInfoOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public List<FileInfo> listStatus(TachyonFile var1, ListStatusOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public TachyonFile loadMetadata(TachyonURI var1, LoadMetadataOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public boolean mkdir(TachyonURI var1, MkdirOptions var2) throws IOException, FileAlreadyExistsException, InvalidPathException, TachyonException;

    public boolean mount(TachyonURI var1, TachyonURI var2, MountOptions var3) throws IOException, TachyonException;

    public TachyonFile openIfExists(TachyonURI var1, OpenOptions var2) throws IOException, TachyonException;

    public boolean rename(TachyonFile var1, TachyonURI var2, RenameOptions var3) throws IOException, FileDoesNotExistException, TachyonException;

    public void setState(TachyonFile var1, SetStateOptions var2) throws IOException, FileDoesNotExistException, TachyonException;

    public boolean unmount(TachyonURI var1, UnmountOptions var2) throws IOException, TachyonException;
}

