/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.FileSystemMasterClient;
import tachyon.client.file.FileSystemContext;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.TachyonFileSystemCore;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.DeleteOptions;
import tachyon.client.file.options.FreeOptions;
import tachyon.client.file.options.GetInfoOptions;
import tachyon.client.file.options.ListStatusOptions;
import tachyon.client.file.options.LoadMetadataOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.client.file.options.MountOptions;
import tachyon.client.file.options.OpenOptions;
import tachyon.client.file.options.RenameOptions;
import tachyon.client.file.options.SetStateOptions;
import tachyon.client.file.options.UnmountOptions;
import tachyon.exception.ExceptionMessage;
import tachyon.exception.FileAlreadyExistsException;
import tachyon.exception.FileDoesNotExistException;
import tachyon.exception.InvalidPathException;
import tachyon.exception.TachyonException;
import tachyon.exception.TachyonExceptionType;
import tachyon.thrift.FileInfo;

public abstract class AbstractTachyonFileSystem
implements TachyonFileSystemCore {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    protected FileSystemContext mContext = FileSystemContext.INSTANCE;

    protected AbstractTachyonFileSystem() {
    }

    @Override
    public TachyonFile create(TachyonURI path, CreateOptions options) throws FileAlreadyExistsException, IOException, InvalidPathException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long fileId = masterClient.create(path.getPath(), options);
            TachyonFile tachyonFile = new TachyonFile(fileId);
            return tachyonFile;
        }
        catch (TachyonException e) {
            if (e.getType() == TachyonExceptionType.BLOCK_INFO) {
                throw new FileAlreadyExistsException(e.getMessage(), (Throwable)e);
            }
            TachyonException.unwrap(e, FileAlreadyExistsException.class);
            TachyonException.unwrap(e, InvalidPathException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void delete(TachyonFile file, DeleteOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.deleteFile(file.getFileId(), options.isRecursive());
            LOG.info("Deleted file " + file.getFileId() + " from both Tachyon Storage and under file system");
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void free(TachyonFile file, FreeOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.free(file.getFileId(), options.isRecursive());
            LOG.info("Removed file " + file.getFileId() + " from Tachyon Storage");
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public FileInfo getInfo(TachyonFile file, GetInfoOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            FileInfo fileInfo = masterClient.getFileInfo(file.getFileId());
            return fileInfo;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public List<FileInfo> listStatus(TachyonFile file, ListStatusOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            List<FileInfo> list = masterClient.getFileInfoList(file.getFileId());
            return list;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public TachyonFile loadMetadata(TachyonURI path, LoadMetadataOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long fileId = masterClient.loadMetadata(path.getPath(), options.isRecursive());
            LOG.info("Loaded file " + path.getPath() + (options.isRecursive() ? " recursively" : ""));
            TachyonFile tachyonFile = new TachyonFile(fileId);
            return tachyonFile;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public boolean mkdir(TachyonURI path, MkdirOptions options) throws IOException, FileAlreadyExistsException, InvalidPathException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean result = masterClient.mkdir(path.getPath(), options);
            if (result) {
                LOG.info("Created directory " + path.getPath());
            }
            boolean bl = result;
            return bl;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileAlreadyExistsException.class);
            TachyonException.unwrap(e, InvalidPathException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mount(TachyonURI tachyonPath, TachyonURI ufsPath, MountOptions options) throws IOException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean bl = masterClient.mount(tachyonPath, ufsPath);
            return bl;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    public TachyonFile open(TachyonURI path, OpenOptions openOptions) throws IOException, InvalidPathException, TachyonException {
        TachyonFile f = this.openIfExists(path, openOptions);
        if (f == null) {
            throw new InvalidPathException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(path));
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TachyonFile openIfExists(TachyonURI path, OpenOptions openOptions) throws IOException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long fileId = masterClient.getFileId(path.getPath());
            if (fileId == -1L) {
                TachyonFile tachyonFile = null;
                return tachyonFile;
            }
            TachyonFile tachyonFile = new TachyonFile(fileId);
            return tachyonFile;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public boolean rename(TachyonFile src, TachyonURI dst, RenameOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean result = masterClient.renameFile(src.getFileId(), dst.getPath());
            if (result) {
                LOG.info("Renamed file " + src.getFileId() + " to " + dst.getPath());
            }
            boolean bl = result;
            return bl;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public void setState(TachyonFile file, SetStateOptions options) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        Boolean pinned = options.getPinned();
        try {
            if (pinned != null) {
                masterClient.setPinned(file.getFileId(), pinned);
                LOG.info(pinned != false ? "Pinned" : "Unpinned file " + file.getFileId());
            }
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unmount(TachyonURI tachyonPath, UnmountOptions options) throws IOException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean bl = masterClient.unmount(tachyonPath);
            return bl;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }
}

