/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;

public enum WriteType {
    MUST_CACHE(1),
    TRY_CACHE(2),
    CACHE_THROUGH(3),
    THROUGH(4),
    ASYNC_THROUGH(5);

    private final int mValue;

    private WriteType(int value) {
        this.mValue = value;
    }

    public TachyonStorageType getTachyonStorageType() {
        if (this.isCache()) {
            return TachyonStorageType.STORE;
        }
        return TachyonStorageType.NO_STORE;
    }

    public UnderStorageType getUnderStorageType() {
        if (this.isThrough()) {
            return UnderStorageType.SYNC_PERSIST;
        }
        return UnderStorageType.NO_PERSIST;
    }

    public int getValue() {
        return this.mValue;
    }

    @Deprecated
    public boolean isAsync() {
        return this.mValue == WriteType.ASYNC_THROUGH.mValue;
    }

    public boolean isCache() {
        return this.mValue == WriteType.MUST_CACHE.mValue || this.mValue == WriteType.CACHE_THROUGH.mValue || this.mValue == WriteType.TRY_CACHE.mValue || this.mValue == WriteType.ASYNC_THROUGH.mValue;
    }

    public boolean isMustCache() {
        return this.mValue == WriteType.MUST_CACHE.mValue || this.mValue == WriteType.ASYNC_THROUGH.mValue;
    }

    public boolean isThrough() {
        return this.mValue == WriteType.CACHE_THROUGH.mValue || this.mValue == WriteType.THROUGH.mValue;
    }
}

