/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.AbstractTachyonFS;
import tachyon.client.BlockMasterClient;
import tachyon.client.ClientContext;
import tachyon.client.FileSystemMasterClient;
import tachyon.client.RawTableMasterClient;
import tachyon.client.TachyonFile;
import tachyon.client.block.BlockStoreContext;
import tachyon.client.file.FileSystemContext;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.client.table.RawTable;
import tachyon.conf.TachyonConf;
import tachyon.exception.ExceptionMessage;
import tachyon.exception.TachyonException;
import tachyon.thrift.DependencyInfo;
import tachyon.thrift.FileBlockInfo;
import tachyon.thrift.FileInfo;
import tachyon.thrift.RawTableInfo;
import tachyon.thrift.WorkerInfo;
import tachyon.util.io.FileUtils;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.ClientMetrics;
import tachyon.worker.WorkerClient;

@Deprecated
public class TachyonFS
extends AbstractTachyonFS {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final int mUserFailedSpaceRequestLimits;
    private final FileSystemMasterClient mFSMasterClient;
    private final BlockMasterClient mBlockMasterClient;
    private final RawTableMasterClient mRawTableMasterClient;
    private final InetSocketAddress mMasterAddress;
    private final WorkerClient mWorkerClient;
    private final Closer mCloser = Closer.create();
    private final boolean mZookeeperMode;
    private final Map<String, FileInfo> mPathToClientFileInfo = new HashMap<String, FileInfo>();
    private final Map<Long, FileInfo> mIdToClientFileInfo = new HashMap<Long, FileInfo>();
    private final Map<Long, Set<Integer>> mLockedBlockIds = new HashMap<Long, Set<Integer>>();
    private final Map<Long, String> mLockedBlockIdToPath = new HashMap<Long, String>();
    private final AtomicInteger mBlockLockId = new AtomicInteger(0);
    private TachyonURI mRootUri = null;
    private ClientMetrics mClientMetrics = new ClientMetrics();

    @Deprecated
    public static synchronized TachyonFS get(String tachyonPath) {
        return TachyonFS.get(new TachyonURI(tachyonPath), ClientContext.getConf());
    }

    @Deprecated
    public static synchronized TachyonFS get(TachyonURI tachyonURI) {
        return TachyonFS.get(tachyonURI, ClientContext.getConf());
    }

    public static synchronized TachyonFS get(TachyonURI tachyonURI, TachyonConf tachyonConf) {
        Preconditions.checkArgument((tachyonConf != null ? 1 : 0) != 0, (Object)"TachyonConf cannot be null.");
        Preconditions.checkArgument((tachyonURI != null ? 1 : 0) != 0, (Object)"Tachyon URI cannot be null. Use tachyon://host:port/ ,tachyon-ft://host:port/.");
        String scheme = tachyonURI.getScheme();
        Preconditions.checkNotNull((Object)scheme, (Object)"Tachyon scheme cannot be null. Use tachyon or tachyon-ft.");
        Preconditions.checkNotNull((Object)tachyonURI.getHost(), (Object)"Tachyon hostname cannot be null.");
        Preconditions.checkState((tachyonURI.getPort() != -1 ? 1 : 0) != 0, (Object)"Tachyon URI must have a port number.");
        Preconditions.checkState(("tachyon".equals(scheme) || "tachyon-ft".equals(scheme) ? 1 : 0) != 0, (Object)"Tachyon scheme must be either tachyon or tachyon-ft.");
        boolean useZookeeper = scheme.equals("tachyon-ft");
        tachyonConf.set("tachyon.zookeeper.enabled", Boolean.toString(useZookeeper));
        tachyonConf.set("tachyon.master.hostname", tachyonURI.getHost());
        tachyonConf.set("tachyon.master.port", Integer.toString(tachyonURI.getPort()));
        return TachyonFS.get(tachyonConf);
    }

    public static synchronized TachyonFS get(String masterHost, int masterPort, boolean zkMode) {
        TachyonConf tachyonConf = ClientContext.getConf();
        tachyonConf.set("tachyon.master.hostname", masterHost);
        tachyonConf.set("tachyon.master.port", Integer.toString(masterPort));
        tachyonConf.set("tachyon.zookeeper.enabled", Boolean.toString(zkMode));
        return TachyonFS.get(tachyonConf);
    }

    public static synchronized TachyonFS get(TachyonConf tachyonConf) {
        Preconditions.checkArgument((tachyonConf != null ? 1 : 0) != 0, (Object)"TachyonConf cannot be null.");
        return new TachyonFS(tachyonConf);
    }

    private TachyonFS(TachyonConf tachyonConf) {
        super(tachyonConf);
        this.mMasterAddress = NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.MASTER_RPC, tachyonConf);
        this.mZookeeperMode = this.mTachyonConf.getBoolean("tachyon.zookeeper.enabled");
        this.mFSMasterClient = (FileSystemMasterClient)this.mCloser.register((Closeable)FileSystemContext.INSTANCE.acquireMasterClient());
        this.mBlockMasterClient = (BlockMasterClient)this.mCloser.register((Closeable)BlockStoreContext.INSTANCE.acquireMasterClient());
        this.mRawTableMasterClient = (RawTableMasterClient)this.mCloser.register((Closeable)new RawTableMasterClient(this.mMasterAddress, this.mTachyonConf));
        this.mWorkerClient = (WorkerClient)this.mCloser.register((Closeable)BlockStoreContext.INSTANCE.acquireWorkerClient());
        this.mUserFailedSpaceRequestLimits = this.mTachyonConf.getInt("tachyon.user.failed.space.request.limits");
        String scheme = this.mZookeeperMode ? "tachyon-ft" : "tachyon";
        String authority = this.mMasterAddress.getHostName() + ":" + this.mMasterAddress.getPort();
        this.mRootUri = new TachyonURI(scheme, authority, "/");
    }

    synchronized void accessLocalBlock(long blockId) throws IOException {
        if (this.mWorkerClient.isLocal()) {
            this.mWorkerClient.accessBlock(blockId);
        }
    }

    synchronized void addCheckpoint(long fid) throws IOException {
        throw new UnsupportedOperationException("AddCheckpoint is not unsupported");
    }

    synchronized boolean asyncCheckpoint(long fid) throws IOException {
        return this.mWorkerClient.asyncCheckpoint(fid);
    }

    public synchronized void cacheBlock(long blockId) throws IOException {
        this.mWorkerClient.cacheBlock(blockId);
    }

    public synchronized void cancelBlock(long blockId) throws IOException {
        this.mWorkerClient.cancelBlock(blockId);
    }

    @Override
    public synchronized void close() throws IOException {
        this.mCloser.close();
    }

    synchronized void completeFile(long fid) throws IOException {
        try {
            this.mFSMasterClient.completeFile(fid);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public synchronized int createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws IOException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public synchronized long createFile(TachyonURI path, TachyonURI ufsPath, long blockSizeBytes, boolean recursive) throws IOException {
        this.validateUri(path);
        try {
            if (blockSizeBytes > 0L) {
                CreateOptions options = new CreateOptions.Builder(ClientContext.getConf()).setBlockSizeBytes(blockSizeBytes).setRecursive(recursive).build();
                return this.mFSMasterClient.create(path.getPath(), options);
            }
            return this.mFSMasterClient.loadMetadata(path.getPath(), recursive);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized long createRawTable(TachyonURI path, int columns) throws IOException {
        return this.createRawTable(path, columns, ByteBuffer.allocate(0));
    }

    public synchronized long createRawTable(TachyonURI path, int columns, ByteBuffer metadata) throws IOException {
        this.validateUri(path);
        int maxColumns = this.mTachyonConf.getInt("tachyon.max.columns");
        if (columns < 1 || columns > maxColumns) {
            throw new IOException("Column count " + columns + " is smaller than 1 or " + "bigger than " + maxColumns);
        }
        return this.mRawTableMasterClient.createRawTable(path, columns, metadata);
    }

    @Override
    public synchronized boolean delete(long fileId, TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        fileId = this.getValidFileId(fileId, path.getPath());
        try {
            return this.mFSMasterClient.deleteFile(fileId, recursive);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized boolean exist(TachyonURI path) throws IOException {
        try {
            FileInfo info = this.getFileStatus(-1L, path, false);
            return info != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public synchronized long getBlockId(long fileId, int blockIndex) throws IOException {
        FileInfo info = this.getFileStatus(fileId, true);
        if (info == null) {
            throw new IOException("File " + fileId + " does not exist.");
        }
        if (info.blockIds.size() > blockIndex) {
            return info.blockIds.get(blockIndex);
        }
        try {
            return this.mFSMasterClient.getFileBlockInfo((long)fileId, (int)blockIndex).blockInfo.getBlockId();
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    synchronized int getBlockLockId() {
        return this.mBlockLockId.getAndIncrement();
    }

    synchronized FileBlockInfo getClientBlockInfo(long fileId, int blockIndex) throws IOException {
        try {
            return this.mFSMasterClient.getFileBlockInfo(fileId, blockIndex);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public synchronized DependencyInfo getClientDependencyInfo(int depId) throws IOException {
        throw new UnsupportedOperationException("operation not supported");
    }

    ClientMetrics getClientMetrics() {
        return this.mClientMetrics;
    }

    public synchronized TachyonFile getFile(long fid) throws IOException {
        return this.getFile(fid, true);
    }

    public synchronized TachyonFile getFile(long fid, boolean useCachedMetadata) throws IOException {
        FileInfo fileInfo = this.getFileStatus(fid, TachyonURI.EMPTY_URI, useCachedMetadata);
        if (fileInfo == null) {
            return null;
        }
        return new TachyonFile(this, fid, this.mTachyonConf);
    }

    public synchronized TachyonFile getFile(TachyonURI path) throws IOException {
        this.validateUri(path);
        return this.getFile(path, false);
    }

    public synchronized TachyonFile getFile(TachyonURI path, boolean useCachedMetadata) throws IOException {
        this.validateUri(path);
        FileInfo fileInfo = this.getFileStatus(-1L, path, useCachedMetadata);
        if (fileInfo == null) {
            return null;
        }
        return new TachyonFile(this, fileInfo.getFileId(), this.mTachyonConf);
    }

    private long getValidFileId(long fileId, String path) throws IOException {
        if (fileId == -1L && (fileId = this.mFSMasterClient.getFileId(path)) == -1L) {
            throw new IOException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(path));
        }
        return fileId;
    }

    public synchronized List<FileBlockInfo> getFileBlocks(long fid) throws IOException {
        try {
            return this.mFSMasterClient.getFileBlockInfoList(fid);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized long getFileId(TachyonURI path) {
        try {
            FileInfo fileInfo = this.getFileStatus(-1L, path, false);
            return fileInfo == null ? 1L : fileInfo.getFileId();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private synchronized <K> FileInfo getFileStatus(Map<K, FileInfo> cache, K key, long fileId, String path, boolean useCachedMetaData) throws IOException {
        FileInfo info = null;
        if (useCachedMetaData && (info = cache.get(key)) != null) {
            return info;
        }
        fileId = this.getValidFileId(fileId, path);
        try {
            info = this.mFSMasterClient.getFileInfo(fileId);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
        path = info.getPath();
        this.mIdToClientFileInfo.put(fileId, info);
        this.mPathToClientFileInfo.put(path, info);
        return info;
    }

    public synchronized FileInfo getFileStatus(long fileId, TachyonURI path, boolean useCachedMetadata) throws IOException {
        fileId = this.getValidFileId(fileId, path.getPath());
        return this.getFileStatus(this.mIdToClientFileInfo, fileId, fileId, TachyonURI.EMPTY_URI.getPath(), useCachedMetadata);
    }

    @Override
    public FileInfo getFileStatus(long fileId, TachyonURI path) throws IOException {
        return this.getFileStatus(fileId, path, false);
    }

    public synchronized FileInfo getFileStatus(long fileId, boolean useCachedMetadata) throws IOException {
        return this.getFileStatus(fileId, TachyonURI.EMPTY_URI, useCachedMetadata);
    }

    public synchronized String getLocalBlockTemporaryPath(long blockId, long initialBytes) throws IOException {
        String blockPath = this.mWorkerClient.requestBlockLocation(blockId, initialBytes);
        FileUtils.createBlockPath(blockPath);
        return blockPath;
    }

    public synchronized RawTable getRawTable(long id) throws IOException {
        RawTableInfo rawTableInfo = this.mRawTableMasterClient.getClientRawTableInfo(id);
        return new RawTable(this, rawTableInfo);
    }

    public synchronized RawTable getRawTable(TachyonURI path) throws IOException {
        this.validateUri(path);
        RawTableInfo rawTableInfo = this.mRawTableMasterClient.getClientRawTableInfo(path);
        return new RawTable(this, rawTableInfo);
    }

    public synchronized String getUfsAddress() throws IOException {
        return this.mFSMasterClient.getUfsAddress();
    }

    @Override
    public synchronized TachyonURI getUri() {
        return this.mRootUri;
    }

    long getSessionId() throws IOException {
        return this.mWorkerClient.getSessionId();
    }

    public synchronized long getUsedBytes() throws IOException {
        throw new UnsupportedOperationException("Currently unsupported.");
    }

    public synchronized long getCapacityBytes() throws IOException {
        throw new UnsupportedOperationException("Currently unsupported.");
    }

    public synchronized InetSocketAddress getWorkerDataServerAddress() {
        return this.mWorkerClient.getDataServerAddress();
    }

    public synchronized List<WorkerInfo> getWorkersInfo() throws IOException {
        return this.mBlockMasterClient.getWorkerInfoList();
    }

    public synchronized boolean hasLocalWorker() {
        return this.mWorkerClient.isLocal();
    }

    public synchronized boolean isConnected() {
        return this.mFSMasterClient.isConnected();
    }

    synchronized boolean isDirectory(int fid) {
        return this.mIdToClientFileInfo.get((Object)Integer.valueOf((int)fid)).isFolder;
    }

    @Override
    public synchronized List<FileInfo> listStatus(TachyonURI path) throws IOException {
        this.validateUri(path);
        try {
            return this.mFSMasterClient.getFileInfoList(this.getFileStatus(-1L, path).getFileId());
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    synchronized String lockBlock(long blockId, int blockLockId) throws IOException {
        if (blockId <= 0L || blockLockId < 0) {
            return null;
        }
        if (this.mLockedBlockIds.containsKey(blockId)) {
            this.mLockedBlockIds.get(blockId).add(blockLockId);
            return this.mLockedBlockIdToPath.get(blockId);
        }
        if (!this.mWorkerClient.isLocal()) {
            return null;
        }
        String blockPath = this.mWorkerClient.lockBlock(blockId);
        if (blockPath != null) {
            HashSet<Integer> lockIds = new HashSet<Integer>(4);
            lockIds.add(blockLockId);
            this.mLockedBlockIds.put(blockId, lockIds);
            this.mLockedBlockIdToPath.put(blockId, blockPath);
            return blockPath;
        }
        return null;
    }

    @Override
    public synchronized boolean mkdirs(TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        try {
            MkdirOptions options = new MkdirOptions.Builder(ClientContext.getConf()).setRecursive(recursive).build();
            return this.mFSMasterClient.mkdir(path.getPath(), options);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized void pinFile(long fid) throws IOException {
        this.setPinned(fid, true);
    }

    @Override
    public synchronized boolean freepath(long fileId, TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        fileId = this.getValidFileId(fileId, path.getPath());
        try {
            return this.mFSMasterClient.free(fileId, recursive);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized boolean promoteBlock(long blockId) throws IOException {
        if (this.mWorkerClient.isLocal()) {
            return this.mWorkerClient.promoteBlock(blockId);
        }
        return false;
    }

    @Override
    public synchronized boolean rename(long fileId, TachyonURI srcPath, TachyonURI dstPath) throws IOException {
        this.validateUri(srcPath);
        this.validateUri(dstPath);
        fileId = this.getValidFileId(fileId, srcPath.getPath());
        try {
            return this.mFSMasterClient.renameFile(fileId, dstPath.getPath());
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public synchronized void reportLostFile(long fileId) throws IOException {
        try {
            this.mFSMasterClient.reportLostFile(fileId);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public synchronized void requestFilesInDependency(int depId) throws IOException {
        throw new UnsupportedOperationException("operation not supported");
    }

    public synchronized long requestSpace(long blockId, long requestSpaceBytes) throws IOException {
        if (!this.hasLocalWorker()) {
            return -1L;
        }
        long userQuotaUnitBytes = this.mTachyonConf.getBytes("tachyon.user.quota.unit.bytes");
        long toRequestSpaceBytes = Math.max(requestSpaceBytes, userQuotaUnitBytes);
        for (int attempt = 0; attempt < this.mUserFailedSpaceRequestLimits; ++attempt) {
            if (!this.mWorkerClient.requestSpace(blockId, toRequestSpaceBytes)) continue;
            return toRequestSpaceBytes;
        }
        return 0L;
    }

    public synchronized void setPinned(long fid, boolean pinned) throws IOException {
        try {
            this.mFSMasterClient.setPinned(fid, pinned);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        return (this.mZookeeperMode ? "tachyon-ft://" : "tachyon://") + this.mMasterAddress.toString();
    }

    synchronized boolean unlockBlock(long blockId, int blockLockId) throws IOException {
        if (blockId <= 0L || blockLockId < 0) {
            return false;
        }
        if (!this.mLockedBlockIds.containsKey(blockId)) {
            return true;
        }
        Set<Integer> lockIds = this.mLockedBlockIds.get(blockId);
        lockIds.remove(blockLockId);
        if (!lockIds.isEmpty()) {
            return true;
        }
        if (!this.mWorkerClient.isLocal()) {
            return false;
        }
        this.mLockedBlockIdToPath.remove(blockId);
        this.mLockedBlockIds.remove(blockId);
        return this.mWorkerClient.unlockBlock(blockId);
    }

    public synchronized void unpinFile(long fid) throws IOException {
        this.setPinned(fid, false);
    }

    public synchronized void updateRawTableMetadata(long id, ByteBuffer metadata) throws IOException {
        this.mRawTableMasterClient.updateRawTableMetadata(id, metadata);
    }

    private void validateUri(TachyonURI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI cannot be null.");
        Preconditions.checkArgument((uri.isPathAbsolute() || TachyonURI.EMPTY_URI.equals(uri) ? 1 : 0) != 0, (Object)"URI must be absolute, unless it's empty.");
        Preconditions.checkArgument((!uri.hasScheme() || this.mRootUri.getScheme().equals(uri.getScheme()) ? 1 : 0) != 0, (Object)("URI's scheme: " + uri.getScheme() + " must match the file system's scheme: " + this.mRootUri.getScheme() + ", unless it doesn't have a scheme."));
        Preconditions.checkArgument((!uri.hasAuthority() || this.mRootUri.getAuthority().equals(uri.getAuthority()) ? 1 : 0) != 0, (Object)("URI's authority: " + uri.getAuthority() + " must match the file system's authority: " + this.mRootUri.getAuthority() + ", unless it doesn't have an authority."));
    }
}

