/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.tuple;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;
import org.storynode.pigeon.tuple.Tuple;

public final class Triplet<T1, T2, T3>
extends Tuple {
    private final T1 first;
    private final T2 second;
    private final T3 third;

    public Triplet(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public T3 third() {
        return this.third;
    }

    @Override
    public int cardinality() {
        return 3;
    }

    @Override
    @NotNull
    public Option<Object> at(int index) {
        return switch (index) {
            case 0 -> Option.of(this.first);
            case 1 -> Option.of(this.second);
            case 2 -> Option.of(this.third);
            default -> Option.none();
        };
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public String toString() {
        return "Triplet[first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", third=" + String.valueOf(this.third) + "]";
    }
}

