/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.result;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.error.UnwrapException;
import org.storynode.pigeon.result.Result;

public class Ok<T, E>
extends Result<T, E> {
    private final T value;

    protected Ok(@NotNull T value) {
        this.value = value;
    }

    @Override
    public boolean isOk() {
        return true;
    }

    @Override
    public T unwrap() {
        return this.value;
    }

    @Override
    public E unwrapError() throws UnwrapException {
        throw new UnwrapException("Cannot unwrap error on an Ok<> value");
    }

    @Override
    public T orElseGet(Supplier<T> defaultValueSupplier) {
        return this.value;
    }

    @Override
    public <U> Result<U, E> map(@NotNull Function<? super T, ? extends U> fn) {
        return Result.ok(fn.apply(this.value));
    }

    @Override
    public <U> Result<U, E> flatMap(@NotNull Function<? super T, ? extends Result<U, E>> fn) {
        return fn.apply(this.value);
    }

    @Override
    public <U> Result<T, U> mapError(@NotNull Function<? super E, ? extends U> fn) {
        return Result.ok(this.value);
    }

    @Override
    public Result<T, E> ifOkOrElse(@NotNull Consumer<T> whenOk, Consumer<E> whenError) {
        whenOk.accept(this.unwrap());
        return this;
    }

    @Override
    public T orElse(T defaultValue) {
        return this.unwrap();
    }

    @Override
    public <U> Result<U, E> and(Result<U, E> res) {
        return res;
    }

    @Override
    public <U> Result<U, E> andThen(Function<T, Result<U, E>> res) {
        return this.and(res.apply(this.value));
    }
}

